// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#include "third_party/blink/renderer/bindings/modules/v8/v8_rtc_codec_specifics_vp_8.h"

#include "third_party/blink/renderer/bindings/core/v8/generated_code_helper.h"
#include "third_party/blink/renderer/bindings/core/v8/native_value_traits_impl.h"
#include "third_party/blink/renderer/bindings/core/v8/to_v8_traits.h"
#include "third_party/blink/renderer/platform/bindings/exception_messages.h"
#include "third_party/blink/renderer/platform/bindings/exception_state.h"
#include "third_party/blink/renderer/platform/bindings/v8_per_isolate_data.h"

namespace blink {



namespace  {

const std::string_view kOwnPropertyNames[] = {
"beginningOfPartition",
"keyIdx",
"layerSync",
"nonReference",
"partitionId",
"pictureId",
"temporalIdx",
"tl0PicIdx",
};


}  // namespace 

RTCCodecSpecificsVP8* RTCCodecSpecificsVP8::Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state) {
  RTCCodecSpecificsVP8* dictionary = MakeGarbageCollected<RTCCodecSpecificsVP8>(isolate);
if (v8_value->IsNullOrUndefined()) {
  return dictionary;
}
if (!v8_value->IsObject()) {
  const char* const class_like_name = "RTCCodecSpecificsVP8";
exception_state.ThrowTypeError(ExceptionMessages::ValueNotOfType(class_like_name));
return nullptr;
}
dictionary->FillMembersFromV8Object(isolate, v8_value.As<v8::Object>(), exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return nullptr;
}
return dictionary;
}

 RTCCodecSpecificsVP8::RTCCodecSpecificsVP8() {
  
}

 RTCCodecSpecificsVP8::RTCCodecSpecificsVP8(v8::Isolate* isolate) {
  
}



























































void RTCCodecSpecificsVP8::Trace(Visitor* visitor) const {
  bindings::DictionaryBase::Trace(visitor);
}

void RTCCodecSpecificsVP8::FillTemplateProperties(Vector<std::string_view>& properties) const {
  static_assert(std::size(kOwnPropertyNames) == kOwnPropertyCount);
properties.AppendRange(std::cbegin(kOwnPropertyNames), std::cend(kOwnPropertyNames));
DCHECK_EQ(properties.size(), kTotalPropertyCount);
}

void RTCCodecSpecificsVP8::FillValuesImpl(ScriptState* script_state, base::span<v8::MaybeLocal<v8::Value>> values) const {
  CHECK_EQ(kOwnPropertyCount, values.size());
if (hasBeginningOfPartition()) {
  values[0] = ToV8Traits<IDLBoolean>::ToV8(script_state, member_beginning_of_partition_);
DCHECK(!values[0].IsEmpty());
}
if (hasKeyIdx()) {
  values[1] = ToV8Traits<IDLLong>::ToV8(script_state, member_key_idx_);
DCHECK(!values[1].IsEmpty());
}
if (hasLayerSync()) {
  values[2] = ToV8Traits<IDLBoolean>::ToV8(script_state, member_layer_sync_);
DCHECK(!values[2].IsEmpty());
}
if (hasNonReference()) {
  values[3] = ToV8Traits<IDLBoolean>::ToV8(script_state, member_non_reference_);
DCHECK(!values[3].IsEmpty());
}
if (hasPartitionId()) {
  values[4] = ToV8Traits<IDLLong>::ToV8(script_state, member_partition_id_);
DCHECK(!values[4].IsEmpty());
}
if (hasPictureId()) {
  values[5] = ToV8Traits<IDLShort>::ToV8(script_state, member_picture_id_);
DCHECK(!values[5].IsEmpty());
}
if (hasTemporalIdx()) {
  values[6] = ToV8Traits<IDLOctet>::ToV8(script_state, member_temporal_idx_);
DCHECK(!values[6].IsEmpty());
}
if (hasTl0PicIdx()) {
  values[7] = ToV8Traits<IDLShort>::ToV8(script_state, member_tl_0_pic_idx_);
DCHECK(!values[7].IsEmpty());
}
}

const void* RTCCodecSpecificsVP8::TemplateKey() const {
  static const void *s_key = &s_key;
return s_key;
}

v8::Local<v8::Object> RTCCodecSpecificsVP8::FillValues(ScriptState* script_state, v8::Local<v8::DictionaryTemplate> dict_template) const {
  v8::MaybeLocal<v8::Value> values[kTotalPropertyCount];
FillValuesImpl(script_state, values);
return dict_template->NewInstance(script_state->GetContext(), values);
}

void RTCCodecSpecificsVP8::FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state) {
  TryRethrowScope rethrow_scope(isolate, exception_state);
const char* const class_like_name = "RTCCodecSpecificsVP8";
DictionaryConversionContext dictionary_from_v8_context(isolate, class_like_name);
dictionary_from_v8_context.SetCurrentPropertyName("beginningOfPartition");
constexpr bool is_optional = false;
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
const auto& v8_own_member_names = GetV8OwnMemberNames(isolate);
if (!bindings::GetDictionaryMemberFromV8Object<IDLBoolean, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[0].Get(isolate), has_beginning_of_partition_, member_beginning_of_partition_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("keyIdx");
if (!bindings::GetDictionaryMemberFromV8Object<IDLLong, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[1].Get(isolate), has_key_idx_, member_key_idx_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("layerSync");
if (!bindings::GetDictionaryMemberFromV8Object<IDLBoolean, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[2].Get(isolate), has_layer_sync_, member_layer_sync_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("nonReference");
if (!bindings::GetDictionaryMemberFromV8Object<IDLBoolean, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[3].Get(isolate), has_non_reference_, member_non_reference_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("partitionId");
if (!bindings::GetDictionaryMemberFromV8Object<IDLLong, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[4].Get(isolate), has_partition_id_, member_partition_id_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("pictureId");
if (!bindings::GetDictionaryMemberFromV8Object<IDLShort, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[5].Get(isolate), has_picture_id_, member_picture_id_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("temporalIdx");
if (!bindings::GetDictionaryMemberFromV8Object<IDLOctet, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[6].Get(isolate), has_temporal_idx_, member_temporal_idx_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("tl0PicIdx");
if (!bindings::GetDictionaryMemberFromV8Object<IDLShort, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[7].Get(isolate), has_tl_0_pic_idx_, member_tl_0_pic_idx_, class_like_name, exception_state)) {
  return;
}
}

const base::span<const v8::Eternal<v8::Name>> RTCCodecSpecificsVP8::GetV8OwnMemberNames(v8::Isolate* isolate) {
  return V8PerIsolateData::From(isolate)->FindOrCreateEternalNameCache(kOwnPropertyNames, kOwnPropertyNames);
}


}  // namespace blink
