// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_RTC_AUDIO_SOURCE_STATS_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_RTC_AUDIO_SOURCE_STATS_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_rtc_media_source_stats.h"
#include "third_party/blink/renderer/modules/modules_export.h"

namespace blink {

class ExceptionState;

class MODULES_EXPORT RTCAudioSourceStats : public RTCMediaSourceStats {
  
  public:
static RTCAudioSourceStats* Create() {
  return MakeGarbageCollected<RTCAudioSourceStats>();
}
static RTCAudioSourceStats* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<RTCAudioSourceStats>(isolate);
}
static RTCAudioSourceStats* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  RTCAudioSourceStats();
explicit  RTCAudioSourceStats(v8::Isolate* isolate);

bool hasAudioLevel() const {
  return has_audio_level_;
}
double audioLevel() const {
  DCHECK(hasAudioLevel());
return member_audio_level_;
}
double getAudioLevelOr(double fallback_value) const {
  if (!hasAudioLevel()) {
  return fallback_value;
}
return member_audio_level_;
}
void setAudioLevel(double value) {
  member_audio_level_ = value;
has_audio_level_ = true;
}

bool hasEchoReturnLoss() const {
  return has_echo_return_loss_;
}
double echoReturnLoss() const {
  DCHECK(hasEchoReturnLoss());
return member_echo_return_loss_;
}
double getEchoReturnLossOr(double fallback_value) const {
  if (!hasEchoReturnLoss()) {
  return fallback_value;
}
return member_echo_return_loss_;
}
void setEchoReturnLoss(double value) {
  member_echo_return_loss_ = value;
has_echo_return_loss_ = true;
}

bool hasEchoReturnLossEnhancement() const {
  return has_echo_return_loss_enhancement_;
}
double echoReturnLossEnhancement() const {
  DCHECK(hasEchoReturnLossEnhancement());
return member_echo_return_loss_enhancement_;
}
double getEchoReturnLossEnhancementOr(double fallback_value) const {
  if (!hasEchoReturnLossEnhancement()) {
  return fallback_value;
}
return member_echo_return_loss_enhancement_;
}
void setEchoReturnLossEnhancement(double value) {
  member_echo_return_loss_enhancement_ = value;
has_echo_return_loss_enhancement_ = true;
}

bool hasTotalAudioEnergy() const {
  return has_total_audio_energy_;
}
double totalAudioEnergy() const {
  DCHECK(hasTotalAudioEnergy());
return member_total_audio_energy_;
}
double getTotalAudioEnergyOr(double fallback_value) const {
  if (!hasTotalAudioEnergy()) {
  return fallback_value;
}
return member_total_audio_energy_;
}
void setTotalAudioEnergy(double value) {
  member_total_audio_energy_ = value;
has_total_audio_energy_ = true;
}

bool hasTotalSamplesDuration() const {
  return has_total_samples_duration_;
}
double totalSamplesDuration() const {
  DCHECK(hasTotalSamplesDuration());
return member_total_samples_duration_;
}
double getTotalSamplesDurationOr(double fallback_value) const {
  if (!hasTotalSamplesDuration()) {
  return fallback_value;
}
return member_total_samples_duration_;
}
void setTotalSamplesDuration(double value) {
  member_total_samples_duration_ = value;
has_total_samples_duration_ = true;
}




void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = RTCMediaSourceStats::kTotalPropertyCount;
static constexpr size_t kOwnPropertyCount = 5;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillTemplateProperties(Vector<std::string_view>& properties) const override;
void FillValuesImpl(ScriptState* script_state, base::span<v8::MaybeLocal<v8::Value>> values) const;


void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
const void* TemplateKey() const override;
v8::Local<v8::Object> FillValues(ScriptState* script_state, v8::Local<v8::DictionaryTemplate> dict_template) const override;
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_audio_level_ = false;
bool has_echo_return_loss_ = false;
bool has_echo_return_loss_enhancement_ = false;
bool has_total_audio_energy_ = false;
bool has_total_samples_duration_ = false;

double member_audio_level_;
double member_echo_return_loss_;
double member_echo_return_loss_enhancement_;
double member_total_audio_energy_;
double member_total_samples_duration_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_RTC_AUDIO_SOURCE_STATS_H_
