// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_REWRITER_CREATE_CORE_OPTIONS_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_REWRITER_CREATE_CORE_OPTIONS_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_rewriter_format.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_rewriter_length.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_rewriter_tone.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"
#include "third_party/blink/renderer/platform/heap/collection_support/heap_vector.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

namespace blink {

class ExceptionState;

class MODULES_EXPORT RewriterCreateCoreOptions : public bindings::InputDictionaryBase {
  
  public:
static RewriterCreateCoreOptions* Create() {
  return MakeGarbageCollected<RewriterCreateCoreOptions>();
}
static RewriterCreateCoreOptions* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<RewriterCreateCoreOptions>(isolate);
}
static RewriterCreateCoreOptions* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  RewriterCreateCoreOptions();
explicit  RewriterCreateCoreOptions(v8::Isolate* isolate);

bool hasExpectedContextLanguages() const {
  return has_expected_context_languages_;
}
const Vector<String>& expectedContextLanguages() const {
  DCHECK(hasExpectedContextLanguages());
return member_expected_context_languages_;
}
Vector<String> getExpectedContextLanguagesOr(const Vector<String>& fallback_value) const;
Vector<String> getExpectedContextLanguagesOr(Vector<String>&& fallback_value) const;
void setExpectedContextLanguages(const Vector<String>& value);
void setExpectedContextLanguages(Vector<String>&& value);

bool hasExpectedInputLanguages() const {
  return has_expected_input_languages_;
}
const Vector<String>& expectedInputLanguages() const {
  DCHECK(hasExpectedInputLanguages());
return member_expected_input_languages_;
}
Vector<String> getExpectedInputLanguagesOr(const Vector<String>& fallback_value) const;
Vector<String> getExpectedInputLanguagesOr(Vector<String>&& fallback_value) const;
void setExpectedInputLanguages(const Vector<String>& value);
void setExpectedInputLanguages(Vector<String>&& value);

bool hasFormat() const {
  return true;
}
V8RewriterFormat format() const {
  return member_format_;
}
void setFormat(V8RewriterFormat value) {
  member_format_ = value;
}
void setFormat(V8RewriterFormat::Enum value) {
  member_format_ = V8RewriterFormat(value);
}

bool hasLength() const {
  return true;
}
V8RewriterLength length() const {
  return member_length_;
}
void setLength(V8RewriterLength value) {
  member_length_ = value;
}
void setLength(V8RewriterLength::Enum value) {
  member_length_ = V8RewriterLength(value);
}

bool hasOutputLanguage() const {
  return has_output_language_;
}
const String& outputLanguage() const {
  DCHECK(hasOutputLanguage());
return member_output_language_;
}
String getOutputLanguageOr(const String& fallback_value) const;
String getOutputLanguageOr(String&& fallback_value) const;
void setOutputLanguage(const String& value);
void setOutputLanguage(String&& value);

bool hasTone() const {
  return true;
}
V8RewriterTone tone() const {
  return member_tone_;
}
void setTone(V8RewriterTone value) {
  member_tone_ = value;
}
void setTone(V8RewriterTone::Enum value) {
  member_tone_ = V8RewriterTone(value);
}




void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 6;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_expected_context_languages_ = false;
bool has_expected_input_languages_ = false;
bool has_output_language_ = false;

Vector<String> member_expected_context_languages_;
Vector<String> member_expected_input_languages_;
V8RewriterFormat member_format_{V8RewriterFormat::Enum::kAsIs};
V8RewriterLength member_length_{V8RewriterLength::Enum::kAsIs};
String member_output_language_;
V8RewriterTone member_tone_{V8RewriterTone::Enum::kAsIs};


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_REWRITER_CREATE_CORE_OPTIONS_H_
