// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_PUBLIC_KEY_CREDENTIAL_REQUEST_OPTIONS_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_PUBLIC_KEY_CREDENTIAL_REQUEST_OPTIONS_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/core/typed_arrays/array_buffer_view_helpers.h"
#include "third_party/blink/renderer/core/typed_arrays/dom_typed_array.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"
#include "third_party/blink/renderer/platform/heap/collection_support/heap_vector.h"
#include "third_party/blink/renderer/platform/heap/member.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

namespace blink {

class AuthenticationExtensionsClientInputs;
class ExceptionState;
class PublicKeyCredentialDescriptor;
class V8UnionArrayBufferOrArrayBufferView;

class MODULES_EXPORT PublicKeyCredentialRequestOptions : public bindings::DictionaryBase {
  
  public:
static PublicKeyCredentialRequestOptions* Create() {
  return MakeGarbageCollected<PublicKeyCredentialRequestOptions>();
}
static PublicKeyCredentialRequestOptions* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<PublicKeyCredentialRequestOptions>(isolate);
}
static PublicKeyCredentialRequestOptions* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  PublicKeyCredentialRequestOptions();
explicit  PublicKeyCredentialRequestOptions(v8::Isolate* isolate);

bool hasAllowCredentials() const {
  return true;
}
const HeapVector<Member<PublicKeyCredentialDescriptor>>& allowCredentials() const {
  return member_allow_credentials_;
}
void setAllowCredentials(const HeapVector<Member<PublicKeyCredentialDescriptor>>& value);
void setAllowCredentials(HeapVector<Member<PublicKeyCredentialDescriptor>>&& value);

bool hasChallenge() const {
  return has_challenge_;
}
V8UnionArrayBufferOrArrayBufferView* challenge() const {
  DCHECK(hasChallenge());
return member_challenge_.Get();
}
V8UnionArrayBufferOrArrayBufferView* getChallengeOr(V8UnionArrayBufferOrArrayBufferView* fallback_value) const {
  if (!hasChallenge()) {
  return fallback_value;
}
return member_challenge_.Get();
}
void setChallenge(V8UnionArrayBufferOrArrayBufferView* value) {
  member_challenge_ = value;
has_challenge_ = true;
DCHECK(member_challenge_);
}

bool hasChallengeUrl() const {
  return has_challenge_url_;
}
const String& challengeUrl() const {
  DCHECK(hasChallengeUrl());
return member_challenge_url_;
}
String getChallengeUrlOr(const String& fallback_value) const;
String getChallengeUrlOr(String&& fallback_value) const;
void setChallengeUrl(const String& value);
void setChallengeUrl(String&& value);

bool hasExtensions() const {
  return has_extensions_;
}
AuthenticationExtensionsClientInputs* extensions() const {
  DCHECK(hasExtensions());
return member_extensions_.Get();
}
AuthenticationExtensionsClientInputs* getExtensionsOr(AuthenticationExtensionsClientInputs* fallback_value) const {
  if (!hasExtensions()) {
  return fallback_value;
}
return member_extensions_.Get();
}
void setExtensions(AuthenticationExtensionsClientInputs* value) {
  member_extensions_ = value;
has_extensions_ = true;
DCHECK(member_extensions_);
}

bool hasHints() const {
  return true;
}
const Vector<String>& hints() const {
  return member_hints_;
}
void setHints(const Vector<String>& value);
void setHints(Vector<String>&& value);

bool hasRpId() const {
  return has_rp_id_;
}
const String& rpId() const {
  DCHECK(hasRpId());
return member_rp_id_;
}
String getRpIdOr(const String& fallback_value) const;
String getRpIdOr(String&& fallback_value) const;
void setRpId(const String& value);
void setRpId(String&& value);

bool hasTimeout() const {
  return has_timeout_;
}
uint32_t timeout() const {
  DCHECK(hasTimeout());
return member_timeout_;
}
uint32_t getTimeoutOr(uint32_t fallback_value) const {
  if (!hasTimeout()) {
  return fallback_value;
}
return member_timeout_;
}
void setTimeout(uint32_t value) {
  member_timeout_ = value;
has_timeout_ = true;
}

bool hasUserVerification() const {
  return has_user_verification_;
}
const String& userVerification() const {
  DCHECK(hasUserVerification());
return member_user_verification_;
}
String getUserVerificationOr(const String& fallback_value) const;
String getUserVerificationOr(String&& fallback_value) const;
void setUserVerification(const String& value);
void setUserVerification(String&& value);




void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 8;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillTemplateProperties(Vector<std::string_view>& properties) const override;
void FillValuesImpl(ScriptState* script_state, base::span<v8::MaybeLocal<v8::Value>> values) const;


void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
const void* TemplateKey() const override;
v8::Local<v8::Object> FillValues(ScriptState* script_state, v8::Local<v8::DictionaryTemplate> dict_template) const override;
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_challenge_ = false;
bool has_challenge_url_ = false;
bool has_extensions_ = false;
bool has_rp_id_ = false;
bool has_timeout_ = false;
bool has_user_verification_ = false;

HeapVector<Member<PublicKeyCredentialDescriptor>> member_allow_credentials_;
Member<V8UnionArrayBufferOrArrayBufferView> member_challenge_;
String member_challenge_url_;
Member<AuthenticationExtensionsClientInputs> member_extensions_;
Vector<String> member_hints_;
String member_rp_id_;
uint32_t member_timeout_;
String member_user_verification_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_PUBLIC_KEY_CREDENTIAL_REQUEST_OPTIONS_H_
