// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_PROOFREAD_CORRECTION_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_PROOFREAD_CORRECTION_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_correction_type.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

namespace blink {

class ExceptionState;

class MODULES_EXPORT ProofreadCorrection : public bindings::DictionaryBase {
  
  public:
static ProofreadCorrection* Create() {
  return MakeGarbageCollected<ProofreadCorrection>();
}
static ProofreadCorrection* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<ProofreadCorrection>(isolate);
}
static ProofreadCorrection* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  ProofreadCorrection();
explicit  ProofreadCorrection(v8::Isolate* isolate);

bool hasCorrection() const {
  return has_correction_;
}
const String& correction() const {
  DCHECK(hasCorrection());
return member_correction_;
}
String getCorrectionOr(const String& fallback_value) const;
String getCorrectionOr(String&& fallback_value) const;
void setCorrection(const String& value);
void setCorrection(String&& value);

bool hasEndIndex() const {
  return has_end_index_;
}
uint64_t endIndex() const {
  DCHECK(hasEndIndex());
return member_end_index_;
}
uint64_t getEndIndexOr(uint64_t fallback_value) const {
  if (!hasEndIndex()) {
  return fallback_value;
}
return member_end_index_;
}
void setEndIndex(uint64_t value) {
  member_end_index_ = value;
has_end_index_ = true;
}

bool hasExplanation() const {
  return has_explanation_;
}
const String& explanation() const {
  DCHECK(hasExplanation());
return member_explanation_;
}
String getExplanationOr(const String& fallback_value) const;
String getExplanationOr(String&& fallback_value) const;
void setExplanation(const String& value);
void setExplanation(String&& value);

bool hasStartIndex() const {
  return has_start_index_;
}
uint64_t startIndex() const {
  DCHECK(hasStartIndex());
return member_start_index_;
}
uint64_t getStartIndexOr(uint64_t fallback_value) const {
  if (!hasStartIndex()) {
  return fallback_value;
}
return member_start_index_;
}
void setStartIndex(uint64_t value) {
  member_start_index_ = value;
has_start_index_ = true;
}

bool hasType() const {
  return has_type_;
}
V8CorrectionType type() const {
  DCHECK(hasType());
return member_type_;
}
V8CorrectionType getTypeOr(V8CorrectionType fallback_value) const {
  if (!hasType()) {
  return fallback_value;
}
return member_type_;
}
void setType(V8CorrectionType value) {
  member_type_ = value;
has_type_ = true;
}
void setType(V8CorrectionType::Enum value) {
  member_type_ = V8CorrectionType(value);
has_type_ = true;
}




void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 5;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillTemplateProperties(Vector<std::string_view>& properties) const override;
void FillValuesImpl(ScriptState* script_state, base::span<v8::MaybeLocal<v8::Value>> values) const;


void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
const void* TemplateKey() const override;
v8::Local<v8::Object> FillValues(ScriptState* script_state, v8::Local<v8::DictionaryTemplate> dict_template) const override;
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_correction_ = false;
bool has_end_index_ = false;
bool has_explanation_ = false;
bool has_start_index_ = false;
bool has_type_ = false;

String member_correction_;
uint64_t member_end_index_;
String member_explanation_;
uint64_t member_start_index_;
V8CorrectionType member_type_{static_cast<V8CorrectionType::Enum>(0)};


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_PROOFREAD_CORRECTION_H_
