// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#include "third_party/blink/renderer/bindings/modules/v8/v8_proofread_correction.h"

#include "third_party/blink/renderer/bindings/core/v8/generated_code_helper.h"
#include "third_party/blink/renderer/bindings/core/v8/native_value_traits_impl.h"
#include "third_party/blink/renderer/bindings/core/v8/to_v8_traits.h"
#include "third_party/blink/renderer/platform/bindings/exception_messages.h"
#include "third_party/blink/renderer/platform/bindings/exception_state.h"
#include "third_party/blink/renderer/platform/bindings/v8_per_isolate_data.h"

namespace blink {



namespace  {

const std::string_view kOwnPropertyNames[] = {
"correction",
"endIndex",
"explanation",
"startIndex",
"type",
};


}  // namespace 

ProofreadCorrection* ProofreadCorrection::Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state) {
  ProofreadCorrection* dictionary = MakeGarbageCollected<ProofreadCorrection>(isolate);
if (v8_value->IsNullOrUndefined()) {
  return dictionary;
}
if (!v8_value->IsObject()) {
  const char* const class_like_name = "ProofreadCorrection";
exception_state.ThrowTypeError(ExceptionMessages::ValueNotOfType(class_like_name));
return nullptr;
}
dictionary->FillMembersFromV8Object(isolate, v8_value.As<v8::Object>(), exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return nullptr;
}
return dictionary;
}

 ProofreadCorrection::ProofreadCorrection() {
  
}

 ProofreadCorrection::ProofreadCorrection(v8::Isolate* isolate) {
  
}



String ProofreadCorrection::getCorrectionOr(const String& fallback_value) const {
  if (!hasCorrection()) {
  return fallback_value;
}
return member_correction_;
}

String ProofreadCorrection::getCorrectionOr(String&& fallback_value) const {
  if (!hasCorrection()) {
  return std::move(fallback_value);
}
return member_correction_;
}

void ProofreadCorrection::setCorrection(const String& value) {
  member_correction_ = value;
has_correction_ = true;
}

void ProofreadCorrection::setCorrection(String&& value) {
  member_correction_ = std::move(value);
has_correction_ = true;
}











String ProofreadCorrection::getExplanationOr(const String& fallback_value) const {
  if (!hasExplanation()) {
  return fallback_value;
}
return member_explanation_;
}

String ProofreadCorrection::getExplanationOr(String&& fallback_value) const {
  if (!hasExplanation()) {
  return std::move(fallback_value);
}
return member_explanation_;
}

void ProofreadCorrection::setExplanation(const String& value) {
  member_explanation_ = value;
has_explanation_ = true;
}

void ProofreadCorrection::setExplanation(String&& value) {
  member_explanation_ = std::move(value);
has_explanation_ = true;
}


















void ProofreadCorrection::Trace(Visitor* visitor) const {
  bindings::DictionaryBase::Trace(visitor);
}

void ProofreadCorrection::FillTemplateProperties(Vector<std::string_view>& properties) const {
  static_assert(std::size(kOwnPropertyNames) == kOwnPropertyCount);
properties.AppendRange(std::cbegin(kOwnPropertyNames), std::cend(kOwnPropertyNames));
DCHECK_EQ(properties.size(), kTotalPropertyCount);
}

void ProofreadCorrection::FillValuesImpl(ScriptState* script_state, base::span<v8::MaybeLocal<v8::Value>> values) const {
  CHECK_EQ(kOwnPropertyCount, values.size());
if (hasCorrection()) {
  values[0] = ToV8Traits<IDLString>::ToV8(script_state, member_correction_);
DCHECK(!values[0].IsEmpty());
}
if (hasEndIndex()) {
  values[1] = ToV8Traits<IDLUnsignedLongLong>::ToV8(script_state, member_end_index_);
DCHECK(!values[1].IsEmpty());
}
if (hasExplanation()) {
  values[2] = ToV8Traits<IDLString>::ToV8(script_state, member_explanation_);
DCHECK(!values[2].IsEmpty());
}
if (hasStartIndex()) {
  values[3] = ToV8Traits<IDLUnsignedLongLong>::ToV8(script_state, member_start_index_);
DCHECK(!values[3].IsEmpty());
}
if (hasType()) {
  values[4] = ToV8Traits<V8CorrectionType>::ToV8(script_state, member_type_);
DCHECK(!values[4].IsEmpty());
}
}

const void* ProofreadCorrection::TemplateKey() const {
  static const void *s_key = &s_key;
return s_key;
}

v8::Local<v8::Object> ProofreadCorrection::FillValues(ScriptState* script_state, v8::Local<v8::DictionaryTemplate> dict_template) const {
  v8::MaybeLocal<v8::Value> values[kTotalPropertyCount];
FillValuesImpl(script_state, values);
return dict_template->NewInstance(script_state->GetContext(), values);
}

void ProofreadCorrection::FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state) {
  TryRethrowScope rethrow_scope(isolate, exception_state);
const char* const class_like_name = "ProofreadCorrection";
DictionaryConversionContext dictionary_from_v8_context(isolate, class_like_name);
dictionary_from_v8_context.SetCurrentPropertyName("correction");
constexpr bool is_optional = false;
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
const auto& v8_own_member_names = GetV8OwnMemberNames(isolate);
if (!bindings::GetDictionaryMemberFromV8Object<IDLString, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[0].Get(isolate), has_correction_, member_correction_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("endIndex");
if (!bindings::GetDictionaryMemberFromV8Object<IDLUnsignedLongLong, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[1].Get(isolate), has_end_index_, member_end_index_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("explanation");
if (!bindings::GetDictionaryMemberFromV8Object<IDLString, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[2].Get(isolate), has_explanation_, member_explanation_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("startIndex");
if (!bindings::GetDictionaryMemberFromV8Object<IDLUnsignedLongLong, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[3].Get(isolate), has_start_index_, member_start_index_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("type");
if (!bindings::GetDictionaryMemberFromV8Object<V8CorrectionType, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[4].Get(isolate), has_type_, member_type_, class_like_name, exception_state)) {
  return;
}
}

const base::span<const v8::Eternal<v8::Name>> ProofreadCorrection::GetV8OwnMemberNames(v8::Isolate* isolate) {
  return V8PerIsolateData::From(isolate)->FindOrCreateEternalNameCache(kOwnPropertyNames, kOwnPropertyNames);
}


}  // namespace blink
