// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_PRESSURE_OBSERVER_OPTIONS_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_PRESSURE_OBSERVER_OPTIONS_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"

namespace blink {

class ExceptionState;

class MODULES_EXPORT PressureObserverOptions : public bindings::InputDictionaryBase {
  
  public:
static PressureObserverOptions* Create() {
  return MakeGarbageCollected<PressureObserverOptions>();
}
static PressureObserverOptions* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<PressureObserverOptions>(isolate);
}
static PressureObserverOptions* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  PressureObserverOptions();
explicit  PressureObserverOptions(v8::Isolate* isolate);

bool hasSampleInterval() const {
  return true;
}
uint32_t sampleInterval() const {
  return member_sample_interval_;
}
void setSampleInterval(uint32_t value) {
  member_sample_interval_ = value;
}




void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 1;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);



uint32_t member_sample_interval_{0};


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_PRESSURE_OBSERVER_OPTIONS_H_
