// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_PHOTO_SETTINGS_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_PHOTO_SETTINGS_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_fill_light_mode.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"

namespace blink {

class ExceptionState;

class MODULES_EXPORT PhotoSettings : public bindings::DictionaryBase {
  
  public:
static PhotoSettings* Create() {
  return MakeGarbageCollected<PhotoSettings>();
}
static PhotoSettings* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<PhotoSettings>(isolate);
}
static PhotoSettings* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  PhotoSettings();
explicit  PhotoSettings(v8::Isolate* isolate);

bool hasFillLightMode() const {
  return has_fill_light_mode_;
}
V8FillLightMode fillLightMode() const {
  DCHECK(hasFillLightMode());
return member_fill_light_mode_;
}
V8FillLightMode getFillLightModeOr(V8FillLightMode fallback_value) const {
  if (!hasFillLightMode()) {
  return fallback_value;
}
return member_fill_light_mode_;
}
void setFillLightMode(V8FillLightMode value) {
  member_fill_light_mode_ = value;
has_fill_light_mode_ = true;
}
void setFillLightMode(V8FillLightMode::Enum value) {
  member_fill_light_mode_ = V8FillLightMode(value);
has_fill_light_mode_ = true;
}

bool hasImageHeight() const {
  return has_image_height_;
}
double imageHeight() const {
  DCHECK(hasImageHeight());
return member_image_height_;
}
double getImageHeightOr(double fallback_value) const {
  if (!hasImageHeight()) {
  return fallback_value;
}
return member_image_height_;
}
void setImageHeight(double value) {
  member_image_height_ = value;
has_image_height_ = true;
}

bool hasImageWidth() const {
  return has_image_width_;
}
double imageWidth() const {
  DCHECK(hasImageWidth());
return member_image_width_;
}
double getImageWidthOr(double fallback_value) const {
  if (!hasImageWidth()) {
  return fallback_value;
}
return member_image_width_;
}
void setImageWidth(double value) {
  member_image_width_ = value;
has_image_width_ = true;
}

bool hasRedEyeReduction() const {
  return has_red_eye_reduction_;
}
bool redEyeReduction() const {
  DCHECK(hasRedEyeReduction());
return member_red_eye_reduction_;
}
bool getRedEyeReductionOr(bool fallback_value) const {
  if (!hasRedEyeReduction()) {
  return fallback_value;
}
return member_red_eye_reduction_;
}
void setRedEyeReduction(bool value) {
  member_red_eye_reduction_ = value;
has_red_eye_reduction_ = true;
}




void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 4;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillTemplateProperties(Vector<std::string_view>& properties) const override;
void FillValuesImpl(ScriptState* script_state, base::span<v8::MaybeLocal<v8::Value>> values) const;


void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
const void* TemplateKey() const override;
v8::Local<v8::Object> FillValues(ScriptState* script_state, v8::Local<v8::DictionaryTemplate> dict_template) const override;
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_fill_light_mode_ = false;
bool has_image_height_ = false;
bool has_image_width_ = false;
bool has_red_eye_reduction_ = false;

V8FillLightMode member_fill_light_mode_{static_cast<V8FillLightMode::Enum>(0)};
double member_image_height_;
double member_image_width_;
bool member_red_eye_reduction_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_PHOTO_SETTINGS_H_
