// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#include "third_party/blink/renderer/bindings/modules/v8/v8_payment_request_details_update.h"

#include "third_party/blink/renderer/bindings/core/v8/generated_code_helper.h"
#include "third_party/blink/renderer/bindings/core/v8/native_value_traits_impl.h"
#include "third_party/blink/renderer/bindings/core/v8/to_v8_traits.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_address_errors.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_payment_currency_amount.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_payment_details_modifier.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_payment_shipping_option.h"
#include "third_party/blink/renderer/platform/bindings/exception_messages.h"
#include "third_party/blink/renderer/platform/bindings/exception_state.h"
#include "third_party/blink/renderer/platform/bindings/v8_per_isolate_data.h"

namespace blink {



namespace  {

const std::string_view kOwnPropertyNames[] = {
"error",
"modifiers",
"paymentMethodErrors",
"shippingAddressErrors",
"shippingOptions",
"total",
};


}  // namespace 

PaymentRequestDetailsUpdate* PaymentRequestDetailsUpdate::Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state) {
  PaymentRequestDetailsUpdate* dictionary = MakeGarbageCollected<PaymentRequestDetailsUpdate>(isolate);
if (v8_value->IsNullOrUndefined()) {
  return dictionary;
}
if (!v8_value->IsObject()) {
  const char* const class_like_name = "PaymentRequestDetailsUpdate";
exception_state.ThrowTypeError(ExceptionMessages::ValueNotOfType(class_like_name));
return nullptr;
}
dictionary->FillMembersFromV8Object(isolate, v8_value.As<v8::Object>(), exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return nullptr;
}
return dictionary;
}

 PaymentRequestDetailsUpdate::PaymentRequestDetailsUpdate() {
  
}

 PaymentRequestDetailsUpdate::PaymentRequestDetailsUpdate(v8::Isolate* isolate) {
  
}



String PaymentRequestDetailsUpdate::getErrorOr(const String& fallback_value) const {
  if (!hasError()) {
  return fallback_value;
}
return member_error_;
}

String PaymentRequestDetailsUpdate::getErrorOr(String&& fallback_value) const {
  if (!hasError()) {
  return std::move(fallback_value);
}
return member_error_;
}

void PaymentRequestDetailsUpdate::setError(const String& value) {
  member_error_ = value;
has_error_ = true;
}

void PaymentRequestDetailsUpdate::setError(String&& value) {
  member_error_ = std::move(value);
has_error_ = true;
}




HeapVector<Member<PaymentDetailsModifier>> PaymentRequestDetailsUpdate::getModifiersOr(const HeapVector<Member<PaymentDetailsModifier>>& fallback_value) const {
  if (!hasModifiers()) {
  return fallback_value;
}
return member_modifiers_;
}

HeapVector<Member<PaymentDetailsModifier>> PaymentRequestDetailsUpdate::getModifiersOr(HeapVector<Member<PaymentDetailsModifier>>&& fallback_value) const {
  if (!hasModifiers()) {
  return std::move(fallback_value);
}
return member_modifiers_;
}

void PaymentRequestDetailsUpdate::setModifiers(const HeapVector<Member<PaymentDetailsModifier>>& value) {
  member_modifiers_ = value;
has_modifiers_ = true;
}

void PaymentRequestDetailsUpdate::setModifiers(HeapVector<Member<PaymentDetailsModifier>>&& value) {
  member_modifiers_ = std::move(value);
has_modifiers_ = true;
}


















HeapVector<Member<PaymentShippingOption>> PaymentRequestDetailsUpdate::getShippingOptionsOr(const HeapVector<Member<PaymentShippingOption>>& fallback_value) const {
  if (!hasShippingOptions()) {
  return fallback_value;
}
return member_shipping_options_;
}

HeapVector<Member<PaymentShippingOption>> PaymentRequestDetailsUpdate::getShippingOptionsOr(HeapVector<Member<PaymentShippingOption>>&& fallback_value) const {
  if (!hasShippingOptions()) {
  return std::move(fallback_value);
}
return member_shipping_options_;
}

void PaymentRequestDetailsUpdate::setShippingOptions(const HeapVector<Member<PaymentShippingOption>>& value) {
  member_shipping_options_ = value;
has_shipping_options_ = true;
}

void PaymentRequestDetailsUpdate::setShippingOptions(HeapVector<Member<PaymentShippingOption>>&& value) {
  member_shipping_options_ = std::move(value);
has_shipping_options_ = true;
}











void PaymentRequestDetailsUpdate::Trace(Visitor* visitor) const {
  visitor->Trace(member_modifiers_);
visitor->Trace(member_payment_method_errors_);
visitor->Trace(member_shipping_address_errors_);
visitor->Trace(member_shipping_options_);
visitor->Trace(member_total_);
bindings::DictionaryBase::Trace(visitor);
}

void PaymentRequestDetailsUpdate::FillTemplateProperties(Vector<std::string_view>& properties) const {
  static_assert(std::size(kOwnPropertyNames) == kOwnPropertyCount);
properties.AppendRange(std::cbegin(kOwnPropertyNames), std::cend(kOwnPropertyNames));
DCHECK_EQ(properties.size(), kTotalPropertyCount);
}

void PaymentRequestDetailsUpdate::FillValuesImpl(ScriptState* script_state, base::span<v8::MaybeLocal<v8::Value>> values) const {
  CHECK_EQ(kOwnPropertyCount, values.size());
if (hasError()) {
  values[0] = ToV8Traits<IDLString>::ToV8(script_state, member_error_);
DCHECK(!values[0].IsEmpty());
}
if (hasModifiers()) {
  values[1] = ToV8Traits<IDLSequence<PaymentDetailsModifier>>::ToV8(script_state, member_modifiers_);
DCHECK(!values[1].IsEmpty());
}
if (hasPaymentMethodErrors()) {
  values[2] = ToV8Traits<IDLObject>::ToV8(script_state, member_payment_method_errors_);
DCHECK(!values[2].IsEmpty());
}
if (hasShippingAddressErrors()) {
  values[3] = ToV8Traits<AddressErrors>::ToV8(script_state, member_shipping_address_errors_.Get());
DCHECK(!values[3].IsEmpty());
}
if (hasShippingOptions()) {
  values[4] = ToV8Traits<IDLSequence<PaymentShippingOption>>::ToV8(script_state, member_shipping_options_);
DCHECK(!values[4].IsEmpty());
}
if (hasTotal()) {
  values[5] = ToV8Traits<PaymentCurrencyAmount>::ToV8(script_state, member_total_.Get());
DCHECK(!values[5].IsEmpty());
}
}

const void* PaymentRequestDetailsUpdate::TemplateKey() const {
  static const void *s_key = &s_key;
return s_key;
}

v8::Local<v8::Object> PaymentRequestDetailsUpdate::FillValues(ScriptState* script_state, v8::Local<v8::DictionaryTemplate> dict_template) const {
  v8::MaybeLocal<v8::Value> values[kTotalPropertyCount];
FillValuesImpl(script_state, values);
return dict_template->NewInstance(script_state->GetContext(), values);
}

void PaymentRequestDetailsUpdate::FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state) {
  TryRethrowScope rethrow_scope(isolate, exception_state);
const char* const class_like_name = "PaymentRequestDetailsUpdate";
DictionaryConversionContext dictionary_from_v8_context(isolate, class_like_name);
dictionary_from_v8_context.SetCurrentPropertyName("error");
constexpr bool is_optional = false;
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
const auto& v8_own_member_names = GetV8OwnMemberNames(isolate);
if (!bindings::GetDictionaryMemberFromV8Object<IDLString, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[0].Get(isolate), has_error_, member_error_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("modifiers");
if (!bindings::GetDictionaryMemberFromV8Object<IDLSequence<PaymentDetailsModifier>, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[1].Get(isolate), has_modifiers_, member_modifiers_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("paymentMethodErrors");
if (!bindings::GetDictionaryMemberFromV8Object<IDLObject, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[2].Get(isolate), has_payment_method_errors_, member_payment_method_errors_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("shippingAddressErrors");
if (!bindings::GetDictionaryMemberFromV8Object<AddressErrors, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[3].Get(isolate), has_shipping_address_errors_, member_shipping_address_errors_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("shippingOptions");
if (!bindings::GetDictionaryMemberFromV8Object<IDLSequence<PaymentShippingOption>, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[4].Get(isolate), has_shipping_options_, member_shipping_options_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("total");
if (!bindings::GetDictionaryMemberFromV8Object<PaymentCurrencyAmount, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[5].Get(isolate), has_total_, member_total_, class_like_name, exception_state)) {
  return;
}
}

const base::span<const v8::Eternal<v8::Name>> PaymentRequestDetailsUpdate::GetV8OwnMemberNames(v8::Isolate* isolate) {
  return V8PerIsolateData::From(isolate)->FindOrCreateEternalNameCache(kOwnPropertyNames, kOwnPropertyNames);
}


}  // namespace blink
