// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#include "third_party/blink/renderer/bindings/modules/v8/v8_payment_request.h"

#include "third_party/blink/public/mojom/origin_trials/origin_trial_feature.mojom-shared.h"
#include "third_party/blink/renderer/bindings/core/v8/generated_code_helper.h"
#include "third_party/blink/renderer/bindings/core/v8/is_return_type_compatible.h"
#include "third_party/blink/renderer/bindings/core/v8/native_value_traits_impl.h"
#include "third_party/blink/renderer/bindings/core/v8/to_v8_traits.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_event_handler_non_null.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_event_target.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_set_return_value_for_core.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_payment_address.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_payment_details_init.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_payment_details_update.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_payment_method_data.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_payment_options.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_payment_response.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_payment_shipping_type.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_secure_payment_confirmation_availability.h"
#include "third_party/blink/renderer/core/execution_context/execution_context.h"
#include "third_party/blink/renderer/core/frame/dactyloscoper.h"
#include "third_party/blink/renderer/core/frame/web_feature.h"
#include "third_party/blink/renderer/modules/payments/payment_address.h"
#include "third_party/blink/renderer/modules/payments/payment_request.h"
#include "third_party/blink/renderer/modules/payments/payment_response.h"
#include "third_party/blink/renderer/platform/bindings/active_script_wrappable_base.h"
#include "third_party/blink/renderer/platform/bindings/exception_messages.h"
#include "third_party/blink/renderer/platform/bindings/idl_member_installer.h"
#include "third_party/blink/renderer/platform/bindings/runtime_call_stats.h"
#include "third_party/blink/renderer/platform/bindings/v8_binding.h"
#include "third_party/blink/renderer/platform/bindings/v8_object_constructor.h"
#include "third_party/blink/renderer/platform/bindings/wrapper_type_info.h"
#include "third_party/blink/renderer/platform/instrumentation/use_counter.h"

namespace blink {



bool V8PaymentRequest::IsExposed(ExecutionContext* execution_context) {
  
const bool is_in_secure_context = execution_context->IsSecureContext();
return is_in_secure_context && execution_context->IsWindow() && RuntimeEnabledFeatures::PaymentRequestEnabled();
}

// Construction of WrapperTypeInfo may require non-trivial initialization due
// to cross-component address resolution in order to load the pointer to the
// parent interface's WrapperTypeInfo.  We ignore this issue because the issue
// happens only on component builds and the official release builds
// (statically-linked builds) are never affected by this issue.
#if defined(COMPONENT_BUILD) && defined(WIN32) && defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wglobal-constructors"
#endif

const WrapperTypeInfo V8PaymentRequest::wrapper_type_info_{
    {gin::kEmbedderBlink},
    V8PaymentRequest::InstallInterfaceTemplate,
    nullptr,
    "PaymentRequest",
    V8EventTarget::GetWrapperTypeInfo(),
    V8PaymentRequest::kThisTag,
    V8PaymentRequest::kMaxSubclassTag,
    WrapperTypeInfo::kWrapperTypeObjectPrototype,
    WrapperTypeInfo::kObjectClassId,
    WrapperTypeInfo::kIdlInterface,
    false,
};

#if defined(COMPONENT_BUILD) && defined(WIN32) && defined(__clang__)
#pragma clang diagnostic pop
#endif

const WrapperTypeInfo& PaymentRequest::wrapper_type_info_ =
    V8PaymentRequest::wrapper_type_info_;

// [ActiveScriptWrappable]
static_assert(
    std::is_base_of<ActiveScriptWrappableBase, PaymentRequest>::value,
    "PaymentRequest does not inherit from ActiveScriptWrappable<> despite "
    "the IDL has [ActiveScriptWrappable] extended attribute.");

namespace  {

namespace v8_payment_request {


void IdAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_PaymentRequest_id_Getter");
BLINK_BINDINGS_TRACE_EVENT("PaymentRequest.id.get");



v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
PaymentRequest* blink_receiver = V8PaymentRequest::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = blink_receiver->id();
static_assert(bindings::IsReturnTypeCompatible<IDLString, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, isolate, bindings::V8ReturnValue::kNonNullable);
}



void ShippingAddressAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_PaymentRequest_shippingAddress_Getter");
BLINK_BINDINGS_TRACE_EVENT("PaymentRequest.shippingAddress.get");



v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
PaymentRequest* blink_receiver = V8PaymentRequest::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = blink_receiver->getShippingAddress();
static_assert(bindings::IsReturnTypeCompatible<IDLNullable<PaymentAddress>, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, blink_receiver);
}



void ShippingOptionAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_PaymentRequest_shippingOption_Getter");
BLINK_BINDINGS_TRACE_EVENT("PaymentRequest.shippingOption.get");



v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
PaymentRequest* blink_receiver = V8PaymentRequest::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = blink_receiver->shippingOption();
static_assert(bindings::IsReturnTypeCompatible<IDLNullable<IDLString>, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, isolate, bindings::V8ReturnValue::kNullable);
}



void ShippingTypeAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_PaymentRequest_shippingType_Getter");
BLINK_BINDINGS_TRACE_EVENT("PaymentRequest.shippingType.get");



v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
PaymentRequest* blink_receiver = V8PaymentRequest::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = blink_receiver->shippingType();
static_assert(bindings::IsReturnTypeCompatible<IDLNullable<V8PaymentShippingType>, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, isolate, bindings::V8ReturnValue::kNullable);
}



void OnshippingaddresschangeAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_PaymentRequest_onshippingaddresschange_Getter");
BLINK_BINDINGS_TRACE_EVENT("PaymentRequest.onshippingaddresschange.get");



v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
PaymentRequest* blink_receiver = V8PaymentRequest::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = blink_receiver->onshippingaddresschange();
static_assert(bindings::IsReturnTypeCompatible<IDLEventHandler, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, isolate, blink_receiver);
}

void OnshippingaddresschangeAttributeSetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_PaymentRequest_onshippingaddresschange_Setter");
BLINK_BINDINGS_TRACE_EVENT("PaymentRequest.onshippingaddresschange.set");

v8::Local<v8::Value> v8_property_value = info[0];
EventListener* event_handler = JSEventHandler::CreateOrNull(
    v8_property_value,
    JSEventHandler::HandlerType::kEventHandler);
v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
PaymentRequest* blink_receiver = V8PaymentRequest::ToWrappableUnsafe(isolate, v8_receiver);
blink_receiver->setOnshippingaddresschange(event_handler);
}


void OnshippingoptionchangeAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_PaymentRequest_onshippingoptionchange_Getter");
BLINK_BINDINGS_TRACE_EVENT("PaymentRequest.onshippingoptionchange.get");



v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
PaymentRequest* blink_receiver = V8PaymentRequest::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = blink_receiver->onshippingoptionchange();
static_assert(bindings::IsReturnTypeCompatible<IDLEventHandler, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, isolate, blink_receiver);
}

void OnshippingoptionchangeAttributeSetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_PaymentRequest_onshippingoptionchange_Setter");
BLINK_BINDINGS_TRACE_EVENT("PaymentRequest.onshippingoptionchange.set");

v8::Local<v8::Value> v8_property_value = info[0];
EventListener* event_handler = JSEventHandler::CreateOrNull(
    v8_property_value,
    JSEventHandler::HandlerType::kEventHandler);
v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
PaymentRequest* blink_receiver = V8PaymentRequest::ToWrappableUnsafe(isolate, v8_receiver);
blink_receiver->setOnshippingoptionchange(event_handler);
}


void OnpaymentmethodchangeAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_PaymentRequest_onpaymentmethodchange_Getter");
BLINK_BINDINGS_TRACE_EVENT("PaymentRequest.onpaymentmethodchange.get");



v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
PaymentRequest* blink_receiver = V8PaymentRequest::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = blink_receiver->onpaymentmethodchange();
static_assert(bindings::IsReturnTypeCompatible<IDLEventHandler, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, isolate, blink_receiver);
}

void OnpaymentmethodchangeAttributeSetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_PaymentRequest_onpaymentmethodchange_Setter");
BLINK_BINDINGS_TRACE_EVENT("PaymentRequest.onpaymentmethodchange.set");

v8::Local<v8::Value> v8_property_value = info[0];
EventListener* event_handler = JSEventHandler::CreateOrNull(
    v8_property_value,
    JSEventHandler::HandlerType::kEventHandler);
v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
PaymentRequest* blink_receiver = V8PaymentRequest::ToWrappableUnsafe(isolate, v8_receiver);
blink_receiver->setOnpaymentmethodchange(event_handler);
}

void ConstructorCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_PaymentRequest_constructor");
BLINK_BINDINGS_TRACE_EVENT("PaymentRequest.constructor");

v8::Isolate* isolate = info.GetIsolate();
if (!info.IsConstructCall()) {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::ConstructorCalledAsFunction());
return;
}
v8::Local<v8::Object> v8_receiver = info.This();
if (ConstructorMode::Current(isolate) == ConstructorMode::kWrapExistingObject) {
  bindings::V8SetReturnValue(info, v8_receiver);
return;
}


if (info.Length() < 1) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(1, info.Length()));
return;
}

v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
ScriptState* current_script_state = ScriptState::From(isolate, current_context);
ExecutionContext* current_execution_context = ToExecutionContext(current_script_state);
ExecutionContext* execution_context = current_execution_context;
ExceptionState exception_state(isolate);
auto&& arg1_method_data = NativeValueTraits<IDLSequence<PaymentMethodData>>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
decltype(NativeValueTraits<PaymentDetailsInit>::NativeValue(std::declval<v8::Isolate*>(), std::declval<v8::Local<v8::Value>>(), std::declval<ExceptionState&>())) arg2_details;
if (info[1]->IsUndefined()) {
  arg2_details = PaymentDetailsInit::Create();
} else {
  arg2_details = NativeValueTraits<PaymentDetailsInit>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
}
decltype(NativeValueTraits<PaymentOptions>::NativeValue(std::declval<v8::Isolate*>(), std::declval<v8::Local<v8::Value>>(), std::declval<ExceptionState&>())) arg3_options;
if (info[2]->IsUndefined()) {
  arg3_options = PaymentOptions::Create();
} else {
  arg3_options = NativeValueTraits<PaymentOptions>::ArgumentValue(isolate, 2, info[2], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
}
auto&& return_value = PaymentRequest::Create(execution_context, std::move(arg1_method_data), arg2_details, arg3_options, exception_state);
static_assert(bindings::IsReturnTypeCompatible<PaymentRequest, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
if (exception_state.HadException()) [[unlikely]] {
  return;
}
v8::Local<v8::Object> v8_wrapper = return_value->AssociateWithWrapper(isolate, V8PaymentRequest::GetWrapperTypeInfo(), v8_receiver);
bindings::V8SetReturnValue(info, v8_wrapper);
}

void AbortOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_PaymentRequest_abort");
BLINK_BINDINGS_TRACE_EVENT("PaymentRequest.abort");
// Promise returning function: Convert a TypeError to a reject promise.
ExceptionToRejectPromiseScope reject_promise_scope(info);

v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
if (!V8PaymentRequest::HasInstance(isolate, v8_receiver)) {
  V8ThrowException::ThrowTypeError(isolate, "Illegal invocation");
return;
}





PaymentRequest* blink_receiver = V8PaymentRequest::ToWrappableUnsafe(isolate, v8_receiver);
ScriptState* receiver_script_state = ScriptState::ForRelevantRealm(isolate, v8_receiver);
ScriptState* script_state = receiver_script_state;
const v8::ExceptionContext exception_context_type = v8::ExceptionContext::kOperation;
const char* const class_like_name = "PaymentRequest";
const char* const property_name = "abort";
ExceptionState exception_state(isolate, ExceptionContext(exception_context_type, class_like_name, property_name));
auto&& return_value = blink_receiver->abort(script_state, exception_state);
static_assert(bindings::IsReturnTypeCompatible<IDLPromise<IDLUndefined>, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
if (exception_state.HadException()) [[unlikely]] {
  return;
}
bindings::V8SetReturnValue(info, return_value);
}

void CanMakePaymentOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_PaymentRequest_canMakePayment");
BLINK_BINDINGS_TRACE_EVENT("PaymentRequest.canMakePayment");
// Promise returning function: Convert a TypeError to a reject promise.
ExceptionToRejectPromiseScope reject_promise_scope(info);

v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
if (!V8PaymentRequest::HasInstance(isolate, v8_receiver)) {
  V8ThrowException::ThrowTypeError(isolate, "Illegal invocation");
return;
}

// [HighEntropy]
const Dactyloscoper::HighEntropyTracer  high_entropy_tracer("PaymentRequest.canMakePayment", info);
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
ScriptState* current_script_state = ScriptState::From(isolate, current_context);
ExecutionContext* current_execution_context = ToExecutionContext(current_script_state);
// [Measure], [MeasureAs]
UseCounter::Count(current_execution_context, WebFeature::kV8PaymentRequest_CanMakePayment_Method);




PaymentRequest* blink_receiver = V8PaymentRequest::ToWrappableUnsafe(isolate, v8_receiver);
ScriptState* receiver_script_state = ScriptState::ForRelevantRealm(isolate, v8_receiver);
ScriptState* script_state = receiver_script_state;
const v8::ExceptionContext exception_context_type = v8::ExceptionContext::kOperation;
const char* const class_like_name = "PaymentRequest";
const char* const property_name = "canMakePayment";
ExceptionState exception_state(isolate, ExceptionContext(exception_context_type, class_like_name, property_name));
auto&& return_value = blink_receiver->canMakePayment(script_state, exception_state);
static_assert(bindings::IsReturnTypeCompatible<IDLPromise<IDLBoolean>, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
if (exception_state.HadException()) [[unlikely]] {
  return;
}
bindings::V8SetReturnValue(info, return_value);
}

void HasEnrolledInstrumentOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_PaymentRequest_hasEnrolledInstrument");
BLINK_BINDINGS_TRACE_EVENT("PaymentRequest.hasEnrolledInstrument");
// Promise returning function: Convert a TypeError to a reject promise.
ExceptionToRejectPromiseScope reject_promise_scope(info);

v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
if (!V8PaymentRequest::HasInstance(isolate, v8_receiver)) {
  V8ThrowException::ThrowTypeError(isolate, "Illegal invocation");
return;
}

// [HighEntropy]
const Dactyloscoper::HighEntropyTracer  high_entropy_tracer("PaymentRequest.hasEnrolledInstrument", info);
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
ScriptState* current_script_state = ScriptState::From(isolate, current_context);
ExecutionContext* current_execution_context = ToExecutionContext(current_script_state);
// [Measure], [MeasureAs]
UseCounter::Count(current_execution_context, WebFeature::kV8PaymentRequest_HasEnrolledInstrument_Method);




PaymentRequest* blink_receiver = V8PaymentRequest::ToWrappableUnsafe(isolate, v8_receiver);
ScriptState* receiver_script_state = ScriptState::ForRelevantRealm(isolate, v8_receiver);
ScriptState* script_state = receiver_script_state;
const v8::ExceptionContext exception_context_type = v8::ExceptionContext::kOperation;
const char* const class_like_name = "PaymentRequest";
const char* const property_name = "hasEnrolledInstrument";
ExceptionState exception_state(isolate, ExceptionContext(exception_context_type, class_like_name, property_name));
auto&& return_value = blink_receiver->hasEnrolledInstrument(script_state, exception_state);
static_assert(bindings::IsReturnTypeCompatible<IDLPromise<IDLBoolean>, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
if (exception_state.HadException()) [[unlikely]] {
  return;
}
bindings::V8SetReturnValue(info, return_value);
}

void ShowOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_PaymentRequest_show");
BLINK_BINDINGS_TRACE_EVENT("PaymentRequest.show");
// Promise returning function: Convert a TypeError to a reject promise.
ExceptionToRejectPromiseScope reject_promise_scope(info);

v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
if (!V8PaymentRequest::HasInstance(isolate, v8_receiver)) {
  V8ThrowException::ThrowTypeError(isolate, "Illegal invocation");
return;
}





ScriptPromise<PaymentResponse> return_value;
const v8::ExceptionContext exception_context_type = v8::ExceptionContext::kOperation;
const char* const class_like_name = "PaymentRequest";
const char* const property_name = "show";
ExceptionState exception_state(isolate, ExceptionContext(exception_context_type, class_like_name, property_name));
do {  // Dummy loop for use of 'break'.
  const int non_undefined_argument_length = bindings::NonUndefinedArgumentLength(info);
PaymentRequest* blink_receiver = V8PaymentRequest::ToWrappableUnsafe(isolate, v8_receiver);
ScriptState* receiver_script_state = ScriptState::ForRelevantRealm(isolate, v8_receiver);
ScriptState* script_state = receiver_script_state;
if (non_undefined_argument_length <= 0) {
  return_value = blink_receiver->show(script_state, exception_state);
break;
}
auto&& arg1_details_promise = NativeValueTraits<IDLPromise<PaymentDetailsUpdate>>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
return_value = blink_receiver->show(script_state, arg1_details_promise, exception_state);
} while (false);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
bindings::V8SetReturnValue(info, return_value);
}

void SecurePaymentConfirmationAvailabilityStaticOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_PaymentRequest_securePaymentConfirmationAvailability");
BLINK_BINDINGS_TRACE_EVENT("PaymentRequest.securePaymentConfirmationAvailability");
// Promise returning function: Convert a TypeError to a reject promise.
ExceptionToRejectPromiseScope reject_promise_scope(info);






v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
ScriptState* current_script_state = ScriptState::From(isolate, current_context);
ScriptState* script_state = current_script_state;
auto&& return_value = PaymentRequest::securePaymentConfirmationAvailability(script_state);
static_assert(bindings::IsReturnTypeCompatible<IDLPromise<V8SecurePaymentConfirmationAvailability>, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value);
}


}  // namespace v8_payment_request

using namespace v8_payment_request;

}  // namespace 

void V8PaymentRequest::InstallInterfaceTemplate(v8::Isolate* isolate, const DOMWrapperWorld& world, v8::Local<v8::Template> interface_template) {
  const WrapperTypeInfo* const wrapper_type_info = V8PaymentRequest::GetWrapperTypeInfo();
v8::Local<v8::FunctionTemplate> interface_function_template = interface_template.As<v8::FunctionTemplate>();
v8::Local<v8::ObjectTemplate> instance_template = interface_function_template->InstanceTemplate();
v8::Local<v8::ObjectTemplate> prototype_template = interface_function_template->PrototypeTemplate();
v8::Local<v8::FunctionTemplate> parent_interface_template = wrapper_type_info->parent_class->GetV8ClassTemplate(isolate, world).As<v8::FunctionTemplate>();
bindings::SetupIDLInterfaceTemplate(isolate, wrapper_type_info, instance_template, prototype_template, interface_function_template, parent_interface_template);

interface_function_template->SetCallHandler(ConstructorCallback);
interface_function_template->SetLength(1);
interface_function_template->SetInterfaceName(V8String(isolate, "PaymentRequest"));
interface_function_template->SetExceptionContext(v8::ExceptionContext::kConstructor);






InstallUnconditionalProperties(isolate, world, instance_template, prototype_template, interface_template);
InstallContextIndependentProperties(isolate, world, instance_template, prototype_template, interface_template);
}

void V8PaymentRequest::InstallUnconditionalProperties(v8::Isolate* isolate, const DOMWrapperWorld& world, v8::Local<v8::ObjectTemplate> instance_template, v8::Local<v8::ObjectTemplate> prototype_template, v8::Local<v8::Template> interface_template) {
  using bindings::IDLMemberInstaller;

v8::Local<v8::Signature> signature = v8::Local<v8::Signature>::Cast(interface_template);
{
  
static const IDLMemberInstaller::AttributeConfig kAttributeTable[] = {
{"id", IdAttributeGetCallback, nullptr, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
{"shippingAddress", ShippingAddressAttributeGetCallback, nullptr, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
{"shippingOption", ShippingOptionAttributeGetCallback, nullptr, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
{"shippingType", ShippingTypeAttributeGetCallback, nullptr, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
{"onshippingaddresschange", OnshippingaddresschangeAttributeGetCallback, OnshippingaddresschangeAttributeSetCallback, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
{"onshippingoptionchange", OnshippingoptionchangeAttributeGetCallback, OnshippingoptionchangeAttributeSetCallback, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
};
IDLMemberInstaller::InstallAttributes(isolate, world, instance_template, prototype_template, interface_template, signature, "PaymentRequest", kAttributeTable);
}





{
  static const IDLMemberInstaller::OperationConfig kOperationTable[] = {
{"abort", AbortOperationCallback, 0, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kDoNotCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"canMakePayment", CanMakePaymentOperationCallback, 0, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kDoNotCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"hasEnrolledInstrument", HasEnrolledInstrumentOperationCallback, 0, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kDoNotCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"show", ShowOperationCallback, 0, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kDoNotCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
};
IDLMemberInstaller::InstallOperations(isolate, world, instance_template, prototype_template, interface_template, signature, "PaymentRequest", kOperationTable);
}



}

void V8PaymentRequest::InstallContextIndependentProperties(v8::Isolate* isolate, const DOMWrapperWorld& world, v8::Local<v8::ObjectTemplate> instance_template, v8::Local<v8::ObjectTemplate> prototype_template, v8::Local<v8::Template> interface_template) {
  using bindings::IDLMemberInstaller;

v8::Local<v8::Signature> signature = v8::Local<v8::Signature>::Cast(interface_template);
if (RuntimeEnabledFeatures::PaymentMethodChangeEventEnabled()) {
  
static const IDLMemberInstaller::AttributeConfig kAttributeTable[] = {
{"onpaymentmethodchange", OnpaymentmethodchangeAttributeGetCallback, OnpaymentmethodchangeAttributeSetCallback, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
};
IDLMemberInstaller::InstallAttributes(isolate, world, instance_template, prototype_template, interface_template, signature, "PaymentRequest", kAttributeTable);
}




if (RuntimeEnabledFeatures::SecurePaymentConfirmationAvailabilityAPIEnabled()) {
  static const IDLMemberInstaller::OperationConfig kOperationTable[] = {
{"securePaymentConfirmationAvailability", SecurePaymentConfirmationAvailabilityStaticOperationCallback, 0, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kInterface), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kDoNotCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kDoNotCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
};
IDLMemberInstaller::InstallOperations(isolate, world, instance_template, prototype_template, interface_template, signature, "PaymentRequest", kOperationTable);
}


}



}  // namespace blink
