// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_PAYMENT_HANDLER_RESPONSE_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_PAYMENT_HANDLER_RESPONSE_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/bindings/core/v8/script_value.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"
#include "third_party/blink/renderer/platform/heap/member.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

namespace blink {

class AddressInit;
class ExceptionState;

class MODULES_EXPORT PaymentHandlerResponse : public bindings::DictionaryBase {
  
  public:
static PaymentHandlerResponse* Create() {
  return MakeGarbageCollected<PaymentHandlerResponse>();
}
static PaymentHandlerResponse* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<PaymentHandlerResponse>(isolate);
}
static PaymentHandlerResponse* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  PaymentHandlerResponse();
explicit  PaymentHandlerResponse(v8::Isolate* isolate);

bool hasDetails() const {
  return has_details_;
}
const ScriptObject& details() const {
  DCHECK(hasDetails());
return member_details_;
}
ScriptObject getDetailsOr(const ScriptObject& fallback_value) const {
  if (!hasDetails()) {
  return fallback_value;
}
return member_details_;
}
void setDetails(const ScriptObject& value) {
  member_details_ = value;
has_details_ = true;
}

bool hasMethodName() const {
  return has_method_name_;
}
const String& methodName() const {
  DCHECK(hasMethodName());
return member_method_name_;
}
String getMethodNameOr(const String& fallback_value) const;
String getMethodNameOr(String&& fallback_value) const;
void setMethodName(const String& value);
void setMethodName(String&& value);

bool hasPayerEmail() const {
  return has_payer_email_;
}
const String& payerEmail() const {
  DCHECK(hasPayerEmail());
return member_payer_email_;
}
String getPayerEmailOr(const String& fallback_value) const;
String getPayerEmailOr(String&& fallback_value) const;
void setPayerEmail(const String& value);
void setPayerEmail(String&& value);

bool hasPayerName() const {
  return has_payer_name_;
}
const String& payerName() const {
  DCHECK(hasPayerName());
return member_payer_name_;
}
String getPayerNameOr(const String& fallback_value) const;
String getPayerNameOr(String&& fallback_value) const;
void setPayerName(const String& value);
void setPayerName(String&& value);

bool hasPayerPhone() const {
  return has_payer_phone_;
}
const String& payerPhone() const {
  DCHECK(hasPayerPhone());
return member_payer_phone_;
}
String getPayerPhoneOr(const String& fallback_value) const;
String getPayerPhoneOr(String&& fallback_value) const;
void setPayerPhone(const String& value);
void setPayerPhone(String&& value);

bool hasShippingAddress() const {
  return has_shipping_address_;
}
AddressInit* shippingAddress() const {
  DCHECK(hasShippingAddress());
return member_shipping_address_.Get();
}
AddressInit* getShippingAddressOr(AddressInit* fallback_value) const {
  if (!hasShippingAddress()) {
  return fallback_value;
}
return member_shipping_address_.Get();
}
void setShippingAddress(AddressInit* value) {
  member_shipping_address_ = value;
has_shipping_address_ = true;
DCHECK(member_shipping_address_);
}

bool hasShippingOption() const {
  return has_shipping_option_;
}
const String& shippingOption() const {
  DCHECK(hasShippingOption());
return member_shipping_option_;
}
String getShippingOptionOr(const String& fallback_value) const;
String getShippingOptionOr(String&& fallback_value) const;
void setShippingOption(const String& value);
void setShippingOption(String&& value);




void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 7;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillTemplateProperties(Vector<std::string_view>& properties) const override;
void FillValuesImpl(ScriptState* script_state, base::span<v8::MaybeLocal<v8::Value>> values) const;


void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
const void* TemplateKey() const override;
v8::Local<v8::Object> FillValues(ScriptState* script_state, v8::Local<v8::DictionaryTemplate> dict_template) const override;
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_details_ = false;
bool has_method_name_ = false;
bool has_payer_email_ = false;
bool has_payer_name_ = false;
bool has_payer_phone_ = false;
bool has_shipping_address_ = false;
bool has_shipping_option_ = false;

ScriptObject member_details_;
String member_method_name_;
String member_payer_email_;
String member_payer_name_;
String member_payer_phone_;
Member<AddressInit> member_shipping_address_;
String member_shipping_option_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_PAYMENT_HANDLER_RESPONSE_H_
