// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_PAYMENT_DETAILS_UPDATE_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_PAYMENT_DETAILS_UPDATE_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/bindings/core/v8/script_value.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_payment_details_base.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/heap/member.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

namespace blink {

class AddressErrors;
class ExceptionState;
class PaymentItem;

class MODULES_EXPORT PaymentDetailsUpdate : public PaymentDetailsBase {
  
  public:
static PaymentDetailsUpdate* Create() {
  return MakeGarbageCollected<PaymentDetailsUpdate>();
}
static PaymentDetailsUpdate* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<PaymentDetailsUpdate>(isolate);
}
static PaymentDetailsUpdate* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  PaymentDetailsUpdate();
explicit  PaymentDetailsUpdate(v8::Isolate* isolate);

bool hasError() const {
  return has_error_;
}
const String& error() const {
  DCHECK(hasError());
return member_error_;
}
String getErrorOr(const String& fallback_value) const;
String getErrorOr(String&& fallback_value) const;
void setError(const String& value);
void setError(String&& value);

bool hasPaymentMethodErrors() const {
  return has_payment_method_errors_;
}
const ScriptObject& paymentMethodErrors() const {
  DCHECK(hasPaymentMethodErrors());
return member_payment_method_errors_;
}
ScriptObject getPaymentMethodErrorsOr(const ScriptObject& fallback_value) const {
  if (!hasPaymentMethodErrors()) {
  return fallback_value;
}
return member_payment_method_errors_;
}
void setPaymentMethodErrors(const ScriptObject& value) {
  member_payment_method_errors_ = value;
has_payment_method_errors_ = true;
}

bool hasShippingAddressErrors() const {
  return has_shipping_address_errors_;
}
AddressErrors* shippingAddressErrors() const {
  DCHECK(hasShippingAddressErrors());
return member_shipping_address_errors_.Get();
}
AddressErrors* getShippingAddressErrorsOr(AddressErrors* fallback_value) const {
  if (!hasShippingAddressErrors()) {
  return fallback_value;
}
return member_shipping_address_errors_.Get();
}
void setShippingAddressErrors(AddressErrors* value) {
  member_shipping_address_errors_ = value;
has_shipping_address_errors_ = true;
DCHECK(member_shipping_address_errors_);
}

bool hasTotal() const {
  return has_total_;
}
PaymentItem* total() const {
  DCHECK(hasTotal());
return member_total_.Get();
}
PaymentItem* getTotalOr(PaymentItem* fallback_value) const {
  if (!hasTotal()) {
  return fallback_value;
}
return member_total_.Get();
}
void setTotal(PaymentItem* value) {
  member_total_ = value;
has_total_ = true;
DCHECK(member_total_);
}




void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = PaymentDetailsBase::kTotalPropertyCount;
static constexpr size_t kOwnPropertyCount = 4;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillTemplateProperties(Vector<std::string_view>& properties) const override;
void FillValuesImpl(ScriptState* script_state, base::span<v8::MaybeLocal<v8::Value>> values) const;


void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
const void* TemplateKey() const override;
v8::Local<v8::Object> FillValues(ScriptState* script_state, v8::Local<v8::DictionaryTemplate> dict_template) const override;
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_error_ = false;
bool has_payment_method_errors_ = false;
bool has_shipping_address_errors_ = false;
bool has_total_ = false;

String member_error_;
ScriptObject member_payment_method_errors_;
Member<AddressErrors> member_shipping_address_errors_;
Member<PaymentItem> member_total_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_PAYMENT_DETAILS_UPDATE_H_
