// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_PAYMENT_DETAILS_INIT_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_PAYMENT_DETAILS_INIT_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_payment_details_base.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/heap/member.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

namespace blink {

class ExceptionState;
class PaymentItem;

class MODULES_EXPORT PaymentDetailsInit : public PaymentDetailsBase {
  
  public:
static PaymentDetailsInit* Create() {
  return MakeGarbageCollected<PaymentDetailsInit>();
}
static PaymentDetailsInit* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<PaymentDetailsInit>(isolate);
}
static PaymentDetailsInit* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  PaymentDetailsInit();
explicit  PaymentDetailsInit(v8::Isolate* isolate);

bool hasId() const {
  return has_id_;
}
const String& id() const {
  DCHECK(hasId());
return member_id_;
}
String getIdOr(const String& fallback_value) const;
String getIdOr(String&& fallback_value) const;
void setId(const String& value);
void setId(String&& value);

bool hasTotal() const {
  return has_total_;
}
PaymentItem* total() const {
  DCHECK(hasTotal());
return member_total_.Get();
}
PaymentItem* getTotalOr(PaymentItem* fallback_value) const {
  if (!hasTotal()) {
  return fallback_value;
}
return member_total_.Get();
}
void setTotal(PaymentItem* value) {
  member_total_ = value;
has_total_ = true;
DCHECK(member_total_);
}




void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = PaymentDetailsBase::kTotalPropertyCount;
static constexpr size_t kOwnPropertyCount = 2;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_id_ = false;
bool has_total_ = false;

String member_id_;
Member<PaymentItem> member_total_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_PAYMENT_DETAILS_INIT_H_
