// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#include "third_party/blink/renderer/bindings/modules/v8/v8_payment_details_base.h"

#include "third_party/blink/renderer/bindings/core/v8/generated_code_helper.h"
#include "third_party/blink/renderer/bindings/core/v8/native_value_traits_impl.h"
#include "third_party/blink/renderer/bindings/core/v8/to_v8_traits.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_payment_details_modifier.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_payment_item.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_payment_shipping_option.h"
#include "third_party/blink/renderer/platform/bindings/exception_messages.h"
#include "third_party/blink/renderer/platform/bindings/exception_state.h"
#include "third_party/blink/renderer/platform/bindings/v8_per_isolate_data.h"

namespace blink {



namespace  {

const std::string_view kOwnPropertyNames[] = {
"displayItems",
"modifiers",
"shippingOptions",
};


}  // namespace 

PaymentDetailsBase* PaymentDetailsBase::Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state) {
  PaymentDetailsBase* dictionary = MakeGarbageCollected<PaymentDetailsBase>(isolate);
if (v8_value->IsNullOrUndefined()) {
  return dictionary;
}
if (!v8_value->IsObject()) {
  const char* const class_like_name = "PaymentDetailsBase";
exception_state.ThrowTypeError(ExceptionMessages::ValueNotOfType(class_like_name));
return nullptr;
}
dictionary->FillMembersFromV8Object(isolate, v8_value.As<v8::Object>(), exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return nullptr;
}
return dictionary;
}

 PaymentDetailsBase::PaymentDetailsBase() {
  
}

 PaymentDetailsBase::PaymentDetailsBase(v8::Isolate* isolate) {
  
}



HeapVector<Member<PaymentItem>> PaymentDetailsBase::getDisplayItemsOr(const HeapVector<Member<PaymentItem>>& fallback_value) const {
  if (!hasDisplayItems()) {
  return fallback_value;
}
return member_display_items_;
}

HeapVector<Member<PaymentItem>> PaymentDetailsBase::getDisplayItemsOr(HeapVector<Member<PaymentItem>>&& fallback_value) const {
  if (!hasDisplayItems()) {
  return std::move(fallback_value);
}
return member_display_items_;
}

void PaymentDetailsBase::setDisplayItems(const HeapVector<Member<PaymentItem>>& value) {
  member_display_items_ = value;
has_display_items_ = true;
}

void PaymentDetailsBase::setDisplayItems(HeapVector<Member<PaymentItem>>&& value) {
  member_display_items_ = std::move(value);
has_display_items_ = true;
}




HeapVector<Member<PaymentDetailsModifier>> PaymentDetailsBase::getModifiersOr(const HeapVector<Member<PaymentDetailsModifier>>& fallback_value) const {
  if (!hasModifiers()) {
  return fallback_value;
}
return member_modifiers_;
}

HeapVector<Member<PaymentDetailsModifier>> PaymentDetailsBase::getModifiersOr(HeapVector<Member<PaymentDetailsModifier>>&& fallback_value) const {
  if (!hasModifiers()) {
  return std::move(fallback_value);
}
return member_modifiers_;
}

void PaymentDetailsBase::setModifiers(const HeapVector<Member<PaymentDetailsModifier>>& value) {
  member_modifiers_ = value;
has_modifiers_ = true;
}

void PaymentDetailsBase::setModifiers(HeapVector<Member<PaymentDetailsModifier>>&& value) {
  member_modifiers_ = std::move(value);
has_modifiers_ = true;
}




HeapVector<Member<PaymentShippingOption>> PaymentDetailsBase::getShippingOptionsOr(const HeapVector<Member<PaymentShippingOption>>& fallback_value) const {
  if (!hasShippingOptions()) {
  return fallback_value;
}
return member_shipping_options_;
}

HeapVector<Member<PaymentShippingOption>> PaymentDetailsBase::getShippingOptionsOr(HeapVector<Member<PaymentShippingOption>>&& fallback_value) const {
  if (!hasShippingOptions()) {
  return std::move(fallback_value);
}
return member_shipping_options_;
}

void PaymentDetailsBase::setShippingOptions(const HeapVector<Member<PaymentShippingOption>>& value) {
  member_shipping_options_ = value;
has_shipping_options_ = true;
}

void PaymentDetailsBase::setShippingOptions(HeapVector<Member<PaymentShippingOption>>&& value) {
  member_shipping_options_ = std::move(value);
has_shipping_options_ = true;
}




void PaymentDetailsBase::Trace(Visitor* visitor) const {
  visitor->Trace(member_display_items_);
visitor->Trace(member_modifiers_);
visitor->Trace(member_shipping_options_);
bindings::DictionaryBase::Trace(visitor);
}

void PaymentDetailsBase::FillTemplateProperties(Vector<std::string_view>& properties) const {
  static_assert(std::size(kOwnPropertyNames) == kOwnPropertyCount);
properties.AppendRange(std::cbegin(kOwnPropertyNames), std::cend(kOwnPropertyNames));
DCHECK_EQ(properties.size(), kTotalPropertyCount);
}

void PaymentDetailsBase::FillValuesImpl(ScriptState* script_state, base::span<v8::MaybeLocal<v8::Value>> values) const {
  CHECK_EQ(kOwnPropertyCount, values.size());
if (hasDisplayItems()) {
  values[0] = ToV8Traits<IDLSequence<PaymentItem>>::ToV8(script_state, member_display_items_);
DCHECK(!values[0].IsEmpty());
}
if (hasModifiers()) {
  values[1] = ToV8Traits<IDLSequence<PaymentDetailsModifier>>::ToV8(script_state, member_modifiers_);
DCHECK(!values[1].IsEmpty());
}
if (hasShippingOptions()) {
  values[2] = ToV8Traits<IDLSequence<PaymentShippingOption>>::ToV8(script_state, member_shipping_options_);
DCHECK(!values[2].IsEmpty());
}
}

const void* PaymentDetailsBase::TemplateKey() const {
  static const void *s_key = &s_key;
return s_key;
}

v8::Local<v8::Object> PaymentDetailsBase::FillValues(ScriptState* script_state, v8::Local<v8::DictionaryTemplate> dict_template) const {
  v8::MaybeLocal<v8::Value> values[kTotalPropertyCount];
FillValuesImpl(script_state, values);
return dict_template->NewInstance(script_state->GetContext(), values);
}

void PaymentDetailsBase::FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state) {
  TryRethrowScope rethrow_scope(isolate, exception_state);
const char* const class_like_name = "PaymentDetailsBase";
DictionaryConversionContext dictionary_from_v8_context(isolate, class_like_name);
dictionary_from_v8_context.SetCurrentPropertyName("displayItems");
constexpr bool is_optional = false;
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
const auto& v8_own_member_names = GetV8OwnMemberNames(isolate);
if (!bindings::GetDictionaryMemberFromV8Object<IDLSequence<PaymentItem>, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[0].Get(isolate), has_display_items_, member_display_items_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("modifiers");
if (!bindings::GetDictionaryMemberFromV8Object<IDLSequence<PaymentDetailsModifier>, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[1].Get(isolate), has_modifiers_, member_modifiers_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("shippingOptions");
if (!bindings::GetDictionaryMemberFromV8Object<IDLSequence<PaymentShippingOption>, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[2].Get(isolate), has_shipping_options_, member_shipping_options_, class_like_name, exception_state)) {
  return;
}
}

const base::span<const v8::Eternal<v8::Name>> PaymentDetailsBase::GetV8OwnMemberNames(v8::Isolate* isolate) {
  return V8PerIsolateData::From(isolate)->FindOrCreateEternalNameCache(kOwnPropertyNames, kOwnPropertyNames);
}


}  // namespace blink
