// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_PAYMENT_CREDENTIAL_INSTRUMENT_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_PAYMENT_CREDENTIAL_INSTRUMENT_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

namespace blink {

class ExceptionState;

class MODULES_EXPORT PaymentCredentialInstrument : public bindings::DictionaryBase {
  
  public:
static PaymentCredentialInstrument* Create() {
  return MakeGarbageCollected<PaymentCredentialInstrument>();
}
static PaymentCredentialInstrument* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<PaymentCredentialInstrument>(isolate);
}
static PaymentCredentialInstrument* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  PaymentCredentialInstrument();
explicit  PaymentCredentialInstrument(v8::Isolate* isolate);

bool hasDetails() const {
  return has_details_;
}
const String& details() const {
  DCHECK(hasDetails());
return member_details_;
}
String getDetailsOr(const String& fallback_value) const;
String getDetailsOr(String&& fallback_value) const;
void setDetails(const String& value);
void setDetails(String&& value);

bool hasDisplayName() const {
  return true;
}
const String& displayName() const {
  return member_display_name_;
}
void setDisplayName(const String& value);
void setDisplayName(String&& value);

bool hasIcon() const {
  return true;
}
const String& icon() const {
  return member_icon_;
}
void setIcon(const String& value);
void setIcon(String&& value);

bool hasIconMustBeShown() const {
  return true;
}
bool iconMustBeShown() const {
  return member_icon_must_be_shown_;
}
void setIconMustBeShown(bool value) {
  member_icon_must_be_shown_ = value;
}




void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 4;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillTemplateProperties(Vector<std::string_view>& properties) const override;
void FillValuesImpl(ScriptState* script_state, base::span<v8::MaybeLocal<v8::Value>> values) const;


void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
const void* TemplateKey() const override;
v8::Local<v8::Object> FillValues(ScriptState* script_state, v8::Local<v8::DictionaryTemplate> dict_template) const override;
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_details_ = false;

String member_details_;
String member_display_name_;
String member_icon_;
bool member_icon_must_be_shown_{true};


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_PAYMENT_CREDENTIAL_INSTRUMENT_H_
