// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#include "third_party/blink/renderer/bindings/modules/v8/v8_payment_credential_instrument.h"

#include "third_party/blink/renderer/bindings/core/v8/generated_code_helper.h"
#include "third_party/blink/renderer/bindings/core/v8/native_value_traits_impl.h"
#include "third_party/blink/renderer/bindings/core/v8/to_v8_traits.h"
#include "third_party/blink/renderer/platform/bindings/exception_messages.h"
#include "third_party/blink/renderer/platform/bindings/exception_state.h"
#include "third_party/blink/renderer/platform/bindings/v8_per_isolate_data.h"
#include "third_party/blink/renderer/platform/runtime_enabled_features.h"

namespace blink {



namespace  {

const std::string_view kOwnPropertyNames[] = {
"details",
"displayName",
"icon",
"iconMustBeShown",
};


}  // namespace 

PaymentCredentialInstrument* PaymentCredentialInstrument::Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state) {
  PaymentCredentialInstrument* dictionary = MakeGarbageCollected<PaymentCredentialInstrument>(isolate);
if (!v8_value->IsObject()) {
  const char* const class_like_name = "PaymentCredentialInstrument";
exception_state.ThrowTypeError(ExceptionMessages::ValueNotOfType(class_like_name));
return nullptr;
}
dictionary->FillMembersFromV8Object(isolate, v8_value.As<v8::Object>(), exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return nullptr;
}
return dictionary;
}

 PaymentCredentialInstrument::PaymentCredentialInstrument() {
  
}

 PaymentCredentialInstrument::PaymentCredentialInstrument(v8::Isolate* isolate) {
  
}



String PaymentCredentialInstrument::getDetailsOr(const String& fallback_value) const {
  if (!hasDetails()) {
  return fallback_value;
}
return member_details_;
}

String PaymentCredentialInstrument::getDetailsOr(String&& fallback_value) const {
  if (!hasDetails()) {
  return std::move(fallback_value);
}
return member_details_;
}

void PaymentCredentialInstrument::setDetails(const String& value) {
  member_details_ = value;
has_details_ = true;
}

void PaymentCredentialInstrument::setDetails(String&& value) {
  member_details_ = std::move(value);
has_details_ = true;
}




void PaymentCredentialInstrument::setDisplayName(const String& value) {
  member_display_name_ = value;
}

void PaymentCredentialInstrument::setDisplayName(String&& value) {
  member_display_name_ = std::move(value);
}




void PaymentCredentialInstrument::setIcon(const String& value) {
  member_icon_ = value;
}

void PaymentCredentialInstrument::setIcon(String&& value) {
  member_icon_ = std::move(value);
}









void PaymentCredentialInstrument::Trace(Visitor* visitor) const {
  bindings::DictionaryBase::Trace(visitor);
}

void PaymentCredentialInstrument::FillTemplateProperties(Vector<std::string_view>& properties) const {
  static_assert(std::size(kOwnPropertyNames) == kOwnPropertyCount);
properties.AppendRange(std::cbegin(kOwnPropertyNames), std::cend(kOwnPropertyNames));
DCHECK_EQ(properties.size(), kTotalPropertyCount);
}

void PaymentCredentialInstrument::FillValuesImpl(ScriptState* script_state, base::span<v8::MaybeLocal<v8::Value>> values) const {
  CHECK_EQ(kOwnPropertyCount, values.size());
if (RuntimeEnabledFeatures::SecurePaymentConfirmationUxRefreshEnabled()) {
  if (hasDetails()) {
  values[0] = ToV8Traits<IDLUSVString>::ToV8(script_state, member_details_);
DCHECK(!values[0].IsEmpty());
}
}
if (hasDisplayName()) {
  values[1] = ToV8Traits<IDLUSVString>::ToV8(script_state, member_display_name_);
DCHECK(!values[1].IsEmpty());
}
if (hasIcon()) {
  values[2] = ToV8Traits<IDLUSVString>::ToV8(script_state, member_icon_);
DCHECK(!values[2].IsEmpty());
}
if (hasIconMustBeShown()) {
  values[3] = ToV8Traits<IDLBoolean>::ToV8(script_state, member_icon_must_be_shown_);
DCHECK(!values[3].IsEmpty());
}
}

const void* PaymentCredentialInstrument::TemplateKey() const {
  static const void *s_key = &s_key;
return s_key;
}

v8::Local<v8::Object> PaymentCredentialInstrument::FillValues(ScriptState* script_state, v8::Local<v8::DictionaryTemplate> dict_template) const {
  v8::MaybeLocal<v8::Value> values[kTotalPropertyCount];
FillValuesImpl(script_state, values);
return dict_template->NewInstance(script_state->GetContext(), values);
}

void PaymentCredentialInstrument::FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state) {
  TryRethrowScope rethrow_scope(isolate, exception_state);
const char* const class_like_name = "PaymentCredentialInstrument";
DictionaryConversionContext dictionary_from_v8_context(isolate, class_like_name);
constexpr bool is_optional = false;
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
const auto& v8_own_member_names = GetV8OwnMemberNames(isolate);
if (RuntimeEnabledFeatures::SecurePaymentConfirmationUxRefreshEnabled()) {
  dictionary_from_v8_context.SetCurrentPropertyName("details");
if (!bindings::GetDictionaryMemberFromV8Object<IDLUSVString, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[0].Get(isolate), has_details_, member_details_, class_like_name, exception_state)) {
  return;
}
}
dictionary_from_v8_context.SetCurrentPropertyName("displayName");
constexpr bool is_required = true;
bool fallback_presence_var;
if (!bindings::GetDictionaryMemberFromV8Object<IDLUSVString, is_required>(isolate, current_context, v8_dictionary, v8_own_member_names[1].Get(isolate), fallback_presence_var, member_display_name_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("icon");
if (!bindings::GetDictionaryMemberFromV8Object<IDLUSVString, is_required>(isolate, current_context, v8_dictionary, v8_own_member_names[2].Get(isolate), fallback_presence_var, member_icon_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("iconMustBeShown");
if (!bindings::GetDictionaryMemberFromV8Object<IDLBoolean, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[3].Get(isolate), fallback_presence_var, member_icon_must_be_shown_, class_like_name, exception_state)) {
  return;
}
}

const base::span<const v8::Eternal<v8::Name>> PaymentCredentialInstrument::GetV8OwnMemberNames(v8::Isolate* isolate) {
  return V8PerIsolateData::From(isolate)->FindOrCreateEternalNameCache(kOwnPropertyNames, kOwnPropertyNames);
}


}  // namespace blink
