// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#include "third_party/blink/renderer/bindings/modules/v8/v8_paint_worklet_global_scope.h"

#include "third_party/blink/public/mojom/origin_trials/origin_trial_feature.mojom-shared.h"
#include "third_party/blink/renderer/bindings/core/v8/generated_code_helper.h"
#include "third_party/blink/renderer/bindings/core/v8/is_return_type_compatible.h"
#include "third_party/blink/renderer/bindings/core/v8/native_value_traits_impl.h"
#include "third_party/blink/renderer/bindings/core/v8/to_v8_traits.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_byte_length_queuing_strategy.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_count_queuing_strategy.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_css_color_value.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_css_hsl.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_css_hwb.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_css_image_value.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_css_keyword_value.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_css_math_clamp.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_css_math_invert.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_css_math_max.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_css_math_min.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_css_math_negate.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_css_math_product.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_css_math_sum.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_css_math_value.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_css_matrix_component.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_css_numeric_array.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_css_numeric_value.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_css_perspective.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_css_position_value.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_css_rgb.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_css_rotate.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_css_scale.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_css_skew.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_css_skew_x.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_css_skew_y.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_css_style_value.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_css_transform_component.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_css_transform_value.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_css_translate.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_css_unit_value.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_css_unparsed_value.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_css_variable_reference_value.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_no_argument_constructor.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_quota_exceeded_error.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_readable_byte_stream_controller.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_readable_stream.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_readable_stream_byob_reader.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_readable_stream_byob_request.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_readable_stream_default_controller.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_readable_stream_default_reader.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_set_return_value_for_core.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_style_property_map_read_only.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_transform_stream.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_transform_stream_default_controller.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_worklet_global_scope.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_writable_stream.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_writable_stream_default_controller.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_writable_stream_default_writer.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_canvas_filter.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_mesh_2d_index_buffer.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_mesh_2d_uv_buffer.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_mesh_2d_vertex_buffer.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_paint_rendering_context_2d.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_paint_size.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_path_2d.h"
#include "third_party/blink/renderer/core/execution_context/execution_context.h"
#include "third_party/blink/renderer/core/frame/dactyloscoper.h"
#include "third_party/blink/renderer/core/frame/web_feature.h"
#include "third_party/blink/renderer/modules/csspaint/paint_worklet_global_scope.h"
#include "third_party/blink/renderer/platform/bindings/active_script_wrappable_base.h"
#include "third_party/blink/renderer/platform/bindings/exception_messages.h"
#include "third_party/blink/renderer/platform/bindings/idl_member_installer.h"
#include "third_party/blink/renderer/platform/bindings/runtime_call_stats.h"
#include "third_party/blink/renderer/platform/bindings/v8_binding.h"
#include "third_party/blink/renderer/platform/bindings/wrapper_type_info.h"
#include "third_party/blink/renderer/platform/instrumentation/use_counter.h"

namespace blink {



bool V8PaintWorkletGlobalScope::IsExposed(ExecutionContext* execution_context) {
  
return execution_context->IsPaintWorkletGlobalScope();
}

// Construction of WrapperTypeInfo may require non-trivial initialization due
// to cross-component address resolution in order to load the pointer to the
// parent interface's WrapperTypeInfo.  We ignore this issue because the issue
// happens only on component builds and the official release builds
// (statically-linked builds) are never affected by this issue.
#if defined(COMPONENT_BUILD) && defined(WIN32) && defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wglobal-constructors"
#endif

const WrapperTypeInfo V8PaintWorkletGlobalScope::wrapper_type_info_{
    {gin::kEmbedderBlink},
    V8PaintWorkletGlobalScope::InstallInterfaceTemplate,
    V8PaintWorkletGlobalScope::InstallContextDependentProperties,
    "PaintWorkletGlobalScope",
    V8WorkletGlobalScope::GetWrapperTypeInfo(),
    V8PaintWorkletGlobalScope::kThisTag,
    V8PaintWorkletGlobalScope::kMaxSubclassTag,
    WrapperTypeInfo::kWrapperTypeObjectPrototype,
    WrapperTypeInfo::kObjectClassId,
    WrapperTypeInfo::kIdlInterface,
    false,
};

#if defined(COMPONENT_BUILD) && defined(WIN32) && defined(__clang__)
#pragma clang diagnostic pop
#endif

const WrapperTypeInfo& PaintWorkletGlobalScope::wrapper_type_info_ =
    V8PaintWorkletGlobalScope::wrapper_type_info_;

// [ActiveScriptWrappable]
static_assert(
    std::is_base_of<ActiveScriptWrappableBase, PaintWorkletGlobalScope>::value,
    "PaintWorkletGlobalScope does not inherit from ActiveScriptWrappable<> despite "
    "the IDL has [ActiveScriptWrappable] extended attribute.");

namespace  {

namespace v8_paint_worklet_global_scope {


void DevicePixelRatioAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_PaintWorkletGlobalScope_devicePixelRatio_Getter");
BLINK_BINDINGS_TRACE_EVENT("PaintWorkletGlobalScope.devicePixelRatio.get");
// [HighEntropy]
const Dactyloscoper::HighEntropyTracer  high_entropy_tracer("PaintWorkletGlobalScope.devicePixelRatio.get", info);
v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
ScriptState* current_script_state = ScriptState::From(isolate, current_context);
ExecutionContext* current_execution_context = ToExecutionContext(current_script_state);
// [Measure], [MeasureAs]
UseCounter::Count(current_execution_context, WebFeature::kV8PaintWorkletGlobalScope_DevicePixelRatio_AttributeGetter);



v8::Local<v8::Object> v8_receiver = info.This();
PaintWorkletGlobalScope* blink_receiver = V8PaintWorkletGlobalScope::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = blink_receiver->devicePixelRatio();
static_assert(bindings::IsReturnTypeCompatible<IDLUnrestrictedDouble, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, bindings::V8ReturnValue::PrimitiveType<double>());
// [HighEntropy=Direct]
Dactyloscoper::RecordDirectSurface(current_execution_context, WebFeature::kV8PaintWorkletGlobalScope_DevicePixelRatio_AttributeGetter, return_value);
}


void ByteLengthQueuingStrategyExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_PaintWorkletGlobalScope_ByteLengthQueuingStrategy_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("PaintWorkletGlobalScope.ByteLengthQueuingStrategy");

bindings::V8SetReturnValue(info, V8ByteLengthQueuingStrategy::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void CSSColorValueExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_PaintWorkletGlobalScope_CSSColorValue_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("PaintWorkletGlobalScope.CSSColorValue");

bindings::V8SetReturnValue(info, V8CSSColorValue::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void CSSHSLExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_PaintWorkletGlobalScope_CSSHSL_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("PaintWorkletGlobalScope.CSSHSL");

bindings::V8SetReturnValue(info, V8CSSHSL::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void CSSHWBExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_PaintWorkletGlobalScope_CSSHWB_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("PaintWorkletGlobalScope.CSSHWB");

bindings::V8SetReturnValue(info, V8CSSHWB::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void CSSImageValueExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_PaintWorkletGlobalScope_CSSImageValue_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("PaintWorkletGlobalScope.CSSImageValue");

bindings::V8SetReturnValue(info, V8CSSImageValue::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void CSSKeywordValueExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_PaintWorkletGlobalScope_CSSKeywordValue_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("PaintWorkletGlobalScope.CSSKeywordValue");

bindings::V8SetReturnValue(info, V8CSSKeywordValue::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void CSSMathClampExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_PaintWorkletGlobalScope_CSSMathClamp_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("PaintWorkletGlobalScope.CSSMathClamp");

bindings::V8SetReturnValue(info, V8CSSMathClamp::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void CSSMathInvertExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_PaintWorkletGlobalScope_CSSMathInvert_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("PaintWorkletGlobalScope.CSSMathInvert");

bindings::V8SetReturnValue(info, V8CSSMathInvert::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void CSSMathMaxExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_PaintWorkletGlobalScope_CSSMathMax_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("PaintWorkletGlobalScope.CSSMathMax");

bindings::V8SetReturnValue(info, V8CSSMathMax::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void CSSMathMinExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_PaintWorkletGlobalScope_CSSMathMin_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("PaintWorkletGlobalScope.CSSMathMin");

bindings::V8SetReturnValue(info, V8CSSMathMin::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void CSSMathNegateExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_PaintWorkletGlobalScope_CSSMathNegate_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("PaintWorkletGlobalScope.CSSMathNegate");

bindings::V8SetReturnValue(info, V8CSSMathNegate::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void CSSMathProductExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_PaintWorkletGlobalScope_CSSMathProduct_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("PaintWorkletGlobalScope.CSSMathProduct");

bindings::V8SetReturnValue(info, V8CSSMathProduct::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void CSSMathSumExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_PaintWorkletGlobalScope_CSSMathSum_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("PaintWorkletGlobalScope.CSSMathSum");

bindings::V8SetReturnValue(info, V8CSSMathSum::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void CSSMathValueExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_PaintWorkletGlobalScope_CSSMathValue_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("PaintWorkletGlobalScope.CSSMathValue");

bindings::V8SetReturnValue(info, V8CSSMathValue::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void CSSMatrixComponentExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_PaintWorkletGlobalScope_CSSMatrixComponent_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("PaintWorkletGlobalScope.CSSMatrixComponent");

bindings::V8SetReturnValue(info, V8CSSMatrixComponent::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void CSSNumericArrayExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_PaintWorkletGlobalScope_CSSNumericArray_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("PaintWorkletGlobalScope.CSSNumericArray");

bindings::V8SetReturnValue(info, V8CSSNumericArray::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void CSSNumericValueExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_PaintWorkletGlobalScope_CSSNumericValue_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("PaintWorkletGlobalScope.CSSNumericValue");

bindings::V8SetReturnValue(info, V8CSSNumericValue::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void CSSPerspectiveExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_PaintWorkletGlobalScope_CSSPerspective_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("PaintWorkletGlobalScope.CSSPerspective");

bindings::V8SetReturnValue(info, V8CSSPerspective::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void CSSPositionValueExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_PaintWorkletGlobalScope_CSSPositionValue_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("PaintWorkletGlobalScope.CSSPositionValue");

bindings::V8SetReturnValue(info, V8CSSPositionValue::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void CSSRGBExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_PaintWorkletGlobalScope_CSSRGB_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("PaintWorkletGlobalScope.CSSRGB");

bindings::V8SetReturnValue(info, V8CSSRGB::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void CSSRotateExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_PaintWorkletGlobalScope_CSSRotate_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("PaintWorkletGlobalScope.CSSRotate");

bindings::V8SetReturnValue(info, V8CSSRotate::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void CSSScaleExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_PaintWorkletGlobalScope_CSSScale_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("PaintWorkletGlobalScope.CSSScale");

bindings::V8SetReturnValue(info, V8CSSScale::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void CSSSkewExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_PaintWorkletGlobalScope_CSSSkew_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("PaintWorkletGlobalScope.CSSSkew");

bindings::V8SetReturnValue(info, V8CSSSkew::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void CSSSkewXExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_PaintWorkletGlobalScope_CSSSkewX_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("PaintWorkletGlobalScope.CSSSkewX");

bindings::V8SetReturnValue(info, V8CSSSkewX::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void CSSSkewYExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_PaintWorkletGlobalScope_CSSSkewY_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("PaintWorkletGlobalScope.CSSSkewY");

bindings::V8SetReturnValue(info, V8CSSSkewY::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void CSSStyleValueExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_PaintWorkletGlobalScope_CSSStyleValue_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("PaintWorkletGlobalScope.CSSStyleValue");

bindings::V8SetReturnValue(info, V8CSSStyleValue::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void CSSTransformComponentExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_PaintWorkletGlobalScope_CSSTransformComponent_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("PaintWorkletGlobalScope.CSSTransformComponent");

bindings::V8SetReturnValue(info, V8CSSTransformComponent::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void CSSTransformValueExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_PaintWorkletGlobalScope_CSSTransformValue_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("PaintWorkletGlobalScope.CSSTransformValue");

bindings::V8SetReturnValue(info, V8CSSTransformValue::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void CSSTranslateExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_PaintWorkletGlobalScope_CSSTranslate_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("PaintWorkletGlobalScope.CSSTranslate");

bindings::V8SetReturnValue(info, V8CSSTranslate::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void CSSUnitValueExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_PaintWorkletGlobalScope_CSSUnitValue_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("PaintWorkletGlobalScope.CSSUnitValue");

bindings::V8SetReturnValue(info, V8CSSUnitValue::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void CSSUnparsedValueExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_PaintWorkletGlobalScope_CSSUnparsedValue_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("PaintWorkletGlobalScope.CSSUnparsedValue");

bindings::V8SetReturnValue(info, V8CSSUnparsedValue::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void CSSVariableReferenceValueExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_PaintWorkletGlobalScope_CSSVariableReferenceValue_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("PaintWorkletGlobalScope.CSSVariableReferenceValue");

bindings::V8SetReturnValue(info, V8CSSVariableReferenceValue::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void CanvasFilterExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_PaintWorkletGlobalScope_CanvasFilter_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("PaintWorkletGlobalScope.CanvasFilter");

bindings::V8SetReturnValue(info, V8CanvasFilter::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void CountQueuingStrategyExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_PaintWorkletGlobalScope_CountQueuingStrategy_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("PaintWorkletGlobalScope.CountQueuingStrategy");

bindings::V8SetReturnValue(info, V8CountQueuingStrategy::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void Mesh2DIndexBufferExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_PaintWorkletGlobalScope_Mesh2DIndexBuffer_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("PaintWorkletGlobalScope.Mesh2DIndexBuffer");

bindings::V8SetReturnValue(info, V8Mesh2DIndexBuffer::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void Mesh2DUVBufferExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_PaintWorkletGlobalScope_Mesh2DUVBuffer_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("PaintWorkletGlobalScope.Mesh2DUVBuffer");

bindings::V8SetReturnValue(info, V8Mesh2DUVBuffer::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void Mesh2DVertexBufferExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_PaintWorkletGlobalScope_Mesh2DVertexBuffer_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("PaintWorkletGlobalScope.Mesh2DVertexBuffer");

bindings::V8SetReturnValue(info, V8Mesh2DVertexBuffer::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void PaintRenderingContext2DExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_PaintWorkletGlobalScope_PaintRenderingContext2D_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("PaintWorkletGlobalScope.PaintRenderingContext2D");

bindings::V8SetReturnValue(info, V8PaintRenderingContext2D::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void PaintSizeExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_PaintWorkletGlobalScope_PaintSize_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("PaintWorkletGlobalScope.PaintSize");

bindings::V8SetReturnValue(info, V8PaintSize::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void PaintWorkletGlobalScopeExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_PaintWorkletGlobalScope_PaintWorkletGlobalScope_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("PaintWorkletGlobalScope.PaintWorkletGlobalScope");

bindings::V8SetReturnValue(info, V8PaintWorkletGlobalScope::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void Path2DExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_PaintWorkletGlobalScope_Path2D_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("PaintWorkletGlobalScope.Path2D");

bindings::V8SetReturnValue(info, V8Path2D::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void QuotaExceededErrorExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_PaintWorkletGlobalScope_QuotaExceededError_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("PaintWorkletGlobalScope.QuotaExceededError");

bindings::V8SetReturnValue(info, V8QuotaExceededError::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void ReadableByteStreamControllerExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_PaintWorkletGlobalScope_ReadableByteStreamController_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("PaintWorkletGlobalScope.ReadableByteStreamController");

bindings::V8SetReturnValue(info, V8ReadableByteStreamController::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void ReadableStreamExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_PaintWorkletGlobalScope_ReadableStream_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("PaintWorkletGlobalScope.ReadableStream");

bindings::V8SetReturnValue(info, V8ReadableStream::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void ReadableStreamBYOBReaderExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_PaintWorkletGlobalScope_ReadableStreamBYOBReader_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("PaintWorkletGlobalScope.ReadableStreamBYOBReader");

bindings::V8SetReturnValue(info, V8ReadableStreamBYOBReader::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void ReadableStreamBYOBRequestExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_PaintWorkletGlobalScope_ReadableStreamBYOBRequest_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("PaintWorkletGlobalScope.ReadableStreamBYOBRequest");

bindings::V8SetReturnValue(info, V8ReadableStreamBYOBRequest::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void ReadableStreamDefaultControllerExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_PaintWorkletGlobalScope_ReadableStreamDefaultController_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("PaintWorkletGlobalScope.ReadableStreamDefaultController");

bindings::V8SetReturnValue(info, V8ReadableStreamDefaultController::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void ReadableStreamDefaultReaderExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_PaintWorkletGlobalScope_ReadableStreamDefaultReader_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("PaintWorkletGlobalScope.ReadableStreamDefaultReader");

bindings::V8SetReturnValue(info, V8ReadableStreamDefaultReader::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void StylePropertyMapReadOnlyExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_PaintWorkletGlobalScope_StylePropertyMapReadOnly_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("PaintWorkletGlobalScope.StylePropertyMapReadOnly");

bindings::V8SetReturnValue(info, V8StylePropertyMapReadOnly::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void TransformStreamExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_PaintWorkletGlobalScope_TransformStream_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("PaintWorkletGlobalScope.TransformStream");

bindings::V8SetReturnValue(info, V8TransformStream::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void TransformStreamDefaultControllerExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_PaintWorkletGlobalScope_TransformStreamDefaultController_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("PaintWorkletGlobalScope.TransformStreamDefaultController");

bindings::V8SetReturnValue(info, V8TransformStreamDefaultController::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void WorkletGlobalScopeExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_PaintWorkletGlobalScope_WorkletGlobalScope_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("PaintWorkletGlobalScope.WorkletGlobalScope");

bindings::V8SetReturnValue(info, V8WorkletGlobalScope::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void WritableStreamExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_PaintWorkletGlobalScope_WritableStream_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("PaintWorkletGlobalScope.WritableStream");

bindings::V8SetReturnValue(info, V8WritableStream::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void WritableStreamDefaultControllerExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_PaintWorkletGlobalScope_WritableStreamDefaultController_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("PaintWorkletGlobalScope.WritableStreamDefaultController");

bindings::V8SetReturnValue(info, V8WritableStreamDefaultController::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void WritableStreamDefaultWriterExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_PaintWorkletGlobalScope_WritableStreamDefaultWriter_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("PaintWorkletGlobalScope.WritableStreamDefaultWriter");

bindings::V8SetReturnValue(info, V8WritableStreamDefaultWriter::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void RegisterPaintOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_PaintWorkletGlobalScope_registerPaint");
BLINK_BINDINGS_TRACE_EVENT("PaintWorkletGlobalScope.registerPaint");


v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
ScriptState* current_script_state = ScriptState::From(isolate, current_context);
ExecutionContext* current_execution_context = ToExecutionContext(current_script_state);
// [Measure], [MeasureAs]
UseCounter::Count(current_execution_context, WebFeature::kV8PaintWorkletGlobalScope_RegisterPaint_Method);


if (info.Length() < 2) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(2, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
PaintWorkletGlobalScope* blink_receiver = V8PaintWorkletGlobalScope::ToWrappableUnsafe(isolate, v8_receiver);
ScriptState* receiver_script_state = ScriptState::ForRelevantRealm(isolate, v8_receiver);
ScriptState* script_state = receiver_script_state;
ExceptionState exception_state(isolate);
auto&& arg1_name = NativeValueTraits<IDLString>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_paint_ctor = NativeValueTraits<V8NoArgumentConstructor>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->registerPaint(script_state, arg1_name, arg2_paint_ctor, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}

}


}  // namespace v8_paint_worklet_global_scope

using namespace v8_paint_worklet_global_scope;

}  // namespace 

void V8PaintWorkletGlobalScope::InstallInterfaceTemplate(v8::Isolate* isolate, const DOMWrapperWorld& world, v8::Local<v8::Template> interface_template) {
  const WrapperTypeInfo* const wrapper_type_info = V8PaintWorkletGlobalScope::GetWrapperTypeInfo();
v8::Local<v8::FunctionTemplate> interface_function_template = interface_template.As<v8::FunctionTemplate>();
v8::Local<v8::ObjectTemplate> instance_template = interface_function_template->InstanceTemplate();
v8::Local<v8::ObjectTemplate> prototype_template = interface_function_template->PrototypeTemplate();
v8::Local<v8::FunctionTemplate> parent_interface_template = wrapper_type_info->parent_class->GetV8ClassTemplate(isolate, world).As<v8::FunctionTemplate>();
bindings::SetupIDLInterfaceTemplate(isolate, wrapper_type_info, instance_template, prototype_template, interface_function_template, parent_interface_template);






// [Global]
// 3.7.1. [[SetPrototypeOf]]
// https://webidl.spec.whatwg.org/#platform-object-setprototypeof
instance_template->SetImmutableProto();
prototype_template->SetImmutableProto();

InstallUnconditionalProperties(isolate, world, instance_template, prototype_template, interface_template);
InstallContextIndependentProperties(isolate, world, instance_template, prototype_template, interface_template);
}

void V8PaintWorkletGlobalScope::InstallUnconditionalProperties(v8::Isolate* isolate, const DOMWrapperWorld& world, v8::Local<v8::ObjectTemplate> instance_template, v8::Local<v8::ObjectTemplate> prototype_template, v8::Local<v8::Template> interface_template) {
  using bindings::IDLMemberInstaller;

v8::Local<v8::Signature> signature = v8::Local<v8::Signature>::Cast(interface_template);
{
  
static const IDLMemberInstaller::AttributeConfig kAttributeTable[] = {
{"devicePixelRatio", DevicePixelRatioAttributeGetCallback, nullptr, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kInstance), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
};
IDLMemberInstaller::InstallAttributes(isolate, world, instance_template, prototype_template, interface_template, signature, "PaintWorkletGlobalScope", kAttributeTable);
}




{
  static const IDLMemberInstaller::ExposedConstructConfig kExposedConstructTable[] = {
{"ByteLengthQueuingStrategy", ByteLengthQueuingStrategyExposedConstructCallback}, 
{"CSSImageValue", CSSImageValueExposedConstructCallback}, 
{"CSSKeywordValue", CSSKeywordValueExposedConstructCallback}, 
{"CSSMathClamp", CSSMathClampExposedConstructCallback}, 
{"CSSMathInvert", CSSMathInvertExposedConstructCallback}, 
{"CSSMathMax", CSSMathMaxExposedConstructCallback}, 
{"CSSMathMin", CSSMathMinExposedConstructCallback}, 
{"CSSMathNegate", CSSMathNegateExposedConstructCallback}, 
{"CSSMathProduct", CSSMathProductExposedConstructCallback}, 
{"CSSMathSum", CSSMathSumExposedConstructCallback}, 
{"CSSMathValue", CSSMathValueExposedConstructCallback}, 
{"CSSMatrixComponent", CSSMatrixComponentExposedConstructCallback}, 
{"CSSNumericArray", CSSNumericArrayExposedConstructCallback}, 
{"CSSNumericValue", CSSNumericValueExposedConstructCallback}, 
{"CSSPerspective", CSSPerspectiveExposedConstructCallback}, 
{"CSSPositionValue", CSSPositionValueExposedConstructCallback}, 
{"CSSRotate", CSSRotateExposedConstructCallback}, 
{"CSSScale", CSSScaleExposedConstructCallback}, 
{"CSSSkew", CSSSkewExposedConstructCallback}, 
{"CSSSkewX", CSSSkewXExposedConstructCallback}, 
{"CSSSkewY", CSSSkewYExposedConstructCallback}, 
{"CSSStyleValue", CSSStyleValueExposedConstructCallback}, 
{"CSSTransformComponent", CSSTransformComponentExposedConstructCallback}, 
{"CSSTransformValue", CSSTransformValueExposedConstructCallback}, 
{"CSSTranslate", CSSTranslateExposedConstructCallback}, 
{"CSSUnitValue", CSSUnitValueExposedConstructCallback}, 
{"CSSUnparsedValue", CSSUnparsedValueExposedConstructCallback}, 
{"CSSVariableReferenceValue", CSSVariableReferenceValueExposedConstructCallback}, 
{"CountQueuingStrategy", CountQueuingStrategyExposedConstructCallback}, 
{"PaintRenderingContext2D", PaintRenderingContext2DExposedConstructCallback}, 
{"PaintSize", PaintSizeExposedConstructCallback}, 
{"PaintWorkletGlobalScope", PaintWorkletGlobalScopeExposedConstructCallback}, 
{"Path2D", Path2DExposedConstructCallback}, 
{"ReadableByteStreamController", ReadableByteStreamControllerExposedConstructCallback}, 
{"ReadableStream", ReadableStreamExposedConstructCallback}, 
{"ReadableStreamBYOBReader", ReadableStreamBYOBReaderExposedConstructCallback}, 
{"ReadableStreamBYOBRequest", ReadableStreamBYOBRequestExposedConstructCallback}, 
{"ReadableStreamDefaultController", ReadableStreamDefaultControllerExposedConstructCallback}, 
{"ReadableStreamDefaultReader", ReadableStreamDefaultReaderExposedConstructCallback}, 
{"StylePropertyMapReadOnly", StylePropertyMapReadOnlyExposedConstructCallback}, 
{"TransformStream", TransformStreamExposedConstructCallback}, 
{"TransformStreamDefaultController", TransformStreamDefaultControllerExposedConstructCallback}, 
{"WorkletGlobalScope", WorkletGlobalScopeExposedConstructCallback}, 
{"WritableStream", WritableStreamExposedConstructCallback}, 
{"WritableStreamDefaultController", WritableStreamDefaultControllerExposedConstructCallback}, 
{"WritableStreamDefaultWriter", WritableStreamDefaultWriterExposedConstructCallback}, 
};
IDLMemberInstaller::InstallExposedConstructs(isolate, world, instance_template, prototype_template, interface_template, signature, kExposedConstructTable);
}


{
  static const IDLMemberInstaller::OperationConfig kOperationTable[] = {
{"registerPaint", RegisterPaintOperationCallback, 2, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kInstance), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
};
IDLMemberInstaller::InstallOperations(isolate, world, instance_template, prototype_template, interface_template, signature, "PaintWorkletGlobalScope", kOperationTable);
}



}

void V8PaintWorkletGlobalScope::InstallContextIndependentProperties(v8::Isolate* isolate, const DOMWrapperWorld& world, v8::Local<v8::ObjectTemplate> instance_template, v8::Local<v8::ObjectTemplate> prototype_template, v8::Local<v8::Template> interface_template) {
  using bindings::IDLMemberInstaller;




v8::Local<v8::Signature> signature = v8::Local<v8::Signature>::Cast(interface_template);
if (RuntimeEnabledFeatures::CSSColorTypedOMEnabled()) {
  static const IDLMemberInstaller::ExposedConstructConfig kExposedConstructTable[] = {
{"CSSColorValue", CSSColorValueExposedConstructCallback}, 
{"CSSHSL", CSSHSLExposedConstructCallback}, 
{"CSSHWB", CSSHWBExposedConstructCallback}, 
{"CSSRGB", CSSRGBExposedConstructCallback}, 
};
IDLMemberInstaller::InstallExposedConstructs(isolate, world, instance_template, prototype_template, interface_template, signature, kExposedConstructTable);
}
if (RuntimeEnabledFeatures::Canvas2dCanvasFilterEnabled()) {
  static const IDLMemberInstaller::ExposedConstructConfig kExposedConstructTable[] = {
{"CanvasFilter", CanvasFilterExposedConstructCallback}, 
};
IDLMemberInstaller::InstallExposedConstructs(isolate, world, instance_template, prototype_template, interface_template, signature, kExposedConstructTable);
}
if (RuntimeEnabledFeatures::QuotaExceededErrorUpdateEnabled()) {
  static const IDLMemberInstaller::ExposedConstructConfig kExposedConstructTable[] = {
{"QuotaExceededError", QuotaExceededErrorExposedConstructCallback}, 
};
IDLMemberInstaller::InstallExposedConstructs(isolate, world, instance_template, prototype_template, interface_template, signature, kExposedConstructTable);
}



}

void V8PaintWorkletGlobalScope::InstallContextDependentProperties(v8::Local<v8::Context> context, const DOMWrapperWorld& world, v8::Local<v8::Object> instance_object, v8::Local<v8::Object> prototype_object, v8::Local<v8::Object> interface_object, v8::Local<v8::Template> interface_template, FeatureSelector feature_selector) {
  using bindings::IDLMemberInstaller;

if (instance_object.IsEmpty()) {
  instance_object = context->Global();
}




v8::Isolate* isolate = v8::Isolate::GetCurrent();
ScriptState* script_state = ScriptState::From(isolate, context);
ExecutionContext* execution_context = ToExecutionContext(script_state);
if ((feature_selector.IsAll() && RuntimeEnabledFeatures::Canvas2dMeshEnabled(execution_context)) || feature_selector.IsAnyOf(mojom::blink::OriginTrialFeature::kCanvas2dMesh)) {
  static const IDLMemberInstaller::ExposedConstructConfig kExposedConstructTable[] = {
{"Mesh2DIndexBuffer", Mesh2DIndexBufferExposedConstructCallback}, 
{"Mesh2DUVBuffer", Mesh2DUVBufferExposedConstructCallback}, 
{"Mesh2DVertexBuffer", Mesh2DVertexBufferExposedConstructCallback}, 
};
v8::Local<v8::Signature> signature = v8::Local<v8::Signature>::Cast(interface_template);
IDLMemberInstaller::InstallExposedConstructs(isolate, world, instance_object, prototype_object, interface_object, signature, kExposedConstructTable);
}



}


}  // namespace blink
