// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_PAINT_CALLBACK_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_PAINT_CALLBACK_H_

#include "third_party/blink/renderer/bindings/core/v8/native_value_traits_impl.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/bindings/callback_function_base.h"
#include "third_party/blink/renderer/platform/bindings/v8_value_or_script_wrappable_adapter.h"
#include "third_party/blink/renderer/platform/heap/collection_support/heap_vector.h"
#include "third_party/blink/renderer/platform/heap/member.h"

namespace blink {

class CSSStyleValue;
class PaintRenderingContext2D;
class PaintSize;
class StylePropertyMapReadOnly;

class MODULES_EXPORT V8PaintCallback final : public CallbackFunctionBase {
  
  public:
static V8PaintCallback* Create(v8::Local<v8::Object> callback_object) {
  return MakeGarbageCollected<V8PaintCallback>(callback_object);
}

explicit  V8PaintCallback(v8::Local<v8::Object> callback_object) : CallbackFunctionBase(callback_object) {
  
}
 ~V8PaintCallback() override = default;

// NameClient overrides:
const char* GetHumanReadableName() const override;

// Performs "invoke".
// https://webidl.spec.whatwg.org/#invoke-a-callback-function
[[nodiscard]] v8::Maybe<void> Invoke(bindings::V8ValueOrScriptWrappableAdapter arg0_receiver, PaintRenderingContext2D* arg1_rendering_context, PaintSize* arg2_paint_size, StylePropertyMapReadOnly* arg3_style_map, const HeapVector<Member<CSSStyleValue>>& arg4_input_arguments);

// Performs "construct".
// https://webidl.spec.whatwg.org/#construct-a-callback-function
[[nodiscard]] v8::Maybe<void> Construct(PaintRenderingContext2D* arg1_rendering_context, PaintSize* arg2_paint_size, StylePropertyMapReadOnly* arg3_style_map, const HeapVector<Member<CSSStyleValue>>& arg4_input_arguments);

// Performs "invoke" and then reports an exception if any to the global
// error handler such as DevTools console.
void InvokeAndReportException(bindings::V8ValueOrScriptWrappableAdapter arg0_receiver, PaintRenderingContext2D* arg1_rendering_context, PaintSize* arg2_paint_size, StylePropertyMapReadOnly* arg3_style_map, const HeapVector<Member<CSSStyleValue>>& arg4_input_arguments);



  
  
  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_PAINT_CALLBACK_H_
