// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#include "third_party/blink/renderer/bindings/modules/v8/v8_notification_options.h"

#include "third_party/blink/renderer/bindings/core/v8/generated_code_helper.h"
#include "third_party/blink/renderer/bindings/core/v8/native_value_traits_impl.h"
#include "third_party/blink/renderer/bindings/core/v8/to_v8_traits.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_union_unsignedlong_unsignedlongsequence.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_notification_action.h"
#include "third_party/blink/renderer/core/execution_context/execution_context.h"
#include "third_party/blink/renderer/modules/notifications/timestamp_trigger.h"
#include "third_party/blink/renderer/platform/bindings/exception_messages.h"
#include "third_party/blink/renderer/platform/bindings/exception_state.h"
#include "third_party/blink/renderer/platform/bindings/v8_per_isolate_data.h"
#include "third_party/blink/renderer/platform/runtime_enabled_features.h"

namespace blink {



namespace  {

const std::string_view kOwnPropertyNames[] = {
"actions",
"badge",
"body",
"data",
"dir",
"icon",
"image",
"lang",
"renotify",
"requireInteraction",
"scenario",
"showTrigger",
"silent",
"tag",
"timestamp",
"vibrate",
};


}  // namespace 

NotificationOptions* NotificationOptions::Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state) {
  NotificationOptions* dictionary = MakeGarbageCollected<NotificationOptions>(isolate);
if (v8_value->IsNullOrUndefined()) {
  return dictionary;
}
if (!v8_value->IsObject()) {
  const char* const class_like_name = "NotificationOptions";
exception_state.ThrowTypeError(ExceptionMessages::ValueNotOfType(class_like_name));
return nullptr;
}
dictionary->FillMembersFromV8Object(isolate, v8_value.As<v8::Object>(), exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return nullptr;
}
return dictionary;
}

 NotificationOptions::NotificationOptions(v8::Isolate* isolate) : member_data_(isolate, v8::Null(isolate)) {
  
}



void NotificationOptions::setActions(const HeapVector<Member<NotificationAction>>& value) {
  member_actions_ = value;
}

void NotificationOptions::setActions(HeapVector<Member<NotificationAction>>&& value) {
  member_actions_ = std::move(value);
}




String NotificationOptions::getBadgeOr(const String& fallback_value) const {
  if (!hasBadge()) {
  return fallback_value;
}
return member_badge_;
}

String NotificationOptions::getBadgeOr(String&& fallback_value) const {
  if (!hasBadge()) {
  return std::move(fallback_value);
}
return member_badge_;
}

void NotificationOptions::setBadge(const String& value) {
  member_badge_ = value;
has_badge_ = true;
}

void NotificationOptions::setBadge(String&& value) {
  member_badge_ = std::move(value);
has_badge_ = true;
}




void NotificationOptions::setBody(const String& value) {
  member_body_ = value;
}

void NotificationOptions::setBody(String&& value) {
  member_body_ = std::move(value);
}














String NotificationOptions::getIconOr(const String& fallback_value) const {
  if (!hasIcon()) {
  return fallback_value;
}
return member_icon_;
}

String NotificationOptions::getIconOr(String&& fallback_value) const {
  if (!hasIcon()) {
  return std::move(fallback_value);
}
return member_icon_;
}

void NotificationOptions::setIcon(const String& value) {
  member_icon_ = value;
has_icon_ = true;
}

void NotificationOptions::setIcon(String&& value) {
  member_icon_ = std::move(value);
has_icon_ = true;
}




String NotificationOptions::getImageOr(const String& fallback_value) const {
  if (!hasImage()) {
  return fallback_value;
}
return member_image_;
}

String NotificationOptions::getImageOr(String&& fallback_value) const {
  if (!hasImage()) {
  return std::move(fallback_value);
}
return member_image_;
}

void NotificationOptions::setImage(const String& value) {
  member_image_ = value;
has_image_ = true;
}

void NotificationOptions::setImage(String&& value) {
  member_image_ = std::move(value);
has_image_ = true;
}




void NotificationOptions::setLang(const String& value) {
  member_lang_ = value;
}

void NotificationOptions::setLang(String&& value) {
  member_lang_ = std::move(value);
}































void NotificationOptions::setTag(const String& value) {
  member_tag_ = value;
}

void NotificationOptions::setTag(String&& value) {
  member_tag_ = std::move(value);
}


















void NotificationOptions::Trace(Visitor* visitor) const {
  visitor->Trace(member_actions_);
visitor->Trace(member_data_);
visitor->Trace(member_show_trigger_);
visitor->Trace(member_vibrate_);
bindings::InputDictionaryBase::Trace(visitor);
}

void NotificationOptions::FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state) {
  TryRethrowScope rethrow_scope(isolate, exception_state);
const char* const class_like_name = "NotificationOptions";
DictionaryConversionContext dictionary_from_v8_context(isolate, class_like_name);
dictionary_from_v8_context.SetCurrentPropertyName("actions");
constexpr bool is_optional = false;
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
const auto& v8_own_member_names = GetV8OwnMemberNames(isolate);
bool fallback_presence_var;
if (!bindings::GetDictionaryMemberFromV8Object<IDLSequence<NotificationAction>, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[0].Get(isolate), fallback_presence_var, member_actions_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("badge");
if (!bindings::GetDictionaryMemberFromV8Object<IDLUSVString, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[1].Get(isolate), has_badge_, member_badge_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("body");
if (!bindings::GetDictionaryMemberFromV8Object<IDLString, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[2].Get(isolate), fallback_presence_var, member_body_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("data");
if (!bindings::GetDictionaryMemberFromV8Object<IDLAny, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[3].Get(isolate), fallback_presence_var, member_data_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("dir");
if (!bindings::GetDictionaryMemberFromV8Object<V8NotificationDirection, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[4].Get(isolate), fallback_presence_var, member_dir_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("icon");
if (!bindings::GetDictionaryMemberFromV8Object<IDLUSVString, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[5].Get(isolate), has_icon_, member_icon_, class_like_name, exception_state)) {
  return;
}
if (RuntimeEnabledFeatures::NotificationContentImageEnabled()) {
  dictionary_from_v8_context.SetCurrentPropertyName("image");
if (!bindings::GetDictionaryMemberFromV8Object<IDLUSVString, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[6].Get(isolate), has_image_, member_image_, class_like_name, exception_state)) {
  return;
}
}
dictionary_from_v8_context.SetCurrentPropertyName("lang");
if (!bindings::GetDictionaryMemberFromV8Object<IDLString, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[7].Get(isolate), fallback_presence_var, member_lang_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("renotify");
if (!bindings::GetDictionaryMemberFromV8Object<IDLBoolean, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[8].Get(isolate), fallback_presence_var, member_renotify_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("requireInteraction");
if (!bindings::GetDictionaryMemberFromV8Object<IDLBoolean, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[9].Get(isolate), fallback_presence_var, member_require_interaction_, class_like_name, exception_state)) {
  return;
}
ExecutionContext* execution_context = ExecutionContext::From(current_context);
if (RuntimeEnabledFeatures::IncomingCallNotificationsEnabled(execution_context)) {
  dictionary_from_v8_context.SetCurrentPropertyName("scenario");
if (!bindings::GetDictionaryMemberFromV8Object<V8NotificationScenario, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[10].Get(isolate), fallback_presence_var, member_scenario_, class_like_name, exception_state)) {
  return;
}
}
if (RuntimeEnabledFeatures::NotificationTriggersEnabled(execution_context)) {
  dictionary_from_v8_context.SetCurrentPropertyName("showTrigger");
if (!bindings::GetDictionaryMemberFromV8Object<TimestampTrigger, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[11].Get(isolate), has_show_trigger_, member_show_trigger_, class_like_name, exception_state)) {
  return;
}
}
dictionary_from_v8_context.SetCurrentPropertyName("silent");
if (!bindings::GetDictionaryMemberFromV8Object<IDLBoolean, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[12].Get(isolate), fallback_presence_var, member_silent_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("tag");
if (!bindings::GetDictionaryMemberFromV8Object<IDLString, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[13].Get(isolate), fallback_presence_var, member_tag_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("timestamp");
if (!bindings::GetDictionaryMemberFromV8Object<IDLUnsignedLongLong, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[14].Get(isolate), has_timestamp_, member_timestamp_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("vibrate");
if (!bindings::GetDictionaryMemberFromV8Object<V8UnionUnsignedLongOrUnsignedLongSequence, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[15].Get(isolate), has_vibrate_, member_vibrate_, class_like_name, exception_state)) {
  return;
}
}

const base::span<const v8::Eternal<v8::Name>> NotificationOptions::GetV8OwnMemberNames(v8::Isolate* isolate) {
  return V8PerIsolateData::From(isolate)->FindOrCreateEternalNameCache(kOwnPropertyNames, kOwnPropertyNames);
}


}  // namespace blink
