// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#include "third_party/blink/renderer/bindings/modules/v8/v8_ndef_record_init.h"

#include "third_party/blink/renderer/bindings/core/v8/generated_code_helper.h"
#include "third_party/blink/renderer/bindings/core/v8/native_value_traits_impl.h"
#include "third_party/blink/renderer/bindings/core/v8/to_v8_traits.h"
#include "third_party/blink/renderer/platform/bindings/exception_messages.h"
#include "third_party/blink/renderer/platform/bindings/exception_state.h"
#include "third_party/blink/renderer/platform/bindings/v8_per_isolate_data.h"

namespace blink {



namespace  {

const std::string_view kOwnPropertyNames[] = {
"data",
"encoding",
"id",
"lang",
"mediaType",
"recordType",
};


}  // namespace 

NDEFRecordInit* NDEFRecordInit::Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state) {
  NDEFRecordInit* dictionary = MakeGarbageCollected<NDEFRecordInit>(isolate);
if (!v8_value->IsObject()) {
  const char* const class_like_name = "NDEFRecordInit";
exception_state.ThrowTypeError(ExceptionMessages::ValueNotOfType(class_like_name));
return nullptr;
}
dictionary->FillMembersFromV8Object(isolate, v8_value.As<v8::Object>(), exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return nullptr;
}
return dictionary;
}

 NDEFRecordInit::NDEFRecordInit() {
  
}

 NDEFRecordInit::NDEFRecordInit(v8::Isolate* isolate) {
  
}










String NDEFRecordInit::getEncodingOr(const String& fallback_value) const {
  if (!hasEncoding()) {
  return fallback_value;
}
return member_encoding_;
}

String NDEFRecordInit::getEncodingOr(String&& fallback_value) const {
  if (!hasEncoding()) {
  return std::move(fallback_value);
}
return member_encoding_;
}

void NDEFRecordInit::setEncoding(const String& value) {
  member_encoding_ = value;
has_encoding_ = true;
}

void NDEFRecordInit::setEncoding(String&& value) {
  member_encoding_ = std::move(value);
has_encoding_ = true;
}




String NDEFRecordInit::getIdOr(const String& fallback_value) const {
  if (!hasId()) {
  return fallback_value;
}
return member_id_;
}

String NDEFRecordInit::getIdOr(String&& fallback_value) const {
  if (!hasId()) {
  return std::move(fallback_value);
}
return member_id_;
}

void NDEFRecordInit::setId(const String& value) {
  member_id_ = value;
has_id_ = true;
}

void NDEFRecordInit::setId(String&& value) {
  member_id_ = std::move(value);
has_id_ = true;
}




String NDEFRecordInit::getLangOr(const String& fallback_value) const {
  if (!hasLang()) {
  return fallback_value;
}
return member_lang_;
}

String NDEFRecordInit::getLangOr(String&& fallback_value) const {
  if (!hasLang()) {
  return std::move(fallback_value);
}
return member_lang_;
}

void NDEFRecordInit::setLang(const String& value) {
  member_lang_ = value;
has_lang_ = true;
}

void NDEFRecordInit::setLang(String&& value) {
  member_lang_ = std::move(value);
has_lang_ = true;
}




String NDEFRecordInit::getMediaTypeOr(const String& fallback_value) const {
  if (!hasMediaType()) {
  return fallback_value;
}
return member_media_type_;
}

String NDEFRecordInit::getMediaTypeOr(String&& fallback_value) const {
  if (!hasMediaType()) {
  return std::move(fallback_value);
}
return member_media_type_;
}

void NDEFRecordInit::setMediaType(const String& value) {
  member_media_type_ = value;
has_media_type_ = true;
}

void NDEFRecordInit::setMediaType(String&& value) {
  member_media_type_ = std::move(value);
has_media_type_ = true;
}




void NDEFRecordInit::setRecordType(const String& value) {
  member_record_type_ = value;
}

void NDEFRecordInit::setRecordType(String&& value) {
  member_record_type_ = std::move(value);
}




void NDEFRecordInit::Trace(Visitor* visitor) const {
  visitor->Trace(member_data_);
bindings::InputDictionaryBase::Trace(visitor);
}

void NDEFRecordInit::FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state) {
  TryRethrowScope rethrow_scope(isolate, exception_state);
const char* const class_like_name = "NDEFRecordInit";
DictionaryConversionContext dictionary_from_v8_context(isolate, class_like_name);
dictionary_from_v8_context.SetCurrentPropertyName("data");
constexpr bool is_optional = false;
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
const auto& v8_own_member_names = GetV8OwnMemberNames(isolate);
bool fallback_presence_var;
if (!bindings::GetDictionaryMemberFromV8Object<IDLAny, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[0].Get(isolate), fallback_presence_var, member_data_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("encoding");
if (!bindings::GetDictionaryMemberFromV8Object<IDLUSVString, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[1].Get(isolate), has_encoding_, member_encoding_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("id");
if (!bindings::GetDictionaryMemberFromV8Object<IDLUSVString, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[2].Get(isolate), has_id_, member_id_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("lang");
if (!bindings::GetDictionaryMemberFromV8Object<IDLUSVString, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[3].Get(isolate), has_lang_, member_lang_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("mediaType");
if (!bindings::GetDictionaryMemberFromV8Object<IDLUSVString, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[4].Get(isolate), has_media_type_, member_media_type_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("recordType");
constexpr bool is_required = true;
if (!bindings::GetDictionaryMemberFromV8Object<IDLUSVString, is_required>(isolate, current_context, v8_dictionary, v8_own_member_names[5].Get(isolate), fallback_presence_var, member_record_type_, class_like_name, exception_state)) {
  return;
}
}

const base::span<const v8::Eternal<v8::Name>> NDEFRecordInit::GetV8OwnMemberNames(v8::Isolate* isolate) {
  return V8PerIsolateData::From(isolate)->FindOrCreateEternalNameCache(kOwnPropertyNames, kOwnPropertyNames);
}


}  // namespace blink
