// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_ML_QUANTIZE_DEQUANTIZE_LINEAR_SUPPORT_LIMITS_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_ML_QUANTIZE_DEQUANTIZE_LINEAR_SUPPORT_LIMITS_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"
#include "third_party/blink/renderer/platform/heap/member.h"

namespace blink {

class ExceptionState;
class MLTensorLimits;

class MODULES_EXPORT MLQuantizeDequantizeLinearSupportLimits : public bindings::DictionaryBase {
  
  public:
static MLQuantizeDequantizeLinearSupportLimits* Create() {
  return MakeGarbageCollected<MLQuantizeDequantizeLinearSupportLimits>();
}
static MLQuantizeDequantizeLinearSupportLimits* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<MLQuantizeDequantizeLinearSupportLimits>(isolate);
}
static MLQuantizeDequantizeLinearSupportLimits* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  MLQuantizeDequantizeLinearSupportLimits();
explicit  MLQuantizeDequantizeLinearSupportLimits(v8::Isolate* isolate);

bool hasInput() const {
  return has_input_;
}
MLTensorLimits* input() const {
  DCHECK(hasInput());
return member_input_.Get();
}
MLTensorLimits* getInputOr(MLTensorLimits* fallback_value) const {
  if (!hasInput()) {
  return fallback_value;
}
return member_input_.Get();
}
void setInput(MLTensorLimits* value) {
  member_input_ = value;
has_input_ = true;
DCHECK(member_input_);
}

bool hasOutput() const {
  return has_output_;
}
MLTensorLimits* output() const {
  DCHECK(hasOutput());
return member_output_.Get();
}
MLTensorLimits* getOutputOr(MLTensorLimits* fallback_value) const {
  if (!hasOutput()) {
  return fallback_value;
}
return member_output_.Get();
}
void setOutput(MLTensorLimits* value) {
  member_output_ = value;
has_output_ = true;
DCHECK(member_output_);
}

bool hasScale() const {
  return has_scale_;
}
MLTensorLimits* scale() const {
  DCHECK(hasScale());
return member_scale_.Get();
}
MLTensorLimits* getScaleOr(MLTensorLimits* fallback_value) const {
  if (!hasScale()) {
  return fallback_value;
}
return member_scale_.Get();
}
void setScale(MLTensorLimits* value) {
  member_scale_ = value;
has_scale_ = true;
DCHECK(member_scale_);
}

bool hasZeroPoint() const {
  return has_zero_point_;
}
MLTensorLimits* zeroPoint() const {
  DCHECK(hasZeroPoint());
return member_zero_point_.Get();
}
MLTensorLimits* getZeroPointOr(MLTensorLimits* fallback_value) const {
  if (!hasZeroPoint()) {
  return fallback_value;
}
return member_zero_point_.Get();
}
void setZeroPoint(MLTensorLimits* value) {
  member_zero_point_ = value;
has_zero_point_ = true;
DCHECK(member_zero_point_);
}




void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 4;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillTemplateProperties(Vector<std::string_view>& properties) const override;
void FillValuesImpl(ScriptState* script_state, base::span<v8::MaybeLocal<v8::Value>> values) const;


void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
const void* TemplateKey() const override;
v8::Local<v8::Object> FillValues(ScriptState* script_state, v8::Local<v8::DictionaryTemplate> dict_template) const override;
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_input_ = false;
bool has_output_ = false;
bool has_scale_ = false;
bool has_zero_point_ = false;

Member<MLTensorLimits> member_input_;
Member<MLTensorLimits> member_output_;
Member<MLTensorLimits> member_scale_;
Member<MLTensorLimits> member_zero_point_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_ML_QUANTIZE_DEQUANTIZE_LINEAR_SUPPORT_LIMITS_H_
