// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_ML_OPERAND_DESCRIPTOR_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_ML_OPERAND_DESCRIPTOR_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_ml_operand_data_type.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"
#include "third_party/blink/renderer/platform/heap/collection_support/heap_vector.h"

namespace blink {

class ExceptionState;

class MODULES_EXPORT MLOperandDescriptor : public bindings::InputDictionaryBase {
  
  public:
static MLOperandDescriptor* Create() {
  return MakeGarbageCollected<MLOperandDescriptor>();
}
static MLOperandDescriptor* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<MLOperandDescriptor>(isolate);
}
static MLOperandDescriptor* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  MLOperandDescriptor();
explicit  MLOperandDescriptor(v8::Isolate* isolate);

bool hasDataType() const {
  return true;
}
V8MLOperandDataType dataType() const {
  return member_data_type_;
}
void setDataType(V8MLOperandDataType value) {
  member_data_type_ = value;
}
void setDataType(V8MLOperandDataType::Enum value) {
  member_data_type_ = V8MLOperandDataType(value);
}

bool hasShape() const {
  return true;
}
const Vector<uint32_t>& shape() const {
  return member_shape_;
}
void setShape(const Vector<uint32_t>& value);
void setShape(Vector<uint32_t>&& value);




void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 2;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);



V8MLOperandDataType member_data_type_{static_cast<V8MLOperandDataType::Enum>(0)};
Vector<uint32_t> member_shape_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_ML_OPERAND_DESCRIPTOR_H_
