// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#include "third_party/blink/renderer/bindings/modules/v8/v8_ml_op_support_limits.h"

#include "third_party/blink/renderer/bindings/core/v8/generated_code_helper.h"
#include "third_party/blink/renderer/bindings/core/v8/native_value_traits_impl.h"
#include "third_party/blink/renderer/bindings/core/v8/to_v8_traits.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_ml_batch_normalization_support_limits.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_ml_binary_support_limits.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_ml_concat_support_limits.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_ml_conv_2d_support_limits.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_ml_gather_support_limits.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_ml_gemm_support_limits.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_ml_gru_cell_support_limits.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_ml_gru_support_limits.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_ml_logical_not_support_limits.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_ml_lstm_cell_support_limits.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_ml_lstm_support_limits.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_ml_normalization_support_limits.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_ml_prelu_support_limits.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_ml_quantize_dequantize_linear_support_limits.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_ml_scatter_support_limits.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_ml_single_input_support_limits.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_ml_split_support_limits.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_ml_tensor_limits.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_ml_where_support_limits.h"
#include "third_party/blink/renderer/platform/bindings/exception_messages.h"
#include "third_party/blink/renderer/platform/bindings/exception_state.h"
#include "third_party/blink/renderer/platform/bindings/v8_per_isolate_data.h"

namespace blink {



namespace  {

const std::string_view kOwnPropertyNames[] = {
"abs",
"add",
"argMax",
"argMin",
"averagePool2d",
"batchNormalization",
"cast",
"ceil",
"clamp",
"concat",
"constant",
"conv2d",
"convTranspose2d",
"cos",
"cumulativeSum",
"dequantizeLinear",
"div",
"elu",
"equal",
"erf",
"exp",
"expand",
"floor",
"gather",
"gatherElements",
"gatherND",
"gelu",
"gemm",
"greater",
"greaterOrEqual",
"gru",
"gruCell",
"hardSigmoid",
"hardSwish",
"identity",
"input",
"instanceNormalization",
"isInfinite",
"isNaN",
"l2Pool2d",
"layerNormalization",
"leakyRelu",
"lesser",
"lesserOrEqual",
"linear",
"log",
"logicalAnd",
"logicalNot",
"logicalOr",
"logicalXor",
"lstm",
"lstmCell",
"matmul",
"max",
"maxPool2d",
"maxTensorByteLength",
"min",
"mul",
"neg",
"notEqual",
"output",
"pad",
"pow",
"preferredInputLayout",
"prelu",
"quantizeLinear",
"reciprocal",
"reduceL1",
"reduceL2",
"reduceLogSum",
"reduceLogSumExp",
"reduceMax",
"reduceMean",
"reduceMin",
"reduceProduct",
"reduceSum",
"reduceSumSquare",
"relu",
"resample2d",
"reshape",
"reverse",
"roundEven",
"scatterElements",
"scatterND",
"sigmoid",
"sign",
"sin",
"slice",
"softmax",
"softplus",
"softsign",
"split",
"sqrt",
"sub",
"tan",
"tanh",
"tile",
"transpose",
"triangular",
"where",
};


}  // namespace 

MLOpSupportLimits* MLOpSupportLimits::Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state) {
  MLOpSupportLimits* dictionary = MakeGarbageCollected<MLOpSupportLimits>(isolate);
if (v8_value->IsNullOrUndefined()) {
  return dictionary;
}
if (!v8_value->IsObject()) {
  const char* const class_like_name = "MLOpSupportLimits";
exception_state.ThrowTypeError(ExceptionMessages::ValueNotOfType(class_like_name));
return nullptr;
}
dictionary->FillMembersFromV8Object(isolate, v8_value.As<v8::Object>(), exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return nullptr;
}
return dictionary;
}

 MLOpSupportLimits::MLOpSupportLimits() {
  
}

 MLOpSupportLimits::MLOpSupportLimits(v8::Isolate* isolate) {
  
}































































































































































































































































































































































































































































































































































































































































































































void MLOpSupportLimits::Trace(Visitor* visitor) const {
  visitor->Trace(member_abs_);
visitor->Trace(member_add_);
visitor->Trace(member_arg_max_);
visitor->Trace(member_arg_min_);
visitor->Trace(member_average_pool_2d_);
visitor->Trace(member_batch_normalization_);
visitor->Trace(member_cast_);
visitor->Trace(member_ceil_);
visitor->Trace(member_clamp_);
visitor->Trace(member_concat_);
visitor->Trace(member_constant_);
visitor->Trace(member_conv_2d_);
visitor->Trace(member_conv_transpose_2d_);
visitor->Trace(member_cos_);
visitor->Trace(member_cumulative_sum_);
visitor->Trace(member_dequantize_linear_);
visitor->Trace(member_div_);
visitor->Trace(member_elu_);
visitor->Trace(member_equal_);
visitor->Trace(member_erf_);
visitor->Trace(member_exp_);
visitor->Trace(member_expand_);
visitor->Trace(member_floor_);
visitor->Trace(member_gather_);
visitor->Trace(member_gather_elements_);
visitor->Trace(member_gather_nd_);
visitor->Trace(member_gelu_);
visitor->Trace(member_gemm_);
visitor->Trace(member_greater_);
visitor->Trace(member_greater_or_equal_);
visitor->Trace(member_gru_);
visitor->Trace(member_gru_cell_);
visitor->Trace(member_hard_sigmoid_);
visitor->Trace(member_hard_swish_);
visitor->Trace(member_identity_);
visitor->Trace(member_input_);
visitor->Trace(member_instance_normalization_);
visitor->Trace(member_is_infinite_);
visitor->Trace(member_is_na_n_);
visitor->Trace(member_l_2_pool_2d_);
visitor->Trace(member_layer_normalization_);
visitor->Trace(member_leaky_relu_);
visitor->Trace(member_lesser_);
visitor->Trace(member_lesser_or_equal_);
visitor->Trace(member_linear_);
visitor->Trace(member_log_);
visitor->Trace(member_logical_and_);
visitor->Trace(member_logical_not_);
visitor->Trace(member_logical_or_);
visitor->Trace(member_logical_xor_);
visitor->Trace(member_lstm_);
visitor->Trace(member_lstm_cell_);
visitor->Trace(member_matmul_);
visitor->Trace(member_max_);
visitor->Trace(member_max_pool_2d_);
visitor->Trace(member_min_);
visitor->Trace(member_mul_);
visitor->Trace(member_neg_);
visitor->Trace(member_not_equal_);
visitor->Trace(member_output_);
visitor->Trace(member_pad_);
visitor->Trace(member_pow_);
visitor->Trace(member_prelu_);
visitor->Trace(member_quantize_linear_);
visitor->Trace(member_reciprocal_);
visitor->Trace(member_reduce_l_1_);
visitor->Trace(member_reduce_l_2_);
visitor->Trace(member_reduce_log_sum_);
visitor->Trace(member_reduce_log_sum_exp_);
visitor->Trace(member_reduce_max_);
visitor->Trace(member_reduce_mean_);
visitor->Trace(member_reduce_min_);
visitor->Trace(member_reduce_product_);
visitor->Trace(member_reduce_sum_);
visitor->Trace(member_reduce_sum_square_);
visitor->Trace(member_relu_);
visitor->Trace(member_resample_2d_);
visitor->Trace(member_reshape_);
visitor->Trace(member_reverse_);
visitor->Trace(member_round_even_);
visitor->Trace(member_scatter_elements_);
visitor->Trace(member_scatter_nd_);
visitor->Trace(member_sigmoid_);
visitor->Trace(member_sign_);
visitor->Trace(member_sin_);
visitor->Trace(member_slice_);
visitor->Trace(member_softmax_);
visitor->Trace(member_softplus_);
visitor->Trace(member_softsign_);
visitor->Trace(member_split_);
visitor->Trace(member_sqrt_);
visitor->Trace(member_sub_);
visitor->Trace(member_tan_);
visitor->Trace(member_tanh_);
visitor->Trace(member_tile_);
visitor->Trace(member_transpose_);
visitor->Trace(member_triangular_);
visitor->Trace(member_where_);
bindings::DictionaryBase::Trace(visitor);
}

void MLOpSupportLimits::FillTemplateProperties(Vector<std::string_view>& properties) const {
  static_assert(std::size(kOwnPropertyNames) == kOwnPropertyCount);
properties.AppendRange(std::cbegin(kOwnPropertyNames), std::cend(kOwnPropertyNames));
DCHECK_EQ(properties.size(), kTotalPropertyCount);
}

void MLOpSupportLimits::FillValuesImpl(ScriptState* script_state, base::span<v8::MaybeLocal<v8::Value>> values) const {
  CHECK_EQ(kOwnPropertyCount, values.size());
if (hasAbs()) {
  values[0] = ToV8Traits<MLSingleInputSupportLimits>::ToV8(script_state, member_abs_.Get());
DCHECK(!values[0].IsEmpty());
}
if (hasAdd()) {
  values[1] = ToV8Traits<MLBinarySupportLimits>::ToV8(script_state, member_add_.Get());
DCHECK(!values[1].IsEmpty());
}
if (hasArgMax()) {
  values[2] = ToV8Traits<MLSingleInputSupportLimits>::ToV8(script_state, member_arg_max_.Get());
DCHECK(!values[2].IsEmpty());
}
if (hasArgMin()) {
  values[3] = ToV8Traits<MLSingleInputSupportLimits>::ToV8(script_state, member_arg_min_.Get());
DCHECK(!values[3].IsEmpty());
}
if (hasAveragePool2d()) {
  values[4] = ToV8Traits<MLSingleInputSupportLimits>::ToV8(script_state, member_average_pool_2d_.Get());
DCHECK(!values[4].IsEmpty());
}
if (hasBatchNormalization()) {
  values[5] = ToV8Traits<MLBatchNormalizationSupportLimits>::ToV8(script_state, member_batch_normalization_.Get());
DCHECK(!values[5].IsEmpty());
}
if (hasCast()) {
  values[6] = ToV8Traits<MLSingleInputSupportLimits>::ToV8(script_state, member_cast_.Get());
DCHECK(!values[6].IsEmpty());
}
if (hasCeil()) {
  values[7] = ToV8Traits<MLSingleInputSupportLimits>::ToV8(script_state, member_ceil_.Get());
DCHECK(!values[7].IsEmpty());
}
if (hasClamp()) {
  values[8] = ToV8Traits<MLSingleInputSupportLimits>::ToV8(script_state, member_clamp_.Get());
DCHECK(!values[8].IsEmpty());
}
if (hasConcat()) {
  values[9] = ToV8Traits<MLConcatSupportLimits>::ToV8(script_state, member_concat_.Get());
DCHECK(!values[9].IsEmpty());
}
if (hasConstant()) {
  values[10] = ToV8Traits<MLTensorLimits>::ToV8(script_state, member_constant_.Get());
DCHECK(!values[10].IsEmpty());
}
if (hasConv2d()) {
  values[11] = ToV8Traits<MLConv2dSupportLimits>::ToV8(script_state, member_conv_2d_.Get());
DCHECK(!values[11].IsEmpty());
}
if (hasConvTranspose2d()) {
  values[12] = ToV8Traits<MLConv2dSupportLimits>::ToV8(script_state, member_conv_transpose_2d_.Get());
DCHECK(!values[12].IsEmpty());
}
if (hasCos()) {
  values[13] = ToV8Traits<MLSingleInputSupportLimits>::ToV8(script_state, member_cos_.Get());
DCHECK(!values[13].IsEmpty());
}
if (hasCumulativeSum()) {
  values[14] = ToV8Traits<MLSingleInputSupportLimits>::ToV8(script_state, member_cumulative_sum_.Get());
DCHECK(!values[14].IsEmpty());
}
if (hasDequantizeLinear()) {
  values[15] = ToV8Traits<MLQuantizeDequantizeLinearSupportLimits>::ToV8(script_state, member_dequantize_linear_.Get());
DCHECK(!values[15].IsEmpty());
}
if (hasDiv()) {
  values[16] = ToV8Traits<MLBinarySupportLimits>::ToV8(script_state, member_div_.Get());
DCHECK(!values[16].IsEmpty());
}
if (hasElu()) {
  values[17] = ToV8Traits<MLSingleInputSupportLimits>::ToV8(script_state, member_elu_.Get());
DCHECK(!values[17].IsEmpty());
}
if (hasEqual()) {
  values[18] = ToV8Traits<MLBinarySupportLimits>::ToV8(script_state, member_equal_.Get());
DCHECK(!values[18].IsEmpty());
}
if (hasErf()) {
  values[19] = ToV8Traits<MLSingleInputSupportLimits>::ToV8(script_state, member_erf_.Get());
DCHECK(!values[19].IsEmpty());
}
if (hasExp()) {
  values[20] = ToV8Traits<MLSingleInputSupportLimits>::ToV8(script_state, member_exp_.Get());
DCHECK(!values[20].IsEmpty());
}
if (hasExpand()) {
  values[21] = ToV8Traits<MLSingleInputSupportLimits>::ToV8(script_state, member_expand_.Get());
DCHECK(!values[21].IsEmpty());
}
if (hasFloor()) {
  values[22] = ToV8Traits<MLSingleInputSupportLimits>::ToV8(script_state, member_floor_.Get());
DCHECK(!values[22].IsEmpty());
}
if (hasGather()) {
  values[23] = ToV8Traits<MLGatherSupportLimits>::ToV8(script_state, member_gather_.Get());
DCHECK(!values[23].IsEmpty());
}
if (hasGatherElements()) {
  values[24] = ToV8Traits<MLGatherSupportLimits>::ToV8(script_state, member_gather_elements_.Get());
DCHECK(!values[24].IsEmpty());
}
if (hasGatherND()) {
  values[25] = ToV8Traits<MLGatherSupportLimits>::ToV8(script_state, member_gather_nd_.Get());
DCHECK(!values[25].IsEmpty());
}
if (hasGelu()) {
  values[26] = ToV8Traits<MLSingleInputSupportLimits>::ToV8(script_state, member_gelu_.Get());
DCHECK(!values[26].IsEmpty());
}
if (hasGemm()) {
  values[27] = ToV8Traits<MLGemmSupportLimits>::ToV8(script_state, member_gemm_.Get());
DCHECK(!values[27].IsEmpty());
}
if (hasGreater()) {
  values[28] = ToV8Traits<MLBinarySupportLimits>::ToV8(script_state, member_greater_.Get());
DCHECK(!values[28].IsEmpty());
}
if (hasGreaterOrEqual()) {
  values[29] = ToV8Traits<MLBinarySupportLimits>::ToV8(script_state, member_greater_or_equal_.Get());
DCHECK(!values[29].IsEmpty());
}
if (hasGru()) {
  values[30] = ToV8Traits<MLGruSupportLimits>::ToV8(script_state, member_gru_.Get());
DCHECK(!values[30].IsEmpty());
}
if (hasGruCell()) {
  values[31] = ToV8Traits<MLGruCellSupportLimits>::ToV8(script_state, member_gru_cell_.Get());
DCHECK(!values[31].IsEmpty());
}
if (hasHardSigmoid()) {
  values[32] = ToV8Traits<MLSingleInputSupportLimits>::ToV8(script_state, member_hard_sigmoid_.Get());
DCHECK(!values[32].IsEmpty());
}
if (hasHardSwish()) {
  values[33] = ToV8Traits<MLSingleInputSupportLimits>::ToV8(script_state, member_hard_swish_.Get());
DCHECK(!values[33].IsEmpty());
}
if (hasIdentity()) {
  values[34] = ToV8Traits<MLSingleInputSupportLimits>::ToV8(script_state, member_identity_.Get());
DCHECK(!values[34].IsEmpty());
}
if (hasInput()) {
  values[35] = ToV8Traits<MLTensorLimits>::ToV8(script_state, member_input_.Get());
DCHECK(!values[35].IsEmpty());
}
if (hasInstanceNormalization()) {
  values[36] = ToV8Traits<MLNormalizationSupportLimits>::ToV8(script_state, member_instance_normalization_.Get());
DCHECK(!values[36].IsEmpty());
}
if (hasIsInfinite()) {
  values[37] = ToV8Traits<MLLogicalNotSupportLimits>::ToV8(script_state, member_is_infinite_.Get());
DCHECK(!values[37].IsEmpty());
}
if (hasIsNaN()) {
  values[38] = ToV8Traits<MLLogicalNotSupportLimits>::ToV8(script_state, member_is_na_n_.Get());
DCHECK(!values[38].IsEmpty());
}
if (hasL2Pool2d()) {
  values[39] = ToV8Traits<MLSingleInputSupportLimits>::ToV8(script_state, member_l_2_pool_2d_.Get());
DCHECK(!values[39].IsEmpty());
}
if (hasLayerNormalization()) {
  values[40] = ToV8Traits<MLNormalizationSupportLimits>::ToV8(script_state, member_layer_normalization_.Get());
DCHECK(!values[40].IsEmpty());
}
if (hasLeakyRelu()) {
  values[41] = ToV8Traits<MLSingleInputSupportLimits>::ToV8(script_state, member_leaky_relu_.Get());
DCHECK(!values[41].IsEmpty());
}
if (hasLesser()) {
  values[42] = ToV8Traits<MLBinarySupportLimits>::ToV8(script_state, member_lesser_.Get());
DCHECK(!values[42].IsEmpty());
}
if (hasLesserOrEqual()) {
  values[43] = ToV8Traits<MLBinarySupportLimits>::ToV8(script_state, member_lesser_or_equal_.Get());
DCHECK(!values[43].IsEmpty());
}
if (hasLinear()) {
  values[44] = ToV8Traits<MLSingleInputSupportLimits>::ToV8(script_state, member_linear_.Get());
DCHECK(!values[44].IsEmpty());
}
if (hasLog()) {
  values[45] = ToV8Traits<MLSingleInputSupportLimits>::ToV8(script_state, member_log_.Get());
DCHECK(!values[45].IsEmpty());
}
if (hasLogicalAnd()) {
  values[46] = ToV8Traits<MLBinarySupportLimits>::ToV8(script_state, member_logical_and_.Get());
DCHECK(!values[46].IsEmpty());
}
if (hasLogicalNot()) {
  values[47] = ToV8Traits<MLLogicalNotSupportLimits>::ToV8(script_state, member_logical_not_.Get());
DCHECK(!values[47].IsEmpty());
}
if (hasLogicalOr()) {
  values[48] = ToV8Traits<MLBinarySupportLimits>::ToV8(script_state, member_logical_or_.Get());
DCHECK(!values[48].IsEmpty());
}
if (hasLogicalXor()) {
  values[49] = ToV8Traits<MLBinarySupportLimits>::ToV8(script_state, member_logical_xor_.Get());
DCHECK(!values[49].IsEmpty());
}
if (hasLstm()) {
  values[50] = ToV8Traits<MLLstmSupportLimits>::ToV8(script_state, member_lstm_.Get());
DCHECK(!values[50].IsEmpty());
}
if (hasLstmCell()) {
  values[51] = ToV8Traits<MLLstmCellSupportLimits>::ToV8(script_state, member_lstm_cell_.Get());
DCHECK(!values[51].IsEmpty());
}
if (hasMatmul()) {
  values[52] = ToV8Traits<MLBinarySupportLimits>::ToV8(script_state, member_matmul_.Get());
DCHECK(!values[52].IsEmpty());
}
if (hasMax()) {
  values[53] = ToV8Traits<MLBinarySupportLimits>::ToV8(script_state, member_max_.Get());
DCHECK(!values[53].IsEmpty());
}
if (hasMaxPool2d()) {
  values[54] = ToV8Traits<MLSingleInputSupportLimits>::ToV8(script_state, member_max_pool_2d_.Get());
DCHECK(!values[54].IsEmpty());
}
if (hasMaxTensorByteLength()) {
  values[55] = ToV8Traits<IDLUnsignedLongLongEnforceRange>::ToV8(script_state, member_max_tensor_byte_length_);
DCHECK(!values[55].IsEmpty());
}
if (hasMin()) {
  values[56] = ToV8Traits<MLBinarySupportLimits>::ToV8(script_state, member_min_.Get());
DCHECK(!values[56].IsEmpty());
}
if (hasMul()) {
  values[57] = ToV8Traits<MLBinarySupportLimits>::ToV8(script_state, member_mul_.Get());
DCHECK(!values[57].IsEmpty());
}
if (hasNeg()) {
  values[58] = ToV8Traits<MLSingleInputSupportLimits>::ToV8(script_state, member_neg_.Get());
DCHECK(!values[58].IsEmpty());
}
if (hasNotEqual()) {
  values[59] = ToV8Traits<MLBinarySupportLimits>::ToV8(script_state, member_not_equal_.Get());
DCHECK(!values[59].IsEmpty());
}
if (hasOutput()) {
  values[60] = ToV8Traits<MLTensorLimits>::ToV8(script_state, member_output_.Get());
DCHECK(!values[60].IsEmpty());
}
if (hasPad()) {
  values[61] = ToV8Traits<MLSingleInputSupportLimits>::ToV8(script_state, member_pad_.Get());
DCHECK(!values[61].IsEmpty());
}
if (hasPow()) {
  values[62] = ToV8Traits<MLBinarySupportLimits>::ToV8(script_state, member_pow_.Get());
DCHECK(!values[62].IsEmpty());
}
if (hasPreferredInputLayout()) {
  values[63] = ToV8Traits<V8MLInputOperandLayout>::ToV8(script_state, member_preferred_input_layout_);
DCHECK(!values[63].IsEmpty());
}
if (hasPrelu()) {
  values[64] = ToV8Traits<MLPreluSupportLimits>::ToV8(script_state, member_prelu_.Get());
DCHECK(!values[64].IsEmpty());
}
if (hasQuantizeLinear()) {
  values[65] = ToV8Traits<MLQuantizeDequantizeLinearSupportLimits>::ToV8(script_state, member_quantize_linear_.Get());
DCHECK(!values[65].IsEmpty());
}
if (hasReciprocal()) {
  values[66] = ToV8Traits<MLSingleInputSupportLimits>::ToV8(script_state, member_reciprocal_.Get());
DCHECK(!values[66].IsEmpty());
}
if (hasReduceL1()) {
  values[67] = ToV8Traits<MLSingleInputSupportLimits>::ToV8(script_state, member_reduce_l_1_.Get());
DCHECK(!values[67].IsEmpty());
}
if (hasReduceL2()) {
  values[68] = ToV8Traits<MLSingleInputSupportLimits>::ToV8(script_state, member_reduce_l_2_.Get());
DCHECK(!values[68].IsEmpty());
}
if (hasReduceLogSum()) {
  values[69] = ToV8Traits<MLSingleInputSupportLimits>::ToV8(script_state, member_reduce_log_sum_.Get());
DCHECK(!values[69].IsEmpty());
}
if (hasReduceLogSumExp()) {
  values[70] = ToV8Traits<MLSingleInputSupportLimits>::ToV8(script_state, member_reduce_log_sum_exp_.Get());
DCHECK(!values[70].IsEmpty());
}
if (hasReduceMax()) {
  values[71] = ToV8Traits<MLSingleInputSupportLimits>::ToV8(script_state, member_reduce_max_.Get());
DCHECK(!values[71].IsEmpty());
}
if (hasReduceMean()) {
  values[72] = ToV8Traits<MLSingleInputSupportLimits>::ToV8(script_state, member_reduce_mean_.Get());
DCHECK(!values[72].IsEmpty());
}
if (hasReduceMin()) {
  values[73] = ToV8Traits<MLSingleInputSupportLimits>::ToV8(script_state, member_reduce_min_.Get());
DCHECK(!values[73].IsEmpty());
}
if (hasReduceProduct()) {
  values[74] = ToV8Traits<MLSingleInputSupportLimits>::ToV8(script_state, member_reduce_product_.Get());
DCHECK(!values[74].IsEmpty());
}
if (hasReduceSum()) {
  values[75] = ToV8Traits<MLSingleInputSupportLimits>::ToV8(script_state, member_reduce_sum_.Get());
DCHECK(!values[75].IsEmpty());
}
if (hasReduceSumSquare()) {
  values[76] = ToV8Traits<MLSingleInputSupportLimits>::ToV8(script_state, member_reduce_sum_square_.Get());
DCHECK(!values[76].IsEmpty());
}
if (hasRelu()) {
  values[77] = ToV8Traits<MLSingleInputSupportLimits>::ToV8(script_state, member_relu_.Get());
DCHECK(!values[77].IsEmpty());
}
if (hasResample2d()) {
  values[78] = ToV8Traits<MLSingleInputSupportLimits>::ToV8(script_state, member_resample_2d_.Get());
DCHECK(!values[78].IsEmpty());
}
if (hasReshape()) {
  values[79] = ToV8Traits<MLSingleInputSupportLimits>::ToV8(script_state, member_reshape_.Get());
DCHECK(!values[79].IsEmpty());
}
if (hasReverse()) {
  values[80] = ToV8Traits<MLSingleInputSupportLimits>::ToV8(script_state, member_reverse_.Get());
DCHECK(!values[80].IsEmpty());
}
if (hasRoundEven()) {
  values[81] = ToV8Traits<MLSingleInputSupportLimits>::ToV8(script_state, member_round_even_.Get());
DCHECK(!values[81].IsEmpty());
}
if (hasScatterElements()) {
  values[82] = ToV8Traits<MLScatterSupportLimits>::ToV8(script_state, member_scatter_elements_.Get());
DCHECK(!values[82].IsEmpty());
}
if (hasScatterND()) {
  values[83] = ToV8Traits<MLScatterSupportLimits>::ToV8(script_state, member_scatter_nd_.Get());
DCHECK(!values[83].IsEmpty());
}
if (hasSigmoid()) {
  values[84] = ToV8Traits<MLSingleInputSupportLimits>::ToV8(script_state, member_sigmoid_.Get());
DCHECK(!values[84].IsEmpty());
}
if (hasSign()) {
  values[85] = ToV8Traits<MLSingleInputSupportLimits>::ToV8(script_state, member_sign_.Get());
DCHECK(!values[85].IsEmpty());
}
if (hasSin()) {
  values[86] = ToV8Traits<MLSingleInputSupportLimits>::ToV8(script_state, member_sin_.Get());
DCHECK(!values[86].IsEmpty());
}
if (hasSlice()) {
  values[87] = ToV8Traits<MLSingleInputSupportLimits>::ToV8(script_state, member_slice_.Get());
DCHECK(!values[87].IsEmpty());
}
if (hasSoftmax()) {
  values[88] = ToV8Traits<MLSingleInputSupportLimits>::ToV8(script_state, member_softmax_.Get());
DCHECK(!values[88].IsEmpty());
}
if (hasSoftplus()) {
  values[89] = ToV8Traits<MLSingleInputSupportLimits>::ToV8(script_state, member_softplus_.Get());
DCHECK(!values[89].IsEmpty());
}
if (hasSoftsign()) {
  values[90] = ToV8Traits<MLSingleInputSupportLimits>::ToV8(script_state, member_softsign_.Get());
DCHECK(!values[90].IsEmpty());
}
if (hasSplit()) {
  values[91] = ToV8Traits<MLSplitSupportLimits>::ToV8(script_state, member_split_.Get());
DCHECK(!values[91].IsEmpty());
}
if (hasSqrt()) {
  values[92] = ToV8Traits<MLSingleInputSupportLimits>::ToV8(script_state, member_sqrt_.Get());
DCHECK(!values[92].IsEmpty());
}
if (hasSub()) {
  values[93] = ToV8Traits<MLBinarySupportLimits>::ToV8(script_state, member_sub_.Get());
DCHECK(!values[93].IsEmpty());
}
if (hasTan()) {
  values[94] = ToV8Traits<MLSingleInputSupportLimits>::ToV8(script_state, member_tan_.Get());
DCHECK(!values[94].IsEmpty());
}
if (hasTanh()) {
  values[95] = ToV8Traits<MLSingleInputSupportLimits>::ToV8(script_state, member_tanh_.Get());
DCHECK(!values[95].IsEmpty());
}
if (hasTile()) {
  values[96] = ToV8Traits<MLSingleInputSupportLimits>::ToV8(script_state, member_tile_.Get());
DCHECK(!values[96].IsEmpty());
}
if (hasTranspose()) {
  values[97] = ToV8Traits<MLSingleInputSupportLimits>::ToV8(script_state, member_transpose_.Get());
DCHECK(!values[97].IsEmpty());
}
if (hasTriangular()) {
  values[98] = ToV8Traits<MLSingleInputSupportLimits>::ToV8(script_state, member_triangular_.Get());
DCHECK(!values[98].IsEmpty());
}
if (hasWhere()) {
  values[99] = ToV8Traits<MLWhereSupportLimits>::ToV8(script_state, member_where_.Get());
DCHECK(!values[99].IsEmpty());
}
}

const void* MLOpSupportLimits::TemplateKey() const {
  static const void *s_key = &s_key;
return s_key;
}

v8::Local<v8::Object> MLOpSupportLimits::FillValues(ScriptState* script_state, v8::Local<v8::DictionaryTemplate> dict_template) const {
  v8::MaybeLocal<v8::Value> values[kTotalPropertyCount];
FillValuesImpl(script_state, values);
return dict_template->NewInstance(script_state->GetContext(), values);
}

void MLOpSupportLimits::FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state) {
  TryRethrowScope rethrow_scope(isolate, exception_state);
const char* const class_like_name = "MLOpSupportLimits";
DictionaryConversionContext dictionary_from_v8_context(isolate, class_like_name);
dictionary_from_v8_context.SetCurrentPropertyName("abs");
constexpr bool is_optional = false;
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
const auto& v8_own_member_names = GetV8OwnMemberNames(isolate);
if (!bindings::GetDictionaryMemberFromV8Object<MLSingleInputSupportLimits, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[0].Get(isolate), has_abs_, member_abs_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("add");
if (!bindings::GetDictionaryMemberFromV8Object<MLBinarySupportLimits, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[1].Get(isolate), has_add_, member_add_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("argMax");
if (!bindings::GetDictionaryMemberFromV8Object<MLSingleInputSupportLimits, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[2].Get(isolate), has_arg_max_, member_arg_max_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("argMin");
if (!bindings::GetDictionaryMemberFromV8Object<MLSingleInputSupportLimits, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[3].Get(isolate), has_arg_min_, member_arg_min_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("averagePool2d");
if (!bindings::GetDictionaryMemberFromV8Object<MLSingleInputSupportLimits, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[4].Get(isolate), has_average_pool_2d_, member_average_pool_2d_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("batchNormalization");
if (!bindings::GetDictionaryMemberFromV8Object<MLBatchNormalizationSupportLimits, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[5].Get(isolate), has_batch_normalization_, member_batch_normalization_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("cast");
if (!bindings::GetDictionaryMemberFromV8Object<MLSingleInputSupportLimits, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[6].Get(isolate), has_cast_, member_cast_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("ceil");
if (!bindings::GetDictionaryMemberFromV8Object<MLSingleInputSupportLimits, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[7].Get(isolate), has_ceil_, member_ceil_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("clamp");
if (!bindings::GetDictionaryMemberFromV8Object<MLSingleInputSupportLimits, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[8].Get(isolate), has_clamp_, member_clamp_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("concat");
if (!bindings::GetDictionaryMemberFromV8Object<MLConcatSupportLimits, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[9].Get(isolate), has_concat_, member_concat_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("constant");
if (!bindings::GetDictionaryMemberFromV8Object<MLTensorLimits, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[10].Get(isolate), has_constant_, member_constant_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("conv2d");
if (!bindings::GetDictionaryMemberFromV8Object<MLConv2dSupportLimits, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[11].Get(isolate), has_conv_2d_, member_conv_2d_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("convTranspose2d");
if (!bindings::GetDictionaryMemberFromV8Object<MLConv2dSupportLimits, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[12].Get(isolate), has_conv_transpose_2d_, member_conv_transpose_2d_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("cos");
if (!bindings::GetDictionaryMemberFromV8Object<MLSingleInputSupportLimits, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[13].Get(isolate), has_cos_, member_cos_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("cumulativeSum");
if (!bindings::GetDictionaryMemberFromV8Object<MLSingleInputSupportLimits, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[14].Get(isolate), has_cumulative_sum_, member_cumulative_sum_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("dequantizeLinear");
if (!bindings::GetDictionaryMemberFromV8Object<MLQuantizeDequantizeLinearSupportLimits, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[15].Get(isolate), has_dequantize_linear_, member_dequantize_linear_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("div");
if (!bindings::GetDictionaryMemberFromV8Object<MLBinarySupportLimits, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[16].Get(isolate), has_div_, member_div_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("elu");
if (!bindings::GetDictionaryMemberFromV8Object<MLSingleInputSupportLimits, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[17].Get(isolate), has_elu_, member_elu_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("equal");
if (!bindings::GetDictionaryMemberFromV8Object<MLBinarySupportLimits, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[18].Get(isolate), has_equal_, member_equal_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("erf");
if (!bindings::GetDictionaryMemberFromV8Object<MLSingleInputSupportLimits, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[19].Get(isolate), has_erf_, member_erf_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("exp");
if (!bindings::GetDictionaryMemberFromV8Object<MLSingleInputSupportLimits, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[20].Get(isolate), has_exp_, member_exp_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("expand");
if (!bindings::GetDictionaryMemberFromV8Object<MLSingleInputSupportLimits, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[21].Get(isolate), has_expand_, member_expand_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("floor");
if (!bindings::GetDictionaryMemberFromV8Object<MLSingleInputSupportLimits, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[22].Get(isolate), has_floor_, member_floor_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("gather");
if (!bindings::GetDictionaryMemberFromV8Object<MLGatherSupportLimits, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[23].Get(isolate), has_gather_, member_gather_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("gatherElements");
if (!bindings::GetDictionaryMemberFromV8Object<MLGatherSupportLimits, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[24].Get(isolate), has_gather_elements_, member_gather_elements_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("gatherND");
if (!bindings::GetDictionaryMemberFromV8Object<MLGatherSupportLimits, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[25].Get(isolate), has_gather_nd_, member_gather_nd_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("gelu");
if (!bindings::GetDictionaryMemberFromV8Object<MLSingleInputSupportLimits, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[26].Get(isolate), has_gelu_, member_gelu_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("gemm");
if (!bindings::GetDictionaryMemberFromV8Object<MLGemmSupportLimits, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[27].Get(isolate), has_gemm_, member_gemm_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("greater");
if (!bindings::GetDictionaryMemberFromV8Object<MLBinarySupportLimits, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[28].Get(isolate), has_greater_, member_greater_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("greaterOrEqual");
if (!bindings::GetDictionaryMemberFromV8Object<MLBinarySupportLimits, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[29].Get(isolate), has_greater_or_equal_, member_greater_or_equal_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("gru");
if (!bindings::GetDictionaryMemberFromV8Object<MLGruSupportLimits, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[30].Get(isolate), has_gru_, member_gru_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("gruCell");
if (!bindings::GetDictionaryMemberFromV8Object<MLGruCellSupportLimits, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[31].Get(isolate), has_gru_cell_, member_gru_cell_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("hardSigmoid");
if (!bindings::GetDictionaryMemberFromV8Object<MLSingleInputSupportLimits, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[32].Get(isolate), has_hard_sigmoid_, member_hard_sigmoid_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("hardSwish");
if (!bindings::GetDictionaryMemberFromV8Object<MLSingleInputSupportLimits, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[33].Get(isolate), has_hard_swish_, member_hard_swish_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("identity");
if (!bindings::GetDictionaryMemberFromV8Object<MLSingleInputSupportLimits, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[34].Get(isolate), has_identity_, member_identity_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("input");
if (!bindings::GetDictionaryMemberFromV8Object<MLTensorLimits, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[35].Get(isolate), has_input_, member_input_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("instanceNormalization");
if (!bindings::GetDictionaryMemberFromV8Object<MLNormalizationSupportLimits, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[36].Get(isolate), has_instance_normalization_, member_instance_normalization_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("isInfinite");
if (!bindings::GetDictionaryMemberFromV8Object<MLLogicalNotSupportLimits, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[37].Get(isolate), has_is_infinite_, member_is_infinite_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("isNaN");
if (!bindings::GetDictionaryMemberFromV8Object<MLLogicalNotSupportLimits, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[38].Get(isolate), has_is_na_n_, member_is_na_n_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("l2Pool2d");
if (!bindings::GetDictionaryMemberFromV8Object<MLSingleInputSupportLimits, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[39].Get(isolate), has_l_2_pool_2d_, member_l_2_pool_2d_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("layerNormalization");
if (!bindings::GetDictionaryMemberFromV8Object<MLNormalizationSupportLimits, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[40].Get(isolate), has_layer_normalization_, member_layer_normalization_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("leakyRelu");
if (!bindings::GetDictionaryMemberFromV8Object<MLSingleInputSupportLimits, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[41].Get(isolate), has_leaky_relu_, member_leaky_relu_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("lesser");
if (!bindings::GetDictionaryMemberFromV8Object<MLBinarySupportLimits, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[42].Get(isolate), has_lesser_, member_lesser_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("lesserOrEqual");
if (!bindings::GetDictionaryMemberFromV8Object<MLBinarySupportLimits, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[43].Get(isolate), has_lesser_or_equal_, member_lesser_or_equal_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("linear");
if (!bindings::GetDictionaryMemberFromV8Object<MLSingleInputSupportLimits, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[44].Get(isolate), has_linear_, member_linear_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("log");
if (!bindings::GetDictionaryMemberFromV8Object<MLSingleInputSupportLimits, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[45].Get(isolate), has_log_, member_log_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("logicalAnd");
if (!bindings::GetDictionaryMemberFromV8Object<MLBinarySupportLimits, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[46].Get(isolate), has_logical_and_, member_logical_and_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("logicalNot");
if (!bindings::GetDictionaryMemberFromV8Object<MLLogicalNotSupportLimits, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[47].Get(isolate), has_logical_not_, member_logical_not_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("logicalOr");
if (!bindings::GetDictionaryMemberFromV8Object<MLBinarySupportLimits, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[48].Get(isolate), has_logical_or_, member_logical_or_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("logicalXor");
if (!bindings::GetDictionaryMemberFromV8Object<MLBinarySupportLimits, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[49].Get(isolate), has_logical_xor_, member_logical_xor_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("lstm");
if (!bindings::GetDictionaryMemberFromV8Object<MLLstmSupportLimits, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[50].Get(isolate), has_lstm_, member_lstm_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("lstmCell");
if (!bindings::GetDictionaryMemberFromV8Object<MLLstmCellSupportLimits, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[51].Get(isolate), has_lstm_cell_, member_lstm_cell_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("matmul");
if (!bindings::GetDictionaryMemberFromV8Object<MLBinarySupportLimits, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[52].Get(isolate), has_matmul_, member_matmul_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("max");
if (!bindings::GetDictionaryMemberFromV8Object<MLBinarySupportLimits, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[53].Get(isolate), has_max_, member_max_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("maxPool2d");
if (!bindings::GetDictionaryMemberFromV8Object<MLSingleInputSupportLimits, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[54].Get(isolate), has_max_pool_2d_, member_max_pool_2d_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("maxTensorByteLength");
if (!bindings::GetDictionaryMemberFromV8Object<IDLUnsignedLongLongEnforceRange, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[55].Get(isolate), has_max_tensor_byte_length_, member_max_tensor_byte_length_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("min");
if (!bindings::GetDictionaryMemberFromV8Object<MLBinarySupportLimits, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[56].Get(isolate), has_min_, member_min_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("mul");
if (!bindings::GetDictionaryMemberFromV8Object<MLBinarySupportLimits, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[57].Get(isolate), has_mul_, member_mul_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("neg");
if (!bindings::GetDictionaryMemberFromV8Object<MLSingleInputSupportLimits, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[58].Get(isolate), has_neg_, member_neg_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("notEqual");
if (!bindings::GetDictionaryMemberFromV8Object<MLBinarySupportLimits, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[59].Get(isolate), has_not_equal_, member_not_equal_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("output");
if (!bindings::GetDictionaryMemberFromV8Object<MLTensorLimits, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[60].Get(isolate), has_output_, member_output_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("pad");
if (!bindings::GetDictionaryMemberFromV8Object<MLSingleInputSupportLimits, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[61].Get(isolate), has_pad_, member_pad_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("pow");
if (!bindings::GetDictionaryMemberFromV8Object<MLBinarySupportLimits, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[62].Get(isolate), has_pow_, member_pow_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("preferredInputLayout");
if (!bindings::GetDictionaryMemberFromV8Object<V8MLInputOperandLayout, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[63].Get(isolate), has_preferred_input_layout_, member_preferred_input_layout_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("prelu");
if (!bindings::GetDictionaryMemberFromV8Object<MLPreluSupportLimits, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[64].Get(isolate), has_prelu_, member_prelu_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("quantizeLinear");
if (!bindings::GetDictionaryMemberFromV8Object<MLQuantizeDequantizeLinearSupportLimits, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[65].Get(isolate), has_quantize_linear_, member_quantize_linear_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("reciprocal");
if (!bindings::GetDictionaryMemberFromV8Object<MLSingleInputSupportLimits, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[66].Get(isolate), has_reciprocal_, member_reciprocal_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("reduceL1");
if (!bindings::GetDictionaryMemberFromV8Object<MLSingleInputSupportLimits, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[67].Get(isolate), has_reduce_l_1_, member_reduce_l_1_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("reduceL2");
if (!bindings::GetDictionaryMemberFromV8Object<MLSingleInputSupportLimits, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[68].Get(isolate), has_reduce_l_2_, member_reduce_l_2_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("reduceLogSum");
if (!bindings::GetDictionaryMemberFromV8Object<MLSingleInputSupportLimits, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[69].Get(isolate), has_reduce_log_sum_, member_reduce_log_sum_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("reduceLogSumExp");
if (!bindings::GetDictionaryMemberFromV8Object<MLSingleInputSupportLimits, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[70].Get(isolate), has_reduce_log_sum_exp_, member_reduce_log_sum_exp_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("reduceMax");
if (!bindings::GetDictionaryMemberFromV8Object<MLSingleInputSupportLimits, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[71].Get(isolate), has_reduce_max_, member_reduce_max_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("reduceMean");
if (!bindings::GetDictionaryMemberFromV8Object<MLSingleInputSupportLimits, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[72].Get(isolate), has_reduce_mean_, member_reduce_mean_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("reduceMin");
if (!bindings::GetDictionaryMemberFromV8Object<MLSingleInputSupportLimits, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[73].Get(isolate), has_reduce_min_, member_reduce_min_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("reduceProduct");
if (!bindings::GetDictionaryMemberFromV8Object<MLSingleInputSupportLimits, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[74].Get(isolate), has_reduce_product_, member_reduce_product_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("reduceSum");
if (!bindings::GetDictionaryMemberFromV8Object<MLSingleInputSupportLimits, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[75].Get(isolate), has_reduce_sum_, member_reduce_sum_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("reduceSumSquare");
if (!bindings::GetDictionaryMemberFromV8Object<MLSingleInputSupportLimits, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[76].Get(isolate), has_reduce_sum_square_, member_reduce_sum_square_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("relu");
if (!bindings::GetDictionaryMemberFromV8Object<MLSingleInputSupportLimits, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[77].Get(isolate), has_relu_, member_relu_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("resample2d");
if (!bindings::GetDictionaryMemberFromV8Object<MLSingleInputSupportLimits, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[78].Get(isolate), has_resample_2d_, member_resample_2d_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("reshape");
if (!bindings::GetDictionaryMemberFromV8Object<MLSingleInputSupportLimits, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[79].Get(isolate), has_reshape_, member_reshape_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("reverse");
if (!bindings::GetDictionaryMemberFromV8Object<MLSingleInputSupportLimits, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[80].Get(isolate), has_reverse_, member_reverse_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("roundEven");
if (!bindings::GetDictionaryMemberFromV8Object<MLSingleInputSupportLimits, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[81].Get(isolate), has_round_even_, member_round_even_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("scatterElements");
if (!bindings::GetDictionaryMemberFromV8Object<MLScatterSupportLimits, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[82].Get(isolate), has_scatter_elements_, member_scatter_elements_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("scatterND");
if (!bindings::GetDictionaryMemberFromV8Object<MLScatterSupportLimits, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[83].Get(isolate), has_scatter_nd_, member_scatter_nd_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("sigmoid");
if (!bindings::GetDictionaryMemberFromV8Object<MLSingleInputSupportLimits, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[84].Get(isolate), has_sigmoid_, member_sigmoid_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("sign");
if (!bindings::GetDictionaryMemberFromV8Object<MLSingleInputSupportLimits, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[85].Get(isolate), has_sign_, member_sign_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("sin");
if (!bindings::GetDictionaryMemberFromV8Object<MLSingleInputSupportLimits, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[86].Get(isolate), has_sin_, member_sin_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("slice");
if (!bindings::GetDictionaryMemberFromV8Object<MLSingleInputSupportLimits, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[87].Get(isolate), has_slice_, member_slice_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("softmax");
if (!bindings::GetDictionaryMemberFromV8Object<MLSingleInputSupportLimits, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[88].Get(isolate), has_softmax_, member_softmax_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("softplus");
if (!bindings::GetDictionaryMemberFromV8Object<MLSingleInputSupportLimits, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[89].Get(isolate), has_softplus_, member_softplus_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("softsign");
if (!bindings::GetDictionaryMemberFromV8Object<MLSingleInputSupportLimits, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[90].Get(isolate), has_softsign_, member_softsign_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("split");
if (!bindings::GetDictionaryMemberFromV8Object<MLSplitSupportLimits, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[91].Get(isolate), has_split_, member_split_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("sqrt");
if (!bindings::GetDictionaryMemberFromV8Object<MLSingleInputSupportLimits, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[92].Get(isolate), has_sqrt_, member_sqrt_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("sub");
if (!bindings::GetDictionaryMemberFromV8Object<MLBinarySupportLimits, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[93].Get(isolate), has_sub_, member_sub_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("tan");
if (!bindings::GetDictionaryMemberFromV8Object<MLSingleInputSupportLimits, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[94].Get(isolate), has_tan_, member_tan_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("tanh");
if (!bindings::GetDictionaryMemberFromV8Object<MLSingleInputSupportLimits, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[95].Get(isolate), has_tanh_, member_tanh_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("tile");
if (!bindings::GetDictionaryMemberFromV8Object<MLSingleInputSupportLimits, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[96].Get(isolate), has_tile_, member_tile_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("transpose");
if (!bindings::GetDictionaryMemberFromV8Object<MLSingleInputSupportLimits, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[97].Get(isolate), has_transpose_, member_transpose_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("triangular");
if (!bindings::GetDictionaryMemberFromV8Object<MLSingleInputSupportLimits, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[98].Get(isolate), has_triangular_, member_triangular_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("where");
if (!bindings::GetDictionaryMemberFromV8Object<MLWhereSupportLimits, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[99].Get(isolate), has_where_, member_where_, class_like_name, exception_state)) {
  return;
}
}

const base::span<const v8::Eternal<v8::Name>> MLOpSupportLimits::GetV8OwnMemberNames(v8::Isolate* isolate) {
  return V8PerIsolateData::From(isolate)->FindOrCreateEternalNameCache(kOwnPropertyNames, kOwnPropertyNames);
}


}  // namespace blink
