// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#include "third_party/blink/renderer/bindings/modules/v8/v8_ml_lstm_cell_support_limits.h"

#include "third_party/blink/renderer/bindings/core/v8/generated_code_helper.h"
#include "third_party/blink/renderer/bindings/core/v8/native_value_traits_impl.h"
#include "third_party/blink/renderer/bindings/core/v8/to_v8_traits.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_ml_tensor_limits.h"
#include "third_party/blink/renderer/platform/bindings/exception_messages.h"
#include "third_party/blink/renderer/platform/bindings/exception_state.h"
#include "third_party/blink/renderer/platform/bindings/v8_per_isolate_data.h"

namespace blink {



namespace  {

const std::string_view kOwnPropertyNames[] = {
"bias",
"cellState",
"hiddenState",
"input",
"output0",
"output1",
"peepholeWeight",
"recurrentBias",
"recurrentWeight",
"weight",
};


}  // namespace 

MLLstmCellSupportLimits* MLLstmCellSupportLimits::Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state) {
  MLLstmCellSupportLimits* dictionary = MakeGarbageCollected<MLLstmCellSupportLimits>(isolate);
if (v8_value->IsNullOrUndefined()) {
  return dictionary;
}
if (!v8_value->IsObject()) {
  const char* const class_like_name = "MLLstmCellSupportLimits";
exception_state.ThrowTypeError(ExceptionMessages::ValueNotOfType(class_like_name));
return nullptr;
}
dictionary->FillMembersFromV8Object(isolate, v8_value.As<v8::Object>(), exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return nullptr;
}
return dictionary;
}

 MLLstmCellSupportLimits::MLLstmCellSupportLimits() {
  
}

 MLLstmCellSupportLimits::MLLstmCellSupportLimits(v8::Isolate* isolate) {
  
}









































































void MLLstmCellSupportLimits::Trace(Visitor* visitor) const {
  visitor->Trace(member_bias_);
visitor->Trace(member_cell_state_);
visitor->Trace(member_hidden_state_);
visitor->Trace(member_input_);
visitor->Trace(member_output_0_);
visitor->Trace(member_output_1_);
visitor->Trace(member_peephole_weight_);
visitor->Trace(member_recurrent_bias_);
visitor->Trace(member_recurrent_weight_);
visitor->Trace(member_weight_);
bindings::DictionaryBase::Trace(visitor);
}

void MLLstmCellSupportLimits::FillTemplateProperties(Vector<std::string_view>& properties) const {
  static_assert(std::size(kOwnPropertyNames) == kOwnPropertyCount);
properties.AppendRange(std::cbegin(kOwnPropertyNames), std::cend(kOwnPropertyNames));
DCHECK_EQ(properties.size(), kTotalPropertyCount);
}

void MLLstmCellSupportLimits::FillValuesImpl(ScriptState* script_state, base::span<v8::MaybeLocal<v8::Value>> values) const {
  CHECK_EQ(kOwnPropertyCount, values.size());
if (hasBias()) {
  values[0] = ToV8Traits<MLTensorLimits>::ToV8(script_state, member_bias_.Get());
DCHECK(!values[0].IsEmpty());
}
if (hasCellState()) {
  values[1] = ToV8Traits<MLTensorLimits>::ToV8(script_state, member_cell_state_.Get());
DCHECK(!values[1].IsEmpty());
}
if (hasHiddenState()) {
  values[2] = ToV8Traits<MLTensorLimits>::ToV8(script_state, member_hidden_state_.Get());
DCHECK(!values[2].IsEmpty());
}
if (hasInput()) {
  values[3] = ToV8Traits<MLTensorLimits>::ToV8(script_state, member_input_.Get());
DCHECK(!values[3].IsEmpty());
}
if (hasOutput0()) {
  values[4] = ToV8Traits<MLTensorLimits>::ToV8(script_state, member_output_0_.Get());
DCHECK(!values[4].IsEmpty());
}
if (hasOutput1()) {
  values[5] = ToV8Traits<MLTensorLimits>::ToV8(script_state, member_output_1_.Get());
DCHECK(!values[5].IsEmpty());
}
if (hasPeepholeWeight()) {
  values[6] = ToV8Traits<MLTensorLimits>::ToV8(script_state, member_peephole_weight_.Get());
DCHECK(!values[6].IsEmpty());
}
if (hasRecurrentBias()) {
  values[7] = ToV8Traits<MLTensorLimits>::ToV8(script_state, member_recurrent_bias_.Get());
DCHECK(!values[7].IsEmpty());
}
if (hasRecurrentWeight()) {
  values[8] = ToV8Traits<MLTensorLimits>::ToV8(script_state, member_recurrent_weight_.Get());
DCHECK(!values[8].IsEmpty());
}
if (hasWeight()) {
  values[9] = ToV8Traits<MLTensorLimits>::ToV8(script_state, member_weight_.Get());
DCHECK(!values[9].IsEmpty());
}
}

const void* MLLstmCellSupportLimits::TemplateKey() const {
  static const void *s_key = &s_key;
return s_key;
}

v8::Local<v8::Object> MLLstmCellSupportLimits::FillValues(ScriptState* script_state, v8::Local<v8::DictionaryTemplate> dict_template) const {
  v8::MaybeLocal<v8::Value> values[kTotalPropertyCount];
FillValuesImpl(script_state, values);
return dict_template->NewInstance(script_state->GetContext(), values);
}

void MLLstmCellSupportLimits::FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state) {
  TryRethrowScope rethrow_scope(isolate, exception_state);
const char* const class_like_name = "MLLstmCellSupportLimits";
DictionaryConversionContext dictionary_from_v8_context(isolate, class_like_name);
dictionary_from_v8_context.SetCurrentPropertyName("bias");
constexpr bool is_optional = false;
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
const auto& v8_own_member_names = GetV8OwnMemberNames(isolate);
if (!bindings::GetDictionaryMemberFromV8Object<MLTensorLimits, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[0].Get(isolate), has_bias_, member_bias_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("cellState");
if (!bindings::GetDictionaryMemberFromV8Object<MLTensorLimits, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[1].Get(isolate), has_cell_state_, member_cell_state_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("hiddenState");
if (!bindings::GetDictionaryMemberFromV8Object<MLTensorLimits, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[2].Get(isolate), has_hidden_state_, member_hidden_state_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("input");
if (!bindings::GetDictionaryMemberFromV8Object<MLTensorLimits, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[3].Get(isolate), has_input_, member_input_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("output0");
if (!bindings::GetDictionaryMemberFromV8Object<MLTensorLimits, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[4].Get(isolate), has_output_0_, member_output_0_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("output1");
if (!bindings::GetDictionaryMemberFromV8Object<MLTensorLimits, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[5].Get(isolate), has_output_1_, member_output_1_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("peepholeWeight");
if (!bindings::GetDictionaryMemberFromV8Object<MLTensorLimits, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[6].Get(isolate), has_peephole_weight_, member_peephole_weight_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("recurrentBias");
if (!bindings::GetDictionaryMemberFromV8Object<MLTensorLimits, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[7].Get(isolate), has_recurrent_bias_, member_recurrent_bias_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("recurrentWeight");
if (!bindings::GetDictionaryMemberFromV8Object<MLTensorLimits, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[8].Get(isolate), has_recurrent_weight_, member_recurrent_weight_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("weight");
if (!bindings::GetDictionaryMemberFromV8Object<MLTensorLimits, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[9].Get(isolate), has_weight_, member_weight_, class_like_name, exception_state)) {
  return;
}
}

const base::span<const v8::Eternal<v8::Name>> MLLstmCellSupportLimits::GetV8OwnMemberNames(v8::Isolate* isolate) {
  return V8PerIsolateData::From(isolate)->FindOrCreateEternalNameCache(kOwnPropertyNames, kOwnPropertyNames);
}


}  // namespace blink
