// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_ML_GRU_SUPPORT_LIMITS_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_ML_GRU_SUPPORT_LIMITS_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"
#include "third_party/blink/renderer/platform/heap/member.h"

namespace blink {

class ExceptionState;
class MLTensorLimits;

class MODULES_EXPORT MLGruSupportLimits : public bindings::DictionaryBase {
  
  public:
static MLGruSupportLimits* Create() {
  return MakeGarbageCollected<MLGruSupportLimits>();
}
static MLGruSupportLimits* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<MLGruSupportLimits>(isolate);
}
static MLGruSupportLimits* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  MLGruSupportLimits();
explicit  MLGruSupportLimits(v8::Isolate* isolate);

bool hasBias() const {
  return has_bias_;
}
MLTensorLimits* bias() const {
  DCHECK(hasBias());
return member_bias_.Get();
}
MLTensorLimits* getBiasOr(MLTensorLimits* fallback_value) const {
  if (!hasBias()) {
  return fallback_value;
}
return member_bias_.Get();
}
void setBias(MLTensorLimits* value) {
  member_bias_ = value;
has_bias_ = true;
DCHECK(member_bias_);
}

bool hasInitialHiddenState() const {
  return has_initial_hidden_state_;
}
MLTensorLimits* initialHiddenState() const {
  DCHECK(hasInitialHiddenState());
return member_initial_hidden_state_.Get();
}
MLTensorLimits* getInitialHiddenStateOr(MLTensorLimits* fallback_value) const {
  if (!hasInitialHiddenState()) {
  return fallback_value;
}
return member_initial_hidden_state_.Get();
}
void setInitialHiddenState(MLTensorLimits* value) {
  member_initial_hidden_state_ = value;
has_initial_hidden_state_ = true;
DCHECK(member_initial_hidden_state_);
}

bool hasInput() const {
  return has_input_;
}
MLTensorLimits* input() const {
  DCHECK(hasInput());
return member_input_.Get();
}
MLTensorLimits* getInputOr(MLTensorLimits* fallback_value) const {
  if (!hasInput()) {
  return fallback_value;
}
return member_input_.Get();
}
void setInput(MLTensorLimits* value) {
  member_input_ = value;
has_input_ = true;
DCHECK(member_input_);
}

bool hasOutput0() const {
  return has_output_0_;
}
MLTensorLimits* output0() const {
  DCHECK(hasOutput0());
return member_output_0_.Get();
}
MLTensorLimits* getOutput0Or(MLTensorLimits* fallback_value) const {
  if (!hasOutput0()) {
  return fallback_value;
}
return member_output_0_.Get();
}
void setOutput0(MLTensorLimits* value) {
  member_output_0_ = value;
has_output_0_ = true;
DCHECK(member_output_0_);
}

bool hasOutput1() const {
  return has_output_1_;
}
MLTensorLimits* output1() const {
  DCHECK(hasOutput1());
return member_output_1_.Get();
}
MLTensorLimits* getOutput1Or(MLTensorLimits* fallback_value) const {
  if (!hasOutput1()) {
  return fallback_value;
}
return member_output_1_.Get();
}
void setOutput1(MLTensorLimits* value) {
  member_output_1_ = value;
has_output_1_ = true;
DCHECK(member_output_1_);
}

bool hasRecurrentBias() const {
  return has_recurrent_bias_;
}
MLTensorLimits* recurrentBias() const {
  DCHECK(hasRecurrentBias());
return member_recurrent_bias_.Get();
}
MLTensorLimits* getRecurrentBiasOr(MLTensorLimits* fallback_value) const {
  if (!hasRecurrentBias()) {
  return fallback_value;
}
return member_recurrent_bias_.Get();
}
void setRecurrentBias(MLTensorLimits* value) {
  member_recurrent_bias_ = value;
has_recurrent_bias_ = true;
DCHECK(member_recurrent_bias_);
}

bool hasRecurrentWeight() const {
  return has_recurrent_weight_;
}
MLTensorLimits* recurrentWeight() const {
  DCHECK(hasRecurrentWeight());
return member_recurrent_weight_.Get();
}
MLTensorLimits* getRecurrentWeightOr(MLTensorLimits* fallback_value) const {
  if (!hasRecurrentWeight()) {
  return fallback_value;
}
return member_recurrent_weight_.Get();
}
void setRecurrentWeight(MLTensorLimits* value) {
  member_recurrent_weight_ = value;
has_recurrent_weight_ = true;
DCHECK(member_recurrent_weight_);
}

bool hasWeight() const {
  return has_weight_;
}
MLTensorLimits* weight() const {
  DCHECK(hasWeight());
return member_weight_.Get();
}
MLTensorLimits* getWeightOr(MLTensorLimits* fallback_value) const {
  if (!hasWeight()) {
  return fallback_value;
}
return member_weight_.Get();
}
void setWeight(MLTensorLimits* value) {
  member_weight_ = value;
has_weight_ = true;
DCHECK(member_weight_);
}




void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 8;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillTemplateProperties(Vector<std::string_view>& properties) const override;
void FillValuesImpl(ScriptState* script_state, base::span<v8::MaybeLocal<v8::Value>> values) const;


void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
const void* TemplateKey() const override;
v8::Local<v8::Object> FillValues(ScriptState* script_state, v8::Local<v8::DictionaryTemplate> dict_template) const override;
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_bias_ = false;
bool has_initial_hidden_state_ = false;
bool has_input_ = false;
bool has_output_0_ = false;
bool has_output_1_ = false;
bool has_recurrent_bias_ = false;
bool has_recurrent_weight_ = false;
bool has_weight_ = false;

Member<MLTensorLimits> member_bias_;
Member<MLTensorLimits> member_initial_hidden_state_;
Member<MLTensorLimits> member_input_;
Member<MLTensorLimits> member_output_0_;
Member<MLTensorLimits> member_output_1_;
Member<MLTensorLimits> member_recurrent_bias_;
Member<MLTensorLimits> member_recurrent_weight_;
Member<MLTensorLimits> member_weight_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_ML_GRU_SUPPORT_LIMITS_H_
