// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_ML_GRU_CELL_SUPPORT_LIMITS_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_ML_GRU_CELL_SUPPORT_LIMITS_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"
#include "third_party/blink/renderer/platform/heap/member.h"

namespace blink {

class ExceptionState;
class MLTensorLimits;

class MODULES_EXPORT MLGruCellSupportLimits : public bindings::DictionaryBase {
  
  public:
static MLGruCellSupportLimits* Create() {
  return MakeGarbageCollected<MLGruCellSupportLimits>();
}
static MLGruCellSupportLimits* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<MLGruCellSupportLimits>(isolate);
}
static MLGruCellSupportLimits* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  MLGruCellSupportLimits();
explicit  MLGruCellSupportLimits(v8::Isolate* isolate);

bool hasBias() const {
  return has_bias_;
}
MLTensorLimits* bias() const {
  DCHECK(hasBias());
return member_bias_.Get();
}
MLTensorLimits* getBiasOr(MLTensorLimits* fallback_value) const {
  if (!hasBias()) {
  return fallback_value;
}
return member_bias_.Get();
}
void setBias(MLTensorLimits* value) {
  member_bias_ = value;
has_bias_ = true;
DCHECK(member_bias_);
}

bool hasHiddenState() const {
  return has_hidden_state_;
}
MLTensorLimits* hiddenState() const {
  DCHECK(hasHiddenState());
return member_hidden_state_.Get();
}
MLTensorLimits* getHiddenStateOr(MLTensorLimits* fallback_value) const {
  if (!hasHiddenState()) {
  return fallback_value;
}
return member_hidden_state_.Get();
}
void setHiddenState(MLTensorLimits* value) {
  member_hidden_state_ = value;
has_hidden_state_ = true;
DCHECK(member_hidden_state_);
}

bool hasInput() const {
  return has_input_;
}
MLTensorLimits* input() const {
  DCHECK(hasInput());
return member_input_.Get();
}
MLTensorLimits* getInputOr(MLTensorLimits* fallback_value) const {
  if (!hasInput()) {
  return fallback_value;
}
return member_input_.Get();
}
void setInput(MLTensorLimits* value) {
  member_input_ = value;
has_input_ = true;
DCHECK(member_input_);
}

bool hasOutput() const {
  return has_output_;
}
MLTensorLimits* output() const {
  DCHECK(hasOutput());
return member_output_.Get();
}
MLTensorLimits* getOutputOr(MLTensorLimits* fallback_value) const {
  if (!hasOutput()) {
  return fallback_value;
}
return member_output_.Get();
}
void setOutput(MLTensorLimits* value) {
  member_output_ = value;
has_output_ = true;
DCHECK(member_output_);
}

bool hasRecurrentBias() const {
  return has_recurrent_bias_;
}
MLTensorLimits* recurrentBias() const {
  DCHECK(hasRecurrentBias());
return member_recurrent_bias_.Get();
}
MLTensorLimits* getRecurrentBiasOr(MLTensorLimits* fallback_value) const {
  if (!hasRecurrentBias()) {
  return fallback_value;
}
return member_recurrent_bias_.Get();
}
void setRecurrentBias(MLTensorLimits* value) {
  member_recurrent_bias_ = value;
has_recurrent_bias_ = true;
DCHECK(member_recurrent_bias_);
}

bool hasRecurrentWeight() const {
  return has_recurrent_weight_;
}
MLTensorLimits* recurrentWeight() const {
  DCHECK(hasRecurrentWeight());
return member_recurrent_weight_.Get();
}
MLTensorLimits* getRecurrentWeightOr(MLTensorLimits* fallback_value) const {
  if (!hasRecurrentWeight()) {
  return fallback_value;
}
return member_recurrent_weight_.Get();
}
void setRecurrentWeight(MLTensorLimits* value) {
  member_recurrent_weight_ = value;
has_recurrent_weight_ = true;
DCHECK(member_recurrent_weight_);
}

bool hasWeight() const {
  return has_weight_;
}
MLTensorLimits* weight() const {
  DCHECK(hasWeight());
return member_weight_.Get();
}
MLTensorLimits* getWeightOr(MLTensorLimits* fallback_value) const {
  if (!hasWeight()) {
  return fallback_value;
}
return member_weight_.Get();
}
void setWeight(MLTensorLimits* value) {
  member_weight_ = value;
has_weight_ = true;
DCHECK(member_weight_);
}




void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 7;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillTemplateProperties(Vector<std::string_view>& properties) const override;
void FillValuesImpl(ScriptState* script_state, base::span<v8::MaybeLocal<v8::Value>> values) const;


void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
const void* TemplateKey() const override;
v8::Local<v8::Object> FillValues(ScriptState* script_state, v8::Local<v8::DictionaryTemplate> dict_template) const override;
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_bias_ = false;
bool has_hidden_state_ = false;
bool has_input_ = false;
bool has_output_ = false;
bool has_recurrent_bias_ = false;
bool has_recurrent_weight_ = false;
bool has_weight_ = false;

Member<MLTensorLimits> member_bias_;
Member<MLTensorLimits> member_hidden_state_;
Member<MLTensorLimits> member_input_;
Member<MLTensorLimits> member_output_;
Member<MLTensorLimits> member_recurrent_bias_;
Member<MLTensorLimits> member_recurrent_weight_;
Member<MLTensorLimits> member_weight_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_ML_GRU_CELL_SUPPORT_LIMITS_H_
