// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_ML_GRU_CELL_OPTIONS_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_ML_GRU_CELL_OPTIONS_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_ml_gru_weight_layout.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_ml_operator_options.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_ml_recurrent_network_activation.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/heap/collection_support/heap_vector.h"
#include "third_party/blink/renderer/platform/heap/member.h"

namespace blink {

class ExceptionState;
class MLOperand;

class MODULES_EXPORT MLGruCellOptions : public MLOperatorOptions {
  
  public:
static MLGruCellOptions* Create() {
  return MakeGarbageCollected<MLGruCellOptions>();
}
static MLGruCellOptions* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<MLGruCellOptions>(isolate);
}
static MLGruCellOptions* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  MLGruCellOptions();
explicit  MLGruCellOptions(v8::Isolate* isolate);

bool hasActivations() const {
  return has_activations_;
}
const Vector<V8MLRecurrentNetworkActivation>& activations() const {
  DCHECK(hasActivations());
return member_activations_;
}
Vector<V8MLRecurrentNetworkActivation> getActivationsOr(const Vector<V8MLRecurrentNetworkActivation>& fallback_value) const;
Vector<V8MLRecurrentNetworkActivation> getActivationsOr(Vector<V8MLRecurrentNetworkActivation>&& fallback_value) const;
void setActivations(const Vector<V8MLRecurrentNetworkActivation>& value);
void setActivations(Vector<V8MLRecurrentNetworkActivation>&& value);

bool hasBias() const {
  return has_bias_;
}
MLOperand* bias() const {
  DCHECK(hasBias());
return member_bias_.Get();
}
MLOperand* getBiasOr(MLOperand* fallback_value) const {
  if (!hasBias()) {
  return fallback_value;
}
return member_bias_.Get();
}
void setBias(MLOperand* value) {
  member_bias_ = value;
has_bias_ = true;
DCHECK(member_bias_);
}

bool hasLayout() const {
  return true;
}
V8MLGruWeightLayout layout() const {
  return member_layout_;
}
void setLayout(V8MLGruWeightLayout value) {
  member_layout_ = value;
}
void setLayout(V8MLGruWeightLayout::Enum value) {
  member_layout_ = V8MLGruWeightLayout(value);
}

bool hasRecurrentBias() const {
  return has_recurrent_bias_;
}
MLOperand* recurrentBias() const {
  DCHECK(hasRecurrentBias());
return member_recurrent_bias_.Get();
}
MLOperand* getRecurrentBiasOr(MLOperand* fallback_value) const {
  if (!hasRecurrentBias()) {
  return fallback_value;
}
return member_recurrent_bias_.Get();
}
void setRecurrentBias(MLOperand* value) {
  member_recurrent_bias_ = value;
has_recurrent_bias_ = true;
DCHECK(member_recurrent_bias_);
}

bool hasResetAfter() const {
  return true;
}
bool resetAfter() const {
  return member_reset_after_;
}
void setResetAfter(bool value) {
  member_reset_after_ = value;
}




void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = MLOperatorOptions::kTotalPropertyCount;
static constexpr size_t kOwnPropertyCount = 5;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_activations_ = false;
bool has_bias_ = false;
bool has_recurrent_bias_ = false;

Vector<V8MLRecurrentNetworkActivation> member_activations_;
Member<MLOperand> member_bias_;
V8MLGruWeightLayout member_layout_{V8MLGruWeightLayout::Enum::kZrn};
Member<MLOperand> member_recurrent_bias_;
bool member_reset_after_{true};


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_ML_GRU_CELL_OPTIONS_H_
