// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_ML_CONV_2D_OPTIONS_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_ML_CONV_2D_OPTIONS_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_ml_conv_2d_filter_operand_layout.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_ml_input_operand_layout.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_ml_operator_options.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/heap/collection_support/heap_vector.h"
#include "third_party/blink/renderer/platform/heap/member.h"

namespace blink {

class ExceptionState;
class MLOperand;

class MODULES_EXPORT MLConv2dOptions : public MLOperatorOptions {
  
  public:
static MLConv2dOptions* Create() {
  return MakeGarbageCollected<MLConv2dOptions>();
}
static MLConv2dOptions* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<MLConv2dOptions>(isolate);
}
static MLConv2dOptions* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  MLConv2dOptions();
explicit  MLConv2dOptions(v8::Isolate* isolate);

bool hasBias() const {
  return has_bias_;
}
MLOperand* bias() const {
  DCHECK(hasBias());
return member_bias_.Get();
}
MLOperand* getBiasOr(MLOperand* fallback_value) const {
  if (!hasBias()) {
  return fallback_value;
}
return member_bias_.Get();
}
void setBias(MLOperand* value) {
  member_bias_ = value;
has_bias_ = true;
DCHECK(member_bias_);
}

bool hasDilations() const {
  return has_dilations_;
}
const Vector<uint32_t>& dilations() const {
  DCHECK(hasDilations());
return member_dilations_;
}
Vector<uint32_t> getDilationsOr(const Vector<uint32_t>& fallback_value) const;
Vector<uint32_t> getDilationsOr(Vector<uint32_t>&& fallback_value) const;
void setDilations(const Vector<uint32_t>& value);
void setDilations(Vector<uint32_t>&& value);

bool hasFilterLayout() const {
  return true;
}
V8MLConv2dFilterOperandLayout filterLayout() const {
  return member_filter_layout_;
}
void setFilterLayout(V8MLConv2dFilterOperandLayout value) {
  member_filter_layout_ = value;
}
void setFilterLayout(V8MLConv2dFilterOperandLayout::Enum value) {
  member_filter_layout_ = V8MLConv2dFilterOperandLayout(value);
}

bool hasGroups() const {
  return true;
}
uint32_t groups() const {
  return member_groups_;
}
void setGroups(uint32_t value) {
  member_groups_ = value;
}

bool hasInputLayout() const {
  return true;
}
V8MLInputOperandLayout inputLayout() const {
  return member_input_layout_;
}
void setInputLayout(V8MLInputOperandLayout value) {
  member_input_layout_ = value;
}
void setInputLayout(V8MLInputOperandLayout::Enum value) {
  member_input_layout_ = V8MLInputOperandLayout(value);
}

bool hasPadding() const {
  return has_padding_;
}
const Vector<uint32_t>& padding() const {
  DCHECK(hasPadding());
return member_padding_;
}
Vector<uint32_t> getPaddingOr(const Vector<uint32_t>& fallback_value) const;
Vector<uint32_t> getPaddingOr(Vector<uint32_t>&& fallback_value) const;
void setPadding(const Vector<uint32_t>& value);
void setPadding(Vector<uint32_t>&& value);

bool hasStrides() const {
  return has_strides_;
}
const Vector<uint32_t>& strides() const {
  DCHECK(hasStrides());
return member_strides_;
}
Vector<uint32_t> getStridesOr(const Vector<uint32_t>& fallback_value) const;
Vector<uint32_t> getStridesOr(Vector<uint32_t>&& fallback_value) const;
void setStrides(const Vector<uint32_t>& value);
void setStrides(Vector<uint32_t>&& value);




void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = MLOperatorOptions::kTotalPropertyCount;
static constexpr size_t kOwnPropertyCount = 7;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_bias_ = false;
bool has_dilations_ = false;
bool has_padding_ = false;
bool has_strides_ = false;

Member<MLOperand> member_bias_;
Vector<uint32_t> member_dilations_;
V8MLConv2dFilterOperandLayout member_filter_layout_{V8MLConv2dFilterOperandLayout::Enum::kOihw};
uint32_t member_groups_{1};
V8MLInputOperandLayout member_input_layout_{V8MLInputOperandLayout::Enum::kNchw};
Vector<uint32_t> member_padding_;
Vector<uint32_t> member_strides_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_ML_CONV_2D_OPTIONS_H_
