// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_ML_CONTEXT_OPTIONS_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_ML_CONTEXT_OPTIONS_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_ml_device_type.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_ml_power_preference.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"

namespace blink {

class ExceptionState;

class MODULES_EXPORT MLContextOptions : public bindings::InputDictionaryBase {
  
  public:
static MLContextOptions* Create() {
  return MakeGarbageCollected<MLContextOptions>();
}
static MLContextOptions* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<MLContextOptions>(isolate);
}
static MLContextOptions* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  MLContextOptions();
explicit  MLContextOptions(v8::Isolate* isolate);

bool hasDeviceType() const {
  return true;
}
V8MLDeviceType deviceType() const {
  return member_device_type_;
}
void setDeviceType(V8MLDeviceType value) {
  member_device_type_ = value;
}
void setDeviceType(V8MLDeviceType::Enum value) {
  member_device_type_ = V8MLDeviceType(value);
}

bool hasPowerPreference() const {
  return true;
}
V8MLPowerPreference powerPreference() const {
  return member_power_preference_;
}
void setPowerPreference(V8MLPowerPreference value) {
  member_power_preference_ = value;
}
void setPowerPreference(V8MLPowerPreference::Enum value) {
  member_power_preference_ = V8MLPowerPreference(value);
}




void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 2;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);



V8MLDeviceType member_device_type_{V8MLDeviceType::Enum::kCpu};
V8MLPowerPreference member_power_preference_{V8MLPowerPreference::Enum::kDefault};


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_ML_CONTEXT_OPTIONS_H_
