// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_MIDI_OPTIONS_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_MIDI_OPTIONS_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"

namespace blink {

class ExceptionState;

class MODULES_EXPORT MIDIOptions : public bindings::InputDictionaryBase {
  
  public:
static MIDIOptions* Create() {
  return MakeGarbageCollected<MIDIOptions>();
}
static MIDIOptions* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<MIDIOptions>(isolate);
}
static MIDIOptions* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  MIDIOptions();
explicit  MIDIOptions(v8::Isolate* isolate);

bool hasSysex() const {
  return has_sysex_;
}
bool sysex() const {
  DCHECK(hasSysex());
return member_sysex_;
}
bool getSysexOr(bool fallback_value) const {
  if (!hasSysex()) {
  return fallback_value;
}
return member_sysex_;
}
void setSysex(bool value) {
  member_sysex_ = value;
has_sysex_ = true;
}




void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 1;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_sysex_ = false;

bool member_sysex_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_MIDI_OPTIONS_H_
