// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#include "third_party/blink/renderer/bindings/modules/v8/v8_media_track_supported_constraints.h"

#include "third_party/blink/renderer/bindings/core/v8/generated_code_helper.h"
#include "third_party/blink/renderer/bindings/core/v8/native_value_traits_impl.h"
#include "third_party/blink/renderer/bindings/core/v8/to_v8_traits.h"
#include "third_party/blink/renderer/core/execution_context/execution_context.h"
#include "third_party/blink/renderer/platform/bindings/exception_messages.h"
#include "third_party/blink/renderer/platform/bindings/exception_state.h"
#include "third_party/blink/renderer/platform/bindings/v8_per_isolate_data.h"
#include "third_party/blink/renderer/platform/runtime_enabled_features.h"

namespace blink {



namespace  {

const std::string_view kOwnPropertyNames[] = {
"aspectRatio",
"autoGainControl",
"backgroundBlur",
"backgroundSegmentationMask",
"brightness",
"channelCount",
"colorTemperature",
"contrast",
"deviceId",
"displaySurface",
"echoCancellation",
"exposureCompensation",
"exposureMode",
"exposureTime",
"eyeGazeCorrection",
"faceFraming",
"facingMode",
"focusDistance",
"focusMode",
"frameRate",
"groupId",
"height",
"iso",
"latency",
"noiseSuppression",
"pan",
"pointsOfInterest",
"resizeMode",
"restrictOwnAudio",
"sampleRate",
"sampleSize",
"saturation",
"sharpness",
"suppressLocalAudioPlayback",
"tilt",
"torch",
"voiceIsolation",
"whiteBalanceMode",
"width",
"zoom",
};


}  // namespace 

MediaTrackSupportedConstraints* MediaTrackSupportedConstraints::Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state) {
  MediaTrackSupportedConstraints* dictionary = MakeGarbageCollected<MediaTrackSupportedConstraints>(isolate);
if (v8_value->IsNullOrUndefined()) {
  return dictionary;
}
if (!v8_value->IsObject()) {
  const char* const class_like_name = "MediaTrackSupportedConstraints";
exception_state.ThrowTypeError(ExceptionMessages::ValueNotOfType(class_like_name));
return nullptr;
}
dictionary->FillMembersFromV8Object(isolate, v8_value.As<v8::Object>(), exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return nullptr;
}
return dictionary;
}

 MediaTrackSupportedConstraints::MediaTrackSupportedConstraints() {
  
}

 MediaTrackSupportedConstraints::MediaTrackSupportedConstraints(v8::Isolate* isolate) {
  
}











































































































































































































void MediaTrackSupportedConstraints::Trace(Visitor* visitor) const {
  bindings::DictionaryBase::Trace(visitor);
}

void MediaTrackSupportedConstraints::FillTemplateProperties(Vector<std::string_view>& properties) const {
  static_assert(std::size(kOwnPropertyNames) == kOwnPropertyCount);
properties.AppendRange(std::cbegin(kOwnPropertyNames), std::cend(kOwnPropertyNames));
DCHECK_EQ(properties.size(), kTotalPropertyCount);
}

void MediaTrackSupportedConstraints::FillValuesImpl(ScriptState* script_state, base::span<v8::MaybeLocal<v8::Value>> values) const {
  CHECK_EQ(kOwnPropertyCount, values.size());
if (hasAspectRatio()) {
  values[0] = ToV8Traits<IDLBoolean>::ToV8(script_state, member_aspect_ratio_);
DCHECK(!values[0].IsEmpty());
}
if (hasAutoGainControl()) {
  values[1] = ToV8Traits<IDLBoolean>::ToV8(script_state, member_auto_gain_control_);
DCHECK(!values[1].IsEmpty());
}
v8::Isolate* isolate = script_state->GetIsolate();
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
ExecutionContext* execution_context = ExecutionContext::From(current_context);
if (RuntimeEnabledFeatures::MediaCaptureBackgroundBlurEnabled(execution_context)) {
  if (hasBackgroundBlur()) {
  values[2] = ToV8Traits<IDLBoolean>::ToV8(script_state, member_background_blur_);
DCHECK(!values[2].IsEmpty());
}
}
if (RuntimeEnabledFeatures::MediaCaptureCameraControlsEnabled()) {
  if (hasBackgroundSegmentationMask()) {
  values[3] = ToV8Traits<IDLBoolean>::ToV8(script_state, member_background_segmentation_mask_);
DCHECK(!values[3].IsEmpty());
}
}
if (hasBrightness()) {
  values[4] = ToV8Traits<IDLBoolean>::ToV8(script_state, member_brightness_);
DCHECK(!values[4].IsEmpty());
}
if (hasChannelCount()) {
  values[5] = ToV8Traits<IDLBoolean>::ToV8(script_state, member_channel_count_);
DCHECK(!values[5].IsEmpty());
}
if (hasColorTemperature()) {
  values[6] = ToV8Traits<IDLBoolean>::ToV8(script_state, member_color_temperature_);
DCHECK(!values[6].IsEmpty());
}
if (hasContrast()) {
  values[7] = ToV8Traits<IDLBoolean>::ToV8(script_state, member_contrast_);
DCHECK(!values[7].IsEmpty());
}
if (hasDeviceId()) {
  values[8] = ToV8Traits<IDLBoolean>::ToV8(script_state, member_device_id_);
DCHECK(!values[8].IsEmpty());
}
if (hasDisplaySurface()) {
  values[9] = ToV8Traits<IDLBoolean>::ToV8(script_state, member_display_surface_);
DCHECK(!values[9].IsEmpty());
}
if (hasEchoCancellation()) {
  values[10] = ToV8Traits<IDLBoolean>::ToV8(script_state, member_echo_cancellation_);
DCHECK(!values[10].IsEmpty());
}
if (hasExposureCompensation()) {
  values[11] = ToV8Traits<IDLBoolean>::ToV8(script_state, member_exposure_compensation_);
DCHECK(!values[11].IsEmpty());
}
if (hasExposureMode()) {
  values[12] = ToV8Traits<IDLBoolean>::ToV8(script_state, member_exposure_mode_);
DCHECK(!values[12].IsEmpty());
}
if (hasExposureTime()) {
  values[13] = ToV8Traits<IDLBoolean>::ToV8(script_state, member_exposure_time_);
DCHECK(!values[13].IsEmpty());
}
if (RuntimeEnabledFeatures::MediaCaptureCameraControlsEnabled()) {
  if (hasEyeGazeCorrection()) {
  values[14] = ToV8Traits<IDLBoolean>::ToV8(script_state, member_eye_gaze_correction_);
DCHECK(!values[14].IsEmpty());
}
}
if (RuntimeEnabledFeatures::MediaCaptureCameraControlsEnabled()) {
  if (hasFaceFraming()) {
  values[15] = ToV8Traits<IDLBoolean>::ToV8(script_state, member_face_framing_);
DCHECK(!values[15].IsEmpty());
}
}
if (hasFacingMode()) {
  values[16] = ToV8Traits<IDLBoolean>::ToV8(script_state, member_facing_mode_);
DCHECK(!values[16].IsEmpty());
}
if (hasFocusDistance()) {
  values[17] = ToV8Traits<IDLBoolean>::ToV8(script_state, member_focus_distance_);
DCHECK(!values[17].IsEmpty());
}
if (hasFocusMode()) {
  values[18] = ToV8Traits<IDLBoolean>::ToV8(script_state, member_focus_mode_);
DCHECK(!values[18].IsEmpty());
}
if (hasFrameRate()) {
  values[19] = ToV8Traits<IDLBoolean>::ToV8(script_state, member_frame_rate_);
DCHECK(!values[19].IsEmpty());
}
if (hasGroupId()) {
  values[20] = ToV8Traits<IDLBoolean>::ToV8(script_state, member_group_id_);
DCHECK(!values[20].IsEmpty());
}
if (hasHeight()) {
  values[21] = ToV8Traits<IDLBoolean>::ToV8(script_state, member_height_);
DCHECK(!values[21].IsEmpty());
}
if (hasIso()) {
  values[22] = ToV8Traits<IDLBoolean>::ToV8(script_state, member_iso_);
DCHECK(!values[22].IsEmpty());
}
if (hasLatency()) {
  values[23] = ToV8Traits<IDLBoolean>::ToV8(script_state, member_latency_);
DCHECK(!values[23].IsEmpty());
}
if (hasNoiseSuppression()) {
  values[24] = ToV8Traits<IDLBoolean>::ToV8(script_state, member_noise_suppression_);
DCHECK(!values[24].IsEmpty());
}
if (hasPan()) {
  values[25] = ToV8Traits<IDLBoolean>::ToV8(script_state, member_pan_);
DCHECK(!values[25].IsEmpty());
}
if (hasPointsOfInterest()) {
  values[26] = ToV8Traits<IDLBoolean>::ToV8(script_state, member_points_of_interest_);
DCHECK(!values[26].IsEmpty());
}
if (hasResizeMode()) {
  values[27] = ToV8Traits<IDLBoolean>::ToV8(script_state, member_resize_mode_);
DCHECK(!values[27].IsEmpty());
}
if (RuntimeEnabledFeatures::RestrictOwnAudioEnabled()) {
  if (hasRestrictOwnAudio()) {
  values[28] = ToV8Traits<IDLBoolean>::ToV8(script_state, member_restrict_own_audio_);
DCHECK(!values[28].IsEmpty());
}
}
if (hasSampleRate()) {
  values[29] = ToV8Traits<IDLBoolean>::ToV8(script_state, member_sample_rate_);
DCHECK(!values[29].IsEmpty());
}
if (hasSampleSize()) {
  values[30] = ToV8Traits<IDLBoolean>::ToV8(script_state, member_sample_size_);
DCHECK(!values[30].IsEmpty());
}
if (hasSaturation()) {
  values[31] = ToV8Traits<IDLBoolean>::ToV8(script_state, member_saturation_);
DCHECK(!values[31].IsEmpty());
}
if (hasSharpness()) {
  values[32] = ToV8Traits<IDLBoolean>::ToV8(script_state, member_sharpness_);
DCHECK(!values[32].IsEmpty());
}
if (hasSuppressLocalAudioPlayback()) {
  values[33] = ToV8Traits<IDLBoolean>::ToV8(script_state, member_suppress_local_audio_playback_);
DCHECK(!values[33].IsEmpty());
}
if (hasTilt()) {
  values[34] = ToV8Traits<IDLBoolean>::ToV8(script_state, member_tilt_);
DCHECK(!values[34].IsEmpty());
}
if (hasTorch()) {
  values[35] = ToV8Traits<IDLBoolean>::ToV8(script_state, member_torch_);
DCHECK(!values[35].IsEmpty());
}
if (hasVoiceIsolation()) {
  values[36] = ToV8Traits<IDLBoolean>::ToV8(script_state, member_voice_isolation_);
DCHECK(!values[36].IsEmpty());
}
if (hasWhiteBalanceMode()) {
  values[37] = ToV8Traits<IDLBoolean>::ToV8(script_state, member_white_balance_mode_);
DCHECK(!values[37].IsEmpty());
}
if (hasWidth()) {
  values[38] = ToV8Traits<IDLBoolean>::ToV8(script_state, member_width_);
DCHECK(!values[38].IsEmpty());
}
if (hasZoom()) {
  values[39] = ToV8Traits<IDLBoolean>::ToV8(script_state, member_zoom_);
DCHECK(!values[39].IsEmpty());
}
}

const void* MediaTrackSupportedConstraints::TemplateKey() const {
  static const void *s_key = &s_key;
return s_key;
}

v8::Local<v8::Object> MediaTrackSupportedConstraints::FillValues(ScriptState* script_state, v8::Local<v8::DictionaryTemplate> dict_template) const {
  v8::MaybeLocal<v8::Value> values[kTotalPropertyCount];
FillValuesImpl(script_state, values);
return dict_template->NewInstance(script_state->GetContext(), values);
}

void MediaTrackSupportedConstraints::FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state) {
  TryRethrowScope rethrow_scope(isolate, exception_state);
const char* const class_like_name = "MediaTrackSupportedConstraints";
DictionaryConversionContext dictionary_from_v8_context(isolate, class_like_name);
dictionary_from_v8_context.SetCurrentPropertyName("aspectRatio");
constexpr bool is_optional = false;
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
const auto& v8_own_member_names = GetV8OwnMemberNames(isolate);
bool fallback_presence_var;
if (!bindings::GetDictionaryMemberFromV8Object<IDLBoolean, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[0].Get(isolate), fallback_presence_var, member_aspect_ratio_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("autoGainControl");
if (!bindings::GetDictionaryMemberFromV8Object<IDLBoolean, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[1].Get(isolate), fallback_presence_var, member_auto_gain_control_, class_like_name, exception_state)) {
  return;
}
ExecutionContext* execution_context = ExecutionContext::From(current_context);
if (RuntimeEnabledFeatures::MediaCaptureBackgroundBlurEnabled(execution_context)) {
  dictionary_from_v8_context.SetCurrentPropertyName("backgroundBlur");
if (!bindings::GetDictionaryMemberFromV8Object<IDLBoolean, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[2].Get(isolate), fallback_presence_var, member_background_blur_, class_like_name, exception_state)) {
  return;
}
}
if (RuntimeEnabledFeatures::MediaCaptureCameraControlsEnabled()) {
  dictionary_from_v8_context.SetCurrentPropertyName("backgroundSegmentationMask");
if (!bindings::GetDictionaryMemberFromV8Object<IDLBoolean, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[3].Get(isolate), fallback_presence_var, member_background_segmentation_mask_, class_like_name, exception_state)) {
  return;
}
}
dictionary_from_v8_context.SetCurrentPropertyName("brightness");
if (!bindings::GetDictionaryMemberFromV8Object<IDLBoolean, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[4].Get(isolate), fallback_presence_var, member_brightness_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("channelCount");
if (!bindings::GetDictionaryMemberFromV8Object<IDLBoolean, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[5].Get(isolate), fallback_presence_var, member_channel_count_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("colorTemperature");
if (!bindings::GetDictionaryMemberFromV8Object<IDLBoolean, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[6].Get(isolate), fallback_presence_var, member_color_temperature_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("contrast");
if (!bindings::GetDictionaryMemberFromV8Object<IDLBoolean, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[7].Get(isolate), fallback_presence_var, member_contrast_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("deviceId");
if (!bindings::GetDictionaryMemberFromV8Object<IDLBoolean, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[8].Get(isolate), fallback_presence_var, member_device_id_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("displaySurface");
if (!bindings::GetDictionaryMemberFromV8Object<IDLBoolean, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[9].Get(isolate), fallback_presence_var, member_display_surface_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("echoCancellation");
if (!bindings::GetDictionaryMemberFromV8Object<IDLBoolean, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[10].Get(isolate), fallback_presence_var, member_echo_cancellation_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("exposureCompensation");
if (!bindings::GetDictionaryMemberFromV8Object<IDLBoolean, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[11].Get(isolate), fallback_presence_var, member_exposure_compensation_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("exposureMode");
if (!bindings::GetDictionaryMemberFromV8Object<IDLBoolean, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[12].Get(isolate), fallback_presence_var, member_exposure_mode_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("exposureTime");
if (!bindings::GetDictionaryMemberFromV8Object<IDLBoolean, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[13].Get(isolate), fallback_presence_var, member_exposure_time_, class_like_name, exception_state)) {
  return;
}
if (RuntimeEnabledFeatures::MediaCaptureCameraControlsEnabled()) {
  dictionary_from_v8_context.SetCurrentPropertyName("eyeGazeCorrection");
if (!bindings::GetDictionaryMemberFromV8Object<IDLBoolean, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[14].Get(isolate), fallback_presence_var, member_eye_gaze_correction_, class_like_name, exception_state)) {
  return;
}
}
if (RuntimeEnabledFeatures::MediaCaptureCameraControlsEnabled()) {
  dictionary_from_v8_context.SetCurrentPropertyName("faceFraming");
if (!bindings::GetDictionaryMemberFromV8Object<IDLBoolean, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[15].Get(isolate), fallback_presence_var, member_face_framing_, class_like_name, exception_state)) {
  return;
}
}
dictionary_from_v8_context.SetCurrentPropertyName("facingMode");
if (!bindings::GetDictionaryMemberFromV8Object<IDLBoolean, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[16].Get(isolate), fallback_presence_var, member_facing_mode_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("focusDistance");
if (!bindings::GetDictionaryMemberFromV8Object<IDLBoolean, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[17].Get(isolate), fallback_presence_var, member_focus_distance_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("focusMode");
if (!bindings::GetDictionaryMemberFromV8Object<IDLBoolean, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[18].Get(isolate), fallback_presence_var, member_focus_mode_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("frameRate");
if (!bindings::GetDictionaryMemberFromV8Object<IDLBoolean, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[19].Get(isolate), fallback_presence_var, member_frame_rate_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("groupId");
if (!bindings::GetDictionaryMemberFromV8Object<IDLBoolean, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[20].Get(isolate), fallback_presence_var, member_group_id_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("height");
if (!bindings::GetDictionaryMemberFromV8Object<IDLBoolean, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[21].Get(isolate), fallback_presence_var, member_height_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("iso");
if (!bindings::GetDictionaryMemberFromV8Object<IDLBoolean, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[22].Get(isolate), fallback_presence_var, member_iso_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("latency");
if (!bindings::GetDictionaryMemberFromV8Object<IDLBoolean, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[23].Get(isolate), fallback_presence_var, member_latency_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("noiseSuppression");
if (!bindings::GetDictionaryMemberFromV8Object<IDLBoolean, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[24].Get(isolate), fallback_presence_var, member_noise_suppression_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("pan");
if (!bindings::GetDictionaryMemberFromV8Object<IDLBoolean, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[25].Get(isolate), fallback_presence_var, member_pan_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("pointsOfInterest");
if (!bindings::GetDictionaryMemberFromV8Object<IDLBoolean, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[26].Get(isolate), fallback_presence_var, member_points_of_interest_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("resizeMode");
if (!bindings::GetDictionaryMemberFromV8Object<IDLBoolean, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[27].Get(isolate), fallback_presence_var, member_resize_mode_, class_like_name, exception_state)) {
  return;
}
if (RuntimeEnabledFeatures::RestrictOwnAudioEnabled()) {
  dictionary_from_v8_context.SetCurrentPropertyName("restrictOwnAudio");
if (!bindings::GetDictionaryMemberFromV8Object<IDLBoolean, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[28].Get(isolate), fallback_presence_var, member_restrict_own_audio_, class_like_name, exception_state)) {
  return;
}
}
dictionary_from_v8_context.SetCurrentPropertyName("sampleRate");
if (!bindings::GetDictionaryMemberFromV8Object<IDLBoolean, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[29].Get(isolate), fallback_presence_var, member_sample_rate_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("sampleSize");
if (!bindings::GetDictionaryMemberFromV8Object<IDLBoolean, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[30].Get(isolate), fallback_presence_var, member_sample_size_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("saturation");
if (!bindings::GetDictionaryMemberFromV8Object<IDLBoolean, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[31].Get(isolate), fallback_presence_var, member_saturation_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("sharpness");
if (!bindings::GetDictionaryMemberFromV8Object<IDLBoolean, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[32].Get(isolate), fallback_presence_var, member_sharpness_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("suppressLocalAudioPlayback");
if (!bindings::GetDictionaryMemberFromV8Object<IDLBoolean, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[33].Get(isolate), fallback_presence_var, member_suppress_local_audio_playback_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("tilt");
if (!bindings::GetDictionaryMemberFromV8Object<IDLBoolean, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[34].Get(isolate), fallback_presence_var, member_tilt_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("torch");
if (!bindings::GetDictionaryMemberFromV8Object<IDLBoolean, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[35].Get(isolate), fallback_presence_var, member_torch_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("voiceIsolation");
if (!bindings::GetDictionaryMemberFromV8Object<IDLBoolean, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[36].Get(isolate), fallback_presence_var, member_voice_isolation_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("whiteBalanceMode");
if (!bindings::GetDictionaryMemberFromV8Object<IDLBoolean, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[37].Get(isolate), fallback_presence_var, member_white_balance_mode_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("width");
if (!bindings::GetDictionaryMemberFromV8Object<IDLBoolean, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[38].Get(isolate), fallback_presence_var, member_width_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("zoom");
if (!bindings::GetDictionaryMemberFromV8Object<IDLBoolean, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[39].Get(isolate), fallback_presence_var, member_zoom_, class_like_name, exception_state)) {
  return;
}
}

const base::span<const v8::Eternal<v8::Name>> MediaTrackSupportedConstraints::GetV8OwnMemberNames(v8::Isolate* isolate) {
  return V8PerIsolateData::From(isolate)->FindOrCreateEternalNameCache(kOwnPropertyNames, kOwnPropertyNames);
}


}  // namespace blink
