// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_MEDIA_TRACK_CONSTRAINTS_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_MEDIA_TRACK_CONSTRAINTS_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_media_track_constraint_set.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/heap/collection_support/heap_vector.h"
#include "third_party/blink/renderer/platform/heap/member.h"

namespace blink {

class ExceptionState;
class MediaTrackConstraintSet;

class MODULES_EXPORT MediaTrackConstraints : public MediaTrackConstraintSet {
  
  public:
static MediaTrackConstraints* Create() {
  return MakeGarbageCollected<MediaTrackConstraints>();
}
static MediaTrackConstraints* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<MediaTrackConstraints>(isolate);
}
static MediaTrackConstraints* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  MediaTrackConstraints();
explicit  MediaTrackConstraints(v8::Isolate* isolate);

bool hasAdvanced() const {
  return has_advanced_;
}
const HeapVector<Member<MediaTrackConstraintSet>>& advanced() const {
  DCHECK(hasAdvanced());
return member_advanced_;
}
HeapVector<Member<MediaTrackConstraintSet>> getAdvancedOr(const HeapVector<Member<MediaTrackConstraintSet>>& fallback_value) const;
HeapVector<Member<MediaTrackConstraintSet>> getAdvancedOr(HeapVector<Member<MediaTrackConstraintSet>>&& fallback_value) const;
void setAdvanced(const HeapVector<Member<MediaTrackConstraintSet>>& value);
void setAdvanced(HeapVector<Member<MediaTrackConstraintSet>>&& value);




void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = MediaTrackConstraintSet::kTotalPropertyCount;
static constexpr size_t kOwnPropertyCount = 1;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillTemplateProperties(Vector<std::string_view>& properties) const override;
void FillValuesImpl(ScriptState* script_state, base::span<v8::MaybeLocal<v8::Value>> values) const;


void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
const void* TemplateKey() const override;
v8::Local<v8::Object> FillValues(ScriptState* script_state, v8::Local<v8::DictionaryTemplate> dict_template) const override;
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_advanced_ = false;

HeapVector<Member<MediaTrackConstraintSet>> member_advanced_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_MEDIA_TRACK_CONSTRAINTS_H_
