// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#include "third_party/blink/renderer/bindings/modules/v8/v8_media_track_constraint_set.h"

#include "third_party/blink/renderer/bindings/core/v8/generated_code_helper.h"
#include "third_party/blink/renderer/bindings/core/v8/native_value_traits_impl.h"
#include "third_party/blink/renderer/bindings/core/v8/to_v8_traits.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_constrain_boolean_or_dom_string_parameters.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_constrain_boolean_parameters.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_constrain_dom_string_parameters.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_constrain_double_range.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_constrain_long_range.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_constrain_point_2d_parameters.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_point_2d.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_union_boolean_constrainbooleanordomstringparameters_string.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_union_boolean_constrainbooleanparameters.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_union_boolean_constraindoublerange_double.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_union_constraindomstringparameters_string_stringsequence.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_union_constraindoublerange_double.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_union_constrainlongrange_long.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_union_constrainpoint2dparameters_point2dsequence.h"
#include "third_party/blink/renderer/core/execution_context/execution_context.h"
#include "third_party/blink/renderer/platform/bindings/exception_messages.h"
#include "third_party/blink/renderer/platform/bindings/exception_state.h"
#include "third_party/blink/renderer/platform/bindings/v8_per_isolate_data.h"
#include "third_party/blink/renderer/platform/runtime_enabled_features.h"

namespace blink {



namespace  {

const std::string_view kOwnPropertyNames[] = {
"aspectRatio",
"autoGainControl",
"backgroundBlur",
"backgroundSegmentationMask",
"brightness",
"channelCount",
"colorTemperature",
"contrast",
"deviceId",
"displaySurface",
"echoCancellation",
"exposureCompensation",
"exposureMode",
"exposureTime",
"eyeGazeCorrection",
"faceFraming",
"facingMode",
"focusDistance",
"focusMode",
"frameRate",
"groupId",
"height",
"iso",
"latency",
"mandatory",
"noiseSuppression",
"optional",
"pan",
"pointsOfInterest",
"resizeMode",
"restrictOwnAudio",
"sampleRate",
"sampleSize",
"saturation",
"sharpness",
"suppressLocalAudioPlayback",
"tilt",
"torch",
"voiceIsolation",
"whiteBalanceMode",
"width",
"zoom",
};


}  // namespace 

MediaTrackConstraintSet* MediaTrackConstraintSet::Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state) {
  MediaTrackConstraintSet* dictionary = MakeGarbageCollected<MediaTrackConstraintSet>(isolate);
if (v8_value->IsNullOrUndefined()) {
  return dictionary;
}
if (!v8_value->IsObject()) {
  const char* const class_like_name = "MediaTrackConstraintSet";
exception_state.ThrowTypeError(ExceptionMessages::ValueNotOfType(class_like_name));
return nullptr;
}
dictionary->FillMembersFromV8Object(isolate, v8_value.As<v8::Object>(), exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return nullptr;
}
return dictionary;
}

 MediaTrackConstraintSet::MediaTrackConstraintSet() {
  
}

 MediaTrackConstraintSet::MediaTrackConstraintSet(v8::Isolate* isolate) {
  
}

























































































































































































HeapVector<ScriptObject> MediaTrackConstraintSet::getOptionalOr(const HeapVector<ScriptObject>& fallback_value) const {
  if (!hasOptional()) {
  return fallback_value;
}
return member_optional_;
}

HeapVector<ScriptObject> MediaTrackConstraintSet::getOptionalOr(HeapVector<ScriptObject>&& fallback_value) const {
  if (!hasOptional()) {
  return std::move(fallback_value);
}
return member_optional_;
}

void MediaTrackConstraintSet::setOptional(const HeapVector<ScriptObject>& value) {
  member_optional_ = value;
has_optional_ = true;
}

void MediaTrackConstraintSet::setOptional(HeapVector<ScriptObject>&& value) {
  member_optional_ = std::move(value);
has_optional_ = true;
}













































































































void MediaTrackConstraintSet::Trace(Visitor* visitor) const {
  visitor->Trace(member_aspect_ratio_);
visitor->Trace(member_auto_gain_control_);
visitor->Trace(member_background_blur_);
visitor->Trace(member_background_segmentation_mask_);
visitor->Trace(member_brightness_);
visitor->Trace(member_channel_count_);
visitor->Trace(member_color_temperature_);
visitor->Trace(member_contrast_);
visitor->Trace(member_device_id_);
visitor->Trace(member_display_surface_);
visitor->Trace(member_echo_cancellation_);
visitor->Trace(member_exposure_compensation_);
visitor->Trace(member_exposure_mode_);
visitor->Trace(member_exposure_time_);
visitor->Trace(member_eye_gaze_correction_);
visitor->Trace(member_face_framing_);
visitor->Trace(member_facing_mode_);
visitor->Trace(member_focus_distance_);
visitor->Trace(member_focus_mode_);
visitor->Trace(member_frame_rate_);
visitor->Trace(member_group_id_);
visitor->Trace(member_height_);
visitor->Trace(member_iso_);
visitor->Trace(member_latency_);
visitor->Trace(member_mandatory_);
visitor->Trace(member_noise_suppression_);
visitor->Trace(member_optional_);
visitor->Trace(member_pan_);
visitor->Trace(member_points_of_interest_);
visitor->Trace(member_resize_mode_);
visitor->Trace(member_restrict_own_audio_);
visitor->Trace(member_sample_rate_);
visitor->Trace(member_sample_size_);
visitor->Trace(member_saturation_);
visitor->Trace(member_sharpness_);
visitor->Trace(member_suppress_local_audio_playback_);
visitor->Trace(member_tilt_);
visitor->Trace(member_torch_);
visitor->Trace(member_voice_isolation_);
visitor->Trace(member_white_balance_mode_);
visitor->Trace(member_width_);
visitor->Trace(member_zoom_);
bindings::DictionaryBase::Trace(visitor);
}

void MediaTrackConstraintSet::FillTemplateProperties(Vector<std::string_view>& properties) const {
  static_assert(std::size(kOwnPropertyNames) == kOwnPropertyCount);
properties.AppendRange(std::cbegin(kOwnPropertyNames), std::cend(kOwnPropertyNames));
DCHECK_EQ(properties.size(), kTotalPropertyCount);
}

void MediaTrackConstraintSet::FillValuesImpl(ScriptState* script_state, base::span<v8::MaybeLocal<v8::Value>> values) const {
  CHECK_EQ(kOwnPropertyCount, values.size());
if (hasAspectRatio()) {
  values[0] = ToV8Traits<V8UnionConstrainDoubleRangeOrDouble>::ToV8(script_state, member_aspect_ratio_.Get());
DCHECK(!values[0].IsEmpty());
}
if (hasAutoGainControl()) {
  values[1] = ToV8Traits<V8UnionBooleanOrConstrainBooleanParameters>::ToV8(script_state, member_auto_gain_control_.Get());
DCHECK(!values[1].IsEmpty());
}
v8::Isolate* isolate = script_state->GetIsolate();
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
ExecutionContext* execution_context = ExecutionContext::From(current_context);
if (RuntimeEnabledFeatures::MediaCaptureBackgroundBlurEnabled(execution_context)) {
  if (hasBackgroundBlur()) {
  values[2] = ToV8Traits<V8UnionBooleanOrConstrainBooleanParameters>::ToV8(script_state, member_background_blur_.Get());
DCHECK(!values[2].IsEmpty());
}
}
if (RuntimeEnabledFeatures::MediaCaptureCameraControlsEnabled()) {
  if (hasBackgroundSegmentationMask()) {
  values[3] = ToV8Traits<V8UnionBooleanOrConstrainBooleanParameters>::ToV8(script_state, member_background_segmentation_mask_.Get());
DCHECK(!values[3].IsEmpty());
}
}
if (hasBrightness()) {
  values[4] = ToV8Traits<V8UnionConstrainDoubleRangeOrDouble>::ToV8(script_state, member_brightness_.Get());
DCHECK(!values[4].IsEmpty());
}
if (hasChannelCount()) {
  values[5] = ToV8Traits<V8UnionConstrainLongRangeOrLong>::ToV8(script_state, member_channel_count_.Get());
DCHECK(!values[5].IsEmpty());
}
if (hasColorTemperature()) {
  values[6] = ToV8Traits<V8UnionConstrainDoubleRangeOrDouble>::ToV8(script_state, member_color_temperature_.Get());
DCHECK(!values[6].IsEmpty());
}
if (hasContrast()) {
  values[7] = ToV8Traits<V8UnionConstrainDoubleRangeOrDouble>::ToV8(script_state, member_contrast_.Get());
DCHECK(!values[7].IsEmpty());
}
if (hasDeviceId()) {
  values[8] = ToV8Traits<V8UnionConstrainDOMStringParametersOrStringOrStringSequence>::ToV8(script_state, member_device_id_.Get());
DCHECK(!values[8].IsEmpty());
}
if (hasDisplaySurface()) {
  values[9] = ToV8Traits<V8UnionConstrainDOMStringParametersOrStringOrStringSequence>::ToV8(script_state, member_display_surface_.Get());
DCHECK(!values[9].IsEmpty());
}
if (hasEchoCancellation()) {
  values[10] = ToV8Traits<V8UnionBooleanOrConstrainBooleanOrDOMStringParametersOrString>::ToV8(script_state, member_echo_cancellation_.Get());
DCHECK(!values[10].IsEmpty());
}
if (hasExposureCompensation()) {
  values[11] = ToV8Traits<V8UnionConstrainDoubleRangeOrDouble>::ToV8(script_state, member_exposure_compensation_.Get());
DCHECK(!values[11].IsEmpty());
}
if (hasExposureMode()) {
  values[12] = ToV8Traits<V8UnionConstrainDOMStringParametersOrStringOrStringSequence>::ToV8(script_state, member_exposure_mode_.Get());
DCHECK(!values[12].IsEmpty());
}
if (hasExposureTime()) {
  values[13] = ToV8Traits<V8UnionConstrainDoubleRangeOrDouble>::ToV8(script_state, member_exposure_time_.Get());
DCHECK(!values[13].IsEmpty());
}
if (RuntimeEnabledFeatures::MediaCaptureCameraControlsEnabled()) {
  if (hasEyeGazeCorrection()) {
  values[14] = ToV8Traits<V8UnionBooleanOrConstrainBooleanParameters>::ToV8(script_state, member_eye_gaze_correction_.Get());
DCHECK(!values[14].IsEmpty());
}
}
if (RuntimeEnabledFeatures::MediaCaptureCameraControlsEnabled()) {
  if (hasFaceFraming()) {
  values[15] = ToV8Traits<V8UnionBooleanOrConstrainBooleanParameters>::ToV8(script_state, member_face_framing_.Get());
DCHECK(!values[15].IsEmpty());
}
}
if (hasFacingMode()) {
  values[16] = ToV8Traits<V8UnionConstrainDOMStringParametersOrStringOrStringSequence>::ToV8(script_state, member_facing_mode_.Get());
DCHECK(!values[16].IsEmpty());
}
if (hasFocusDistance()) {
  values[17] = ToV8Traits<V8UnionConstrainDoubleRangeOrDouble>::ToV8(script_state, member_focus_distance_.Get());
DCHECK(!values[17].IsEmpty());
}
if (hasFocusMode()) {
  values[18] = ToV8Traits<V8UnionConstrainDOMStringParametersOrStringOrStringSequence>::ToV8(script_state, member_focus_mode_.Get());
DCHECK(!values[18].IsEmpty());
}
if (hasFrameRate()) {
  values[19] = ToV8Traits<V8UnionConstrainDoubleRangeOrDouble>::ToV8(script_state, member_frame_rate_.Get());
DCHECK(!values[19].IsEmpty());
}
if (hasGroupId()) {
  values[20] = ToV8Traits<V8UnionConstrainDOMStringParametersOrStringOrStringSequence>::ToV8(script_state, member_group_id_.Get());
DCHECK(!values[20].IsEmpty());
}
if (hasHeight()) {
  values[21] = ToV8Traits<V8UnionConstrainLongRangeOrLong>::ToV8(script_state, member_height_.Get());
DCHECK(!values[21].IsEmpty());
}
if (hasIso()) {
  values[22] = ToV8Traits<V8UnionConstrainDoubleRangeOrDouble>::ToV8(script_state, member_iso_.Get());
DCHECK(!values[22].IsEmpty());
}
if (hasLatency()) {
  values[23] = ToV8Traits<V8UnionConstrainDoubleRangeOrDouble>::ToV8(script_state, member_latency_.Get());
DCHECK(!values[23].IsEmpty());
}
if (hasMandatory()) {
  values[24] = ToV8Traits<IDLObject>::ToV8(script_state, member_mandatory_);
DCHECK(!values[24].IsEmpty());
}
if (hasNoiseSuppression()) {
  values[25] = ToV8Traits<V8UnionBooleanOrConstrainBooleanParameters>::ToV8(script_state, member_noise_suppression_.Get());
DCHECK(!values[25].IsEmpty());
}
if (hasOptional()) {
  values[26] = ToV8Traits<IDLSequence<IDLObject>>::ToV8(script_state, member_optional_);
DCHECK(!values[26].IsEmpty());
}
if (hasPan()) {
  values[27] = ToV8Traits<V8UnionBooleanOrConstrainDoubleRangeOrDouble>::ToV8(script_state, member_pan_.Get());
DCHECK(!values[27].IsEmpty());
}
if (hasPointsOfInterest()) {
  values[28] = ToV8Traits<V8UnionConstrainPoint2DParametersOrPoint2DSequence>::ToV8(script_state, member_points_of_interest_.Get());
DCHECK(!values[28].IsEmpty());
}
if (hasResizeMode()) {
  values[29] = ToV8Traits<V8UnionConstrainDOMStringParametersOrStringOrStringSequence>::ToV8(script_state, member_resize_mode_.Get());
DCHECK(!values[29].IsEmpty());
}
if (RuntimeEnabledFeatures::RestrictOwnAudioEnabled()) {
  if (hasRestrictOwnAudio()) {
  values[30] = ToV8Traits<V8UnionBooleanOrConstrainBooleanParameters>::ToV8(script_state, member_restrict_own_audio_.Get());
DCHECK(!values[30].IsEmpty());
}
}
if (hasSampleRate()) {
  values[31] = ToV8Traits<V8UnionConstrainLongRangeOrLong>::ToV8(script_state, member_sample_rate_.Get());
DCHECK(!values[31].IsEmpty());
}
if (hasSampleSize()) {
  values[32] = ToV8Traits<V8UnionConstrainLongRangeOrLong>::ToV8(script_state, member_sample_size_.Get());
DCHECK(!values[32].IsEmpty());
}
if (hasSaturation()) {
  values[33] = ToV8Traits<V8UnionConstrainDoubleRangeOrDouble>::ToV8(script_state, member_saturation_.Get());
DCHECK(!values[33].IsEmpty());
}
if (hasSharpness()) {
  values[34] = ToV8Traits<V8UnionConstrainDoubleRangeOrDouble>::ToV8(script_state, member_sharpness_.Get());
DCHECK(!values[34].IsEmpty());
}
if (hasSuppressLocalAudioPlayback()) {
  values[35] = ToV8Traits<V8UnionBooleanOrConstrainBooleanParameters>::ToV8(script_state, member_suppress_local_audio_playback_.Get());
DCHECK(!values[35].IsEmpty());
}
if (hasTilt()) {
  values[36] = ToV8Traits<V8UnionBooleanOrConstrainDoubleRangeOrDouble>::ToV8(script_state, member_tilt_.Get());
DCHECK(!values[36].IsEmpty());
}
if (hasTorch()) {
  values[37] = ToV8Traits<V8UnionBooleanOrConstrainBooleanParameters>::ToV8(script_state, member_torch_.Get());
DCHECK(!values[37].IsEmpty());
}
if (hasVoiceIsolation()) {
  values[38] = ToV8Traits<V8UnionBooleanOrConstrainBooleanParameters>::ToV8(script_state, member_voice_isolation_.Get());
DCHECK(!values[38].IsEmpty());
}
if (hasWhiteBalanceMode()) {
  values[39] = ToV8Traits<V8UnionConstrainDOMStringParametersOrStringOrStringSequence>::ToV8(script_state, member_white_balance_mode_.Get());
DCHECK(!values[39].IsEmpty());
}
if (hasWidth()) {
  values[40] = ToV8Traits<V8UnionConstrainLongRangeOrLong>::ToV8(script_state, member_width_.Get());
DCHECK(!values[40].IsEmpty());
}
if (hasZoom()) {
  values[41] = ToV8Traits<V8UnionBooleanOrConstrainDoubleRangeOrDouble>::ToV8(script_state, member_zoom_.Get());
DCHECK(!values[41].IsEmpty());
}
}

const void* MediaTrackConstraintSet::TemplateKey() const {
  static const void *s_key = &s_key;
return s_key;
}

v8::Local<v8::Object> MediaTrackConstraintSet::FillValues(ScriptState* script_state, v8::Local<v8::DictionaryTemplate> dict_template) const {
  v8::MaybeLocal<v8::Value> values[kTotalPropertyCount];
FillValuesImpl(script_state, values);
return dict_template->NewInstance(script_state->GetContext(), values);
}

void MediaTrackConstraintSet::FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state) {
  TryRethrowScope rethrow_scope(isolate, exception_state);
const char* const class_like_name = "MediaTrackConstraintSet";
DictionaryConversionContext dictionary_from_v8_context(isolate, class_like_name);
dictionary_from_v8_context.SetCurrentPropertyName("aspectRatio");
constexpr bool is_optional = false;
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
const auto& v8_own_member_names = GetV8OwnMemberNames(isolate);
if (!bindings::GetDictionaryMemberFromV8Object<V8UnionConstrainDoubleRangeOrDouble, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[0].Get(isolate), has_aspect_ratio_, member_aspect_ratio_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("autoGainControl");
if (!bindings::GetDictionaryMemberFromV8Object<V8UnionBooleanOrConstrainBooleanParameters, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[1].Get(isolate), has_auto_gain_control_, member_auto_gain_control_, class_like_name, exception_state)) {
  return;
}
ExecutionContext* execution_context = ExecutionContext::From(current_context);
if (RuntimeEnabledFeatures::MediaCaptureBackgroundBlurEnabled(execution_context)) {
  dictionary_from_v8_context.SetCurrentPropertyName("backgroundBlur");
if (!bindings::GetDictionaryMemberFromV8Object<V8UnionBooleanOrConstrainBooleanParameters, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[2].Get(isolate), has_background_blur_, member_background_blur_, class_like_name, exception_state)) {
  return;
}
}
if (RuntimeEnabledFeatures::MediaCaptureCameraControlsEnabled()) {
  dictionary_from_v8_context.SetCurrentPropertyName("backgroundSegmentationMask");
if (!bindings::GetDictionaryMemberFromV8Object<V8UnionBooleanOrConstrainBooleanParameters, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[3].Get(isolate), has_background_segmentation_mask_, member_background_segmentation_mask_, class_like_name, exception_state)) {
  return;
}
}
dictionary_from_v8_context.SetCurrentPropertyName("brightness");
if (!bindings::GetDictionaryMemberFromV8Object<V8UnionConstrainDoubleRangeOrDouble, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[4].Get(isolate), has_brightness_, member_brightness_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("channelCount");
if (!bindings::GetDictionaryMemberFromV8Object<V8UnionConstrainLongRangeOrLong, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[5].Get(isolate), has_channel_count_, member_channel_count_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("colorTemperature");
if (!bindings::GetDictionaryMemberFromV8Object<V8UnionConstrainDoubleRangeOrDouble, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[6].Get(isolate), has_color_temperature_, member_color_temperature_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("contrast");
if (!bindings::GetDictionaryMemberFromV8Object<V8UnionConstrainDoubleRangeOrDouble, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[7].Get(isolate), has_contrast_, member_contrast_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("deviceId");
if (!bindings::GetDictionaryMemberFromV8Object<V8UnionConstrainDOMStringParametersOrStringOrStringSequence, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[8].Get(isolate), has_device_id_, member_device_id_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("displaySurface");
if (!bindings::GetDictionaryMemberFromV8Object<V8UnionConstrainDOMStringParametersOrStringOrStringSequence, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[9].Get(isolate), has_display_surface_, member_display_surface_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("echoCancellation");
if (!bindings::GetDictionaryMemberFromV8Object<V8UnionBooleanOrConstrainBooleanOrDOMStringParametersOrString, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[10].Get(isolate), has_echo_cancellation_, member_echo_cancellation_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("exposureCompensation");
if (!bindings::GetDictionaryMemberFromV8Object<V8UnionConstrainDoubleRangeOrDouble, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[11].Get(isolate), has_exposure_compensation_, member_exposure_compensation_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("exposureMode");
if (!bindings::GetDictionaryMemberFromV8Object<V8UnionConstrainDOMStringParametersOrStringOrStringSequence, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[12].Get(isolate), has_exposure_mode_, member_exposure_mode_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("exposureTime");
if (!bindings::GetDictionaryMemberFromV8Object<V8UnionConstrainDoubleRangeOrDouble, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[13].Get(isolate), has_exposure_time_, member_exposure_time_, class_like_name, exception_state)) {
  return;
}
if (RuntimeEnabledFeatures::MediaCaptureCameraControlsEnabled()) {
  dictionary_from_v8_context.SetCurrentPropertyName("eyeGazeCorrection");
if (!bindings::GetDictionaryMemberFromV8Object<V8UnionBooleanOrConstrainBooleanParameters, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[14].Get(isolate), has_eye_gaze_correction_, member_eye_gaze_correction_, class_like_name, exception_state)) {
  return;
}
}
if (RuntimeEnabledFeatures::MediaCaptureCameraControlsEnabled()) {
  dictionary_from_v8_context.SetCurrentPropertyName("faceFraming");
if (!bindings::GetDictionaryMemberFromV8Object<V8UnionBooleanOrConstrainBooleanParameters, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[15].Get(isolate), has_face_framing_, member_face_framing_, class_like_name, exception_state)) {
  return;
}
}
dictionary_from_v8_context.SetCurrentPropertyName("facingMode");
if (!bindings::GetDictionaryMemberFromV8Object<V8UnionConstrainDOMStringParametersOrStringOrStringSequence, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[16].Get(isolate), has_facing_mode_, member_facing_mode_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("focusDistance");
if (!bindings::GetDictionaryMemberFromV8Object<V8UnionConstrainDoubleRangeOrDouble, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[17].Get(isolate), has_focus_distance_, member_focus_distance_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("focusMode");
if (!bindings::GetDictionaryMemberFromV8Object<V8UnionConstrainDOMStringParametersOrStringOrStringSequence, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[18].Get(isolate), has_focus_mode_, member_focus_mode_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("frameRate");
if (!bindings::GetDictionaryMemberFromV8Object<V8UnionConstrainDoubleRangeOrDouble, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[19].Get(isolate), has_frame_rate_, member_frame_rate_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("groupId");
if (!bindings::GetDictionaryMemberFromV8Object<V8UnionConstrainDOMStringParametersOrStringOrStringSequence, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[20].Get(isolate), has_group_id_, member_group_id_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("height");
if (!bindings::GetDictionaryMemberFromV8Object<V8UnionConstrainLongRangeOrLong, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[21].Get(isolate), has_height_, member_height_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("iso");
if (!bindings::GetDictionaryMemberFromV8Object<V8UnionConstrainDoubleRangeOrDouble, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[22].Get(isolate), has_iso_, member_iso_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("latency");
if (!bindings::GetDictionaryMemberFromV8Object<V8UnionConstrainDoubleRangeOrDouble, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[23].Get(isolate), has_latency_, member_latency_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("mandatory");
if (!bindings::GetDictionaryMemberFromV8Object<IDLObject, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[24].Get(isolate), has_mandatory_, member_mandatory_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("noiseSuppression");
if (!bindings::GetDictionaryMemberFromV8Object<V8UnionBooleanOrConstrainBooleanParameters, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[25].Get(isolate), has_noise_suppression_, member_noise_suppression_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("optional");
if (!bindings::GetDictionaryMemberFromV8Object<IDLSequence<IDLObject>, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[26].Get(isolate), has_optional_, member_optional_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("pan");
if (!bindings::GetDictionaryMemberFromV8Object<V8UnionBooleanOrConstrainDoubleRangeOrDouble, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[27].Get(isolate), has_pan_, member_pan_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("pointsOfInterest");
if (!bindings::GetDictionaryMemberFromV8Object<V8UnionConstrainPoint2DParametersOrPoint2DSequence, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[28].Get(isolate), has_points_of_interest_, member_points_of_interest_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("resizeMode");
if (!bindings::GetDictionaryMemberFromV8Object<V8UnionConstrainDOMStringParametersOrStringOrStringSequence, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[29].Get(isolate), has_resize_mode_, member_resize_mode_, class_like_name, exception_state)) {
  return;
}
if (RuntimeEnabledFeatures::RestrictOwnAudioEnabled()) {
  dictionary_from_v8_context.SetCurrentPropertyName("restrictOwnAudio");
if (!bindings::GetDictionaryMemberFromV8Object<V8UnionBooleanOrConstrainBooleanParameters, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[30].Get(isolate), has_restrict_own_audio_, member_restrict_own_audio_, class_like_name, exception_state)) {
  return;
}
}
dictionary_from_v8_context.SetCurrentPropertyName("sampleRate");
if (!bindings::GetDictionaryMemberFromV8Object<V8UnionConstrainLongRangeOrLong, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[31].Get(isolate), has_sample_rate_, member_sample_rate_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("sampleSize");
if (!bindings::GetDictionaryMemberFromV8Object<V8UnionConstrainLongRangeOrLong, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[32].Get(isolate), has_sample_size_, member_sample_size_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("saturation");
if (!bindings::GetDictionaryMemberFromV8Object<V8UnionConstrainDoubleRangeOrDouble, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[33].Get(isolate), has_saturation_, member_saturation_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("sharpness");
if (!bindings::GetDictionaryMemberFromV8Object<V8UnionConstrainDoubleRangeOrDouble, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[34].Get(isolate), has_sharpness_, member_sharpness_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("suppressLocalAudioPlayback");
if (!bindings::GetDictionaryMemberFromV8Object<V8UnionBooleanOrConstrainBooleanParameters, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[35].Get(isolate), has_suppress_local_audio_playback_, member_suppress_local_audio_playback_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("tilt");
if (!bindings::GetDictionaryMemberFromV8Object<V8UnionBooleanOrConstrainDoubleRangeOrDouble, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[36].Get(isolate), has_tilt_, member_tilt_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("torch");
if (!bindings::GetDictionaryMemberFromV8Object<V8UnionBooleanOrConstrainBooleanParameters, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[37].Get(isolate), has_torch_, member_torch_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("voiceIsolation");
if (!bindings::GetDictionaryMemberFromV8Object<V8UnionBooleanOrConstrainBooleanParameters, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[38].Get(isolate), has_voice_isolation_, member_voice_isolation_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("whiteBalanceMode");
if (!bindings::GetDictionaryMemberFromV8Object<V8UnionConstrainDOMStringParametersOrStringOrStringSequence, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[39].Get(isolate), has_white_balance_mode_, member_white_balance_mode_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("width");
if (!bindings::GetDictionaryMemberFromV8Object<V8UnionConstrainLongRangeOrLong, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[40].Get(isolate), has_width_, member_width_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("zoom");
if (!bindings::GetDictionaryMemberFromV8Object<V8UnionBooleanOrConstrainDoubleRangeOrDouble, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[41].Get(isolate), has_zoom_, member_zoom_, class_like_name, exception_state)) {
  return;
}
}

const base::span<const v8::Eternal<v8::Name>> MediaTrackConstraintSet::GetV8OwnMemberNames(v8::Isolate* isolate) {
  return V8PerIsolateData::From(isolate)->FindOrCreateEternalNameCache(kOwnPropertyNames, kOwnPropertyNames);
}


}  // namespace blink
