// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_MEDIA_TRACK_CAPABILITIES_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_MEDIA_TRACK_CAPABILITIES_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"
#include "third_party/blink/renderer/platform/heap/collection_support/heap_vector.h"
#include "third_party/blink/renderer/platform/heap/member.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

namespace blink {

class DoubleRange;
class ExceptionState;
class LongRange;
class MediaSettingsRange;
class V8UnionBooleanOrString;

class MODULES_EXPORT MediaTrackCapabilities : public bindings::DictionaryBase {
  
  public:
static MediaTrackCapabilities* Create() {
  return MakeGarbageCollected<MediaTrackCapabilities>();
}
static MediaTrackCapabilities* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<MediaTrackCapabilities>(isolate);
}
static MediaTrackCapabilities* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  MediaTrackCapabilities();
explicit  MediaTrackCapabilities(v8::Isolate* isolate);

bool hasAspectRatio() const {
  return has_aspect_ratio_;
}
DoubleRange* aspectRatio() const {
  DCHECK(hasAspectRatio());
return member_aspect_ratio_.Get();
}
DoubleRange* getAspectRatioOr(DoubleRange* fallback_value) const {
  if (!hasAspectRatio()) {
  return fallback_value;
}
return member_aspect_ratio_.Get();
}
void setAspectRatio(DoubleRange* value) {
  member_aspect_ratio_ = value;
has_aspect_ratio_ = true;
DCHECK(member_aspect_ratio_);
}

bool hasAutoGainControl() const {
  return has_auto_gain_control_;
}
const Vector<bool>& autoGainControl() const {
  DCHECK(hasAutoGainControl());
return member_auto_gain_control_;
}
Vector<bool> getAutoGainControlOr(const Vector<bool>& fallback_value) const;
Vector<bool> getAutoGainControlOr(Vector<bool>&& fallback_value) const;
void setAutoGainControl(const Vector<bool>& value);
void setAutoGainControl(Vector<bool>&& value);

bool hasBackgroundBlur() const {
  return has_background_blur_;
}
const Vector<bool>& backgroundBlur() const {
  DCHECK(hasBackgroundBlur());
return member_background_blur_;
}
Vector<bool> getBackgroundBlurOr(const Vector<bool>& fallback_value) const;
Vector<bool> getBackgroundBlurOr(Vector<bool>&& fallback_value) const;
void setBackgroundBlur(const Vector<bool>& value);
void setBackgroundBlur(Vector<bool>&& value);

bool hasBackgroundSegmentationMask() const {
  return has_background_segmentation_mask_;
}
const Vector<bool>& backgroundSegmentationMask() const {
  DCHECK(hasBackgroundSegmentationMask());
return member_background_segmentation_mask_;
}
Vector<bool> getBackgroundSegmentationMaskOr(const Vector<bool>& fallback_value) const;
Vector<bool> getBackgroundSegmentationMaskOr(Vector<bool>&& fallback_value) const;
void setBackgroundSegmentationMask(const Vector<bool>& value);
void setBackgroundSegmentationMask(Vector<bool>&& value);

bool hasBrightness() const {
  return has_brightness_;
}
MediaSettingsRange* brightness() const {
  DCHECK(hasBrightness());
return member_brightness_.Get();
}
MediaSettingsRange* getBrightnessOr(MediaSettingsRange* fallback_value) const {
  if (!hasBrightness()) {
  return fallback_value;
}
return member_brightness_.Get();
}
void setBrightness(MediaSettingsRange* value) {
  member_brightness_ = value;
has_brightness_ = true;
DCHECK(member_brightness_);
}

bool hasChannelCount() const {
  return has_channel_count_;
}
LongRange* channelCount() const {
  DCHECK(hasChannelCount());
return member_channel_count_.Get();
}
LongRange* getChannelCountOr(LongRange* fallback_value) const {
  if (!hasChannelCount()) {
  return fallback_value;
}
return member_channel_count_.Get();
}
void setChannelCount(LongRange* value) {
  member_channel_count_ = value;
has_channel_count_ = true;
DCHECK(member_channel_count_);
}

bool hasColorTemperature() const {
  return has_color_temperature_;
}
MediaSettingsRange* colorTemperature() const {
  DCHECK(hasColorTemperature());
return member_color_temperature_.Get();
}
MediaSettingsRange* getColorTemperatureOr(MediaSettingsRange* fallback_value) const {
  if (!hasColorTemperature()) {
  return fallback_value;
}
return member_color_temperature_.Get();
}
void setColorTemperature(MediaSettingsRange* value) {
  member_color_temperature_ = value;
has_color_temperature_ = true;
DCHECK(member_color_temperature_);
}

bool hasContrast() const {
  return has_contrast_;
}
MediaSettingsRange* contrast() const {
  DCHECK(hasContrast());
return member_contrast_.Get();
}
MediaSettingsRange* getContrastOr(MediaSettingsRange* fallback_value) const {
  if (!hasContrast()) {
  return fallback_value;
}
return member_contrast_.Get();
}
void setContrast(MediaSettingsRange* value) {
  member_contrast_ = value;
has_contrast_ = true;
DCHECK(member_contrast_);
}

bool hasDeviceId() const {
  return has_device_id_;
}
const String& deviceId() const {
  DCHECK(hasDeviceId());
return member_device_id_;
}
String getDeviceIdOr(const String& fallback_value) const;
String getDeviceIdOr(String&& fallback_value) const;
void setDeviceId(const String& value);
void setDeviceId(String&& value);

bool hasDisplaySurface() const {
  return has_display_surface_;
}
const String& displaySurface() const {
  DCHECK(hasDisplaySurface());
return member_display_surface_;
}
String getDisplaySurfaceOr(const String& fallback_value) const;
String getDisplaySurfaceOr(String&& fallback_value) const;
void setDisplaySurface(const String& value);
void setDisplaySurface(String&& value);

bool hasEchoCancellation() const {
  return has_echo_cancellation_;
}
const HeapVector<Member<V8UnionBooleanOrString>>& echoCancellation() const {
  DCHECK(hasEchoCancellation());
return member_echo_cancellation_;
}
HeapVector<Member<V8UnionBooleanOrString>> getEchoCancellationOr(const HeapVector<Member<V8UnionBooleanOrString>>& fallback_value) const;
HeapVector<Member<V8UnionBooleanOrString>> getEchoCancellationOr(HeapVector<Member<V8UnionBooleanOrString>>&& fallback_value) const;
void setEchoCancellation(const HeapVector<Member<V8UnionBooleanOrString>>& value);
void setEchoCancellation(HeapVector<Member<V8UnionBooleanOrString>>&& value);

bool hasExposureCompensation() const {
  return has_exposure_compensation_;
}
MediaSettingsRange* exposureCompensation() const {
  DCHECK(hasExposureCompensation());
return member_exposure_compensation_.Get();
}
MediaSettingsRange* getExposureCompensationOr(MediaSettingsRange* fallback_value) const {
  if (!hasExposureCompensation()) {
  return fallback_value;
}
return member_exposure_compensation_.Get();
}
void setExposureCompensation(MediaSettingsRange* value) {
  member_exposure_compensation_ = value;
has_exposure_compensation_ = true;
DCHECK(member_exposure_compensation_);
}

bool hasExposureMode() const {
  return has_exposure_mode_;
}
const Vector<String>& exposureMode() const {
  DCHECK(hasExposureMode());
return member_exposure_mode_;
}
Vector<String> getExposureModeOr(const Vector<String>& fallback_value) const;
Vector<String> getExposureModeOr(Vector<String>&& fallback_value) const;
void setExposureMode(const Vector<String>& value);
void setExposureMode(Vector<String>&& value);

bool hasExposureTime() const {
  return has_exposure_time_;
}
MediaSettingsRange* exposureTime() const {
  DCHECK(hasExposureTime());
return member_exposure_time_.Get();
}
MediaSettingsRange* getExposureTimeOr(MediaSettingsRange* fallback_value) const {
  if (!hasExposureTime()) {
  return fallback_value;
}
return member_exposure_time_.Get();
}
void setExposureTime(MediaSettingsRange* value) {
  member_exposure_time_ = value;
has_exposure_time_ = true;
DCHECK(member_exposure_time_);
}

bool hasEyeGazeCorrection() const {
  return has_eye_gaze_correction_;
}
const Vector<bool>& eyeGazeCorrection() const {
  DCHECK(hasEyeGazeCorrection());
return member_eye_gaze_correction_;
}
Vector<bool> getEyeGazeCorrectionOr(const Vector<bool>& fallback_value) const;
Vector<bool> getEyeGazeCorrectionOr(Vector<bool>&& fallback_value) const;
void setEyeGazeCorrection(const Vector<bool>& value);
void setEyeGazeCorrection(Vector<bool>&& value);

bool hasFaceFraming() const {
  return has_face_framing_;
}
const Vector<bool>& faceFraming() const {
  DCHECK(hasFaceFraming());
return member_face_framing_;
}
Vector<bool> getFaceFramingOr(const Vector<bool>& fallback_value) const;
Vector<bool> getFaceFramingOr(Vector<bool>&& fallback_value) const;
void setFaceFraming(const Vector<bool>& value);
void setFaceFraming(Vector<bool>&& value);

bool hasFacingMode() const {
  return has_facing_mode_;
}
const Vector<String>& facingMode() const {
  DCHECK(hasFacingMode());
return member_facing_mode_;
}
Vector<String> getFacingModeOr(const Vector<String>& fallback_value) const;
Vector<String> getFacingModeOr(Vector<String>&& fallback_value) const;
void setFacingMode(const Vector<String>& value);
void setFacingMode(Vector<String>&& value);

bool hasFocusDistance() const {
  return has_focus_distance_;
}
MediaSettingsRange* focusDistance() const {
  DCHECK(hasFocusDistance());
return member_focus_distance_.Get();
}
MediaSettingsRange* getFocusDistanceOr(MediaSettingsRange* fallback_value) const {
  if (!hasFocusDistance()) {
  return fallback_value;
}
return member_focus_distance_.Get();
}
void setFocusDistance(MediaSettingsRange* value) {
  member_focus_distance_ = value;
has_focus_distance_ = true;
DCHECK(member_focus_distance_);
}

bool hasFocusMode() const {
  return has_focus_mode_;
}
const Vector<String>& focusMode() const {
  DCHECK(hasFocusMode());
return member_focus_mode_;
}
Vector<String> getFocusModeOr(const Vector<String>& fallback_value) const;
Vector<String> getFocusModeOr(Vector<String>&& fallback_value) const;
void setFocusMode(const Vector<String>& value);
void setFocusMode(Vector<String>&& value);

bool hasFrameRate() const {
  return has_frame_rate_;
}
DoubleRange* frameRate() const {
  DCHECK(hasFrameRate());
return member_frame_rate_.Get();
}
DoubleRange* getFrameRateOr(DoubleRange* fallback_value) const {
  if (!hasFrameRate()) {
  return fallback_value;
}
return member_frame_rate_.Get();
}
void setFrameRate(DoubleRange* value) {
  member_frame_rate_ = value;
has_frame_rate_ = true;
DCHECK(member_frame_rate_);
}

bool hasGroupId() const {
  return has_group_id_;
}
const String& groupId() const {
  DCHECK(hasGroupId());
return member_group_id_;
}
String getGroupIdOr(const String& fallback_value) const;
String getGroupIdOr(String&& fallback_value) const;
void setGroupId(const String& value);
void setGroupId(String&& value);

bool hasHeight() const {
  return has_height_;
}
LongRange* height() const {
  DCHECK(hasHeight());
return member_height_.Get();
}
LongRange* getHeightOr(LongRange* fallback_value) const {
  if (!hasHeight()) {
  return fallback_value;
}
return member_height_.Get();
}
void setHeight(LongRange* value) {
  member_height_ = value;
has_height_ = true;
DCHECK(member_height_);
}

bool hasIso() const {
  return has_iso_;
}
MediaSettingsRange* iso() const {
  DCHECK(hasIso());
return member_iso_.Get();
}
MediaSettingsRange* getIsoOr(MediaSettingsRange* fallback_value) const {
  if (!hasIso()) {
  return fallback_value;
}
return member_iso_.Get();
}
void setIso(MediaSettingsRange* value) {
  member_iso_ = value;
has_iso_ = true;
DCHECK(member_iso_);
}

bool hasLatency() const {
  return has_latency_;
}
DoubleRange* latency() const {
  DCHECK(hasLatency());
return member_latency_.Get();
}
DoubleRange* getLatencyOr(DoubleRange* fallback_value) const {
  if (!hasLatency()) {
  return fallback_value;
}
return member_latency_.Get();
}
void setLatency(DoubleRange* value) {
  member_latency_ = value;
has_latency_ = true;
DCHECK(member_latency_);
}

bool hasNoiseSuppression() const {
  return has_noise_suppression_;
}
const Vector<bool>& noiseSuppression() const {
  DCHECK(hasNoiseSuppression());
return member_noise_suppression_;
}
Vector<bool> getNoiseSuppressionOr(const Vector<bool>& fallback_value) const;
Vector<bool> getNoiseSuppressionOr(Vector<bool>&& fallback_value) const;
void setNoiseSuppression(const Vector<bool>& value);
void setNoiseSuppression(Vector<bool>&& value);

bool hasPan() const {
  return has_pan_;
}
MediaSettingsRange* pan() const {
  DCHECK(hasPan());
return member_pan_.Get();
}
MediaSettingsRange* getPanOr(MediaSettingsRange* fallback_value) const {
  if (!hasPan()) {
  return fallback_value;
}
return member_pan_.Get();
}
void setPan(MediaSettingsRange* value) {
  member_pan_ = value;
has_pan_ = true;
DCHECK(member_pan_);
}

bool hasResizeMode() const {
  return has_resize_mode_;
}
const Vector<String>& resizeMode() const {
  DCHECK(hasResizeMode());
return member_resize_mode_;
}
Vector<String> getResizeModeOr(const Vector<String>& fallback_value) const;
Vector<String> getResizeModeOr(Vector<String>&& fallback_value) const;
void setResizeMode(const Vector<String>& value);
void setResizeMode(Vector<String>&& value);

bool hasRestrictOwnAudio() const {
  return has_restrict_own_audio_;
}
const Vector<bool>& restrictOwnAudio() const {
  DCHECK(hasRestrictOwnAudio());
return member_restrict_own_audio_;
}
Vector<bool> getRestrictOwnAudioOr(const Vector<bool>& fallback_value) const;
Vector<bool> getRestrictOwnAudioOr(Vector<bool>&& fallback_value) const;
void setRestrictOwnAudio(const Vector<bool>& value);
void setRestrictOwnAudio(Vector<bool>&& value);

bool hasSampleRate() const {
  return has_sample_rate_;
}
LongRange* sampleRate() const {
  DCHECK(hasSampleRate());
return member_sample_rate_.Get();
}
LongRange* getSampleRateOr(LongRange* fallback_value) const {
  if (!hasSampleRate()) {
  return fallback_value;
}
return member_sample_rate_.Get();
}
void setSampleRate(LongRange* value) {
  member_sample_rate_ = value;
has_sample_rate_ = true;
DCHECK(member_sample_rate_);
}

bool hasSampleSize() const {
  return has_sample_size_;
}
LongRange* sampleSize() const {
  DCHECK(hasSampleSize());
return member_sample_size_.Get();
}
LongRange* getSampleSizeOr(LongRange* fallback_value) const {
  if (!hasSampleSize()) {
  return fallback_value;
}
return member_sample_size_.Get();
}
void setSampleSize(LongRange* value) {
  member_sample_size_ = value;
has_sample_size_ = true;
DCHECK(member_sample_size_);
}

bool hasSaturation() const {
  return has_saturation_;
}
MediaSettingsRange* saturation() const {
  DCHECK(hasSaturation());
return member_saturation_.Get();
}
MediaSettingsRange* getSaturationOr(MediaSettingsRange* fallback_value) const {
  if (!hasSaturation()) {
  return fallback_value;
}
return member_saturation_.Get();
}
void setSaturation(MediaSettingsRange* value) {
  member_saturation_ = value;
has_saturation_ = true;
DCHECK(member_saturation_);
}

bool hasSharpness() const {
  return has_sharpness_;
}
MediaSettingsRange* sharpness() const {
  DCHECK(hasSharpness());
return member_sharpness_.Get();
}
MediaSettingsRange* getSharpnessOr(MediaSettingsRange* fallback_value) const {
  if (!hasSharpness()) {
  return fallback_value;
}
return member_sharpness_.Get();
}
void setSharpness(MediaSettingsRange* value) {
  member_sharpness_ = value;
has_sharpness_ = true;
DCHECK(member_sharpness_);
}

bool hasTilt() const {
  return has_tilt_;
}
MediaSettingsRange* tilt() const {
  DCHECK(hasTilt());
return member_tilt_.Get();
}
MediaSettingsRange* getTiltOr(MediaSettingsRange* fallback_value) const {
  if (!hasTilt()) {
  return fallback_value;
}
return member_tilt_.Get();
}
void setTilt(MediaSettingsRange* value) {
  member_tilt_ = value;
has_tilt_ = true;
DCHECK(member_tilt_);
}

bool hasTorch() const {
  return has_torch_;
}
bool torch() const {
  DCHECK(hasTorch());
return member_torch_;
}
bool getTorchOr(bool fallback_value) const {
  if (!hasTorch()) {
  return fallback_value;
}
return member_torch_;
}
void setTorch(bool value) {
  member_torch_ = value;
has_torch_ = true;
}

bool hasVoiceIsolation() const {
  return has_voice_isolation_;
}
const Vector<bool>& voiceIsolation() const {
  DCHECK(hasVoiceIsolation());
return member_voice_isolation_;
}
Vector<bool> getVoiceIsolationOr(const Vector<bool>& fallback_value) const;
Vector<bool> getVoiceIsolationOr(Vector<bool>&& fallback_value) const;
void setVoiceIsolation(const Vector<bool>& value);
void setVoiceIsolation(Vector<bool>&& value);

bool hasWhiteBalanceMode() const {
  return has_white_balance_mode_;
}
const Vector<String>& whiteBalanceMode() const {
  DCHECK(hasWhiteBalanceMode());
return member_white_balance_mode_;
}
Vector<String> getWhiteBalanceModeOr(const Vector<String>& fallback_value) const;
Vector<String> getWhiteBalanceModeOr(Vector<String>&& fallback_value) const;
void setWhiteBalanceMode(const Vector<String>& value);
void setWhiteBalanceMode(Vector<String>&& value);

bool hasWidth() const {
  return has_width_;
}
LongRange* width() const {
  DCHECK(hasWidth());
return member_width_.Get();
}
LongRange* getWidthOr(LongRange* fallback_value) const {
  if (!hasWidth()) {
  return fallback_value;
}
return member_width_.Get();
}
void setWidth(LongRange* value) {
  member_width_ = value;
has_width_ = true;
DCHECK(member_width_);
}

bool hasZoom() const {
  return has_zoom_;
}
MediaSettingsRange* zoom() const {
  DCHECK(hasZoom());
return member_zoom_.Get();
}
MediaSettingsRange* getZoomOr(MediaSettingsRange* fallback_value) const {
  if (!hasZoom()) {
  return fallback_value;
}
return member_zoom_.Get();
}
void setZoom(MediaSettingsRange* value) {
  member_zoom_ = value;
has_zoom_ = true;
DCHECK(member_zoom_);
}




void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 38;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillTemplateProperties(Vector<std::string_view>& properties) const override;
void FillValuesImpl(ScriptState* script_state, base::span<v8::MaybeLocal<v8::Value>> values) const;


void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
const void* TemplateKey() const override;
v8::Local<v8::Object> FillValues(ScriptState* script_state, v8::Local<v8::DictionaryTemplate> dict_template) const override;
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_aspect_ratio_ = false;
bool has_auto_gain_control_ = false;
bool has_background_blur_ = false;
bool has_background_segmentation_mask_ = false;
bool has_brightness_ = false;
bool has_channel_count_ = false;
bool has_color_temperature_ = false;
bool has_contrast_ = false;
bool has_device_id_ = false;
bool has_display_surface_ = false;
bool has_echo_cancellation_ = false;
bool has_exposure_compensation_ = false;
bool has_exposure_mode_ = false;
bool has_exposure_time_ = false;
bool has_eye_gaze_correction_ = false;
bool has_face_framing_ = false;
bool has_facing_mode_ = false;
bool has_focus_distance_ = false;
bool has_focus_mode_ = false;
bool has_frame_rate_ = false;
bool has_group_id_ = false;
bool has_height_ = false;
bool has_iso_ = false;
bool has_latency_ = false;
bool has_noise_suppression_ = false;
bool has_pan_ = false;
bool has_resize_mode_ = false;
bool has_restrict_own_audio_ = false;
bool has_sample_rate_ = false;
bool has_sample_size_ = false;
bool has_saturation_ = false;
bool has_sharpness_ = false;
bool has_tilt_ = false;
bool has_torch_ = false;
bool has_voice_isolation_ = false;
bool has_white_balance_mode_ = false;
bool has_width_ = false;
bool has_zoom_ = false;

Member<DoubleRange> member_aspect_ratio_;
Vector<bool> member_auto_gain_control_;
Vector<bool> member_background_blur_;
Vector<bool> member_background_segmentation_mask_;
Member<MediaSettingsRange> member_brightness_;
Member<LongRange> member_channel_count_;
Member<MediaSettingsRange> member_color_temperature_;
Member<MediaSettingsRange> member_contrast_;
String member_device_id_;
String member_display_surface_;
HeapVector<Member<V8UnionBooleanOrString>> member_echo_cancellation_;
Member<MediaSettingsRange> member_exposure_compensation_;
Vector<String> member_exposure_mode_;
Member<MediaSettingsRange> member_exposure_time_;
Vector<bool> member_eye_gaze_correction_;
Vector<bool> member_face_framing_;
Vector<String> member_facing_mode_;
Member<MediaSettingsRange> member_focus_distance_;
Vector<String> member_focus_mode_;
Member<DoubleRange> member_frame_rate_;
String member_group_id_;
Member<LongRange> member_height_;
Member<MediaSettingsRange> member_iso_;
Member<DoubleRange> member_latency_;
Vector<bool> member_noise_suppression_;
Member<MediaSettingsRange> member_pan_;
Vector<String> member_resize_mode_;
Vector<bool> member_restrict_own_audio_;
Member<LongRange> member_sample_rate_;
Member<LongRange> member_sample_size_;
Member<MediaSettingsRange> member_saturation_;
Member<MediaSettingsRange> member_sharpness_;
Member<MediaSettingsRange> member_tilt_;
bool member_torch_;
Vector<bool> member_voice_isolation_;
Vector<String> member_white_balance_mode_;
Member<LongRange> member_width_;
Member<MediaSettingsRange> member_zoom_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_MEDIA_TRACK_CAPABILITIES_H_
