// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_MEDIA_SESSION_ENTER_PICTURE_IN_PICTURE_ACTION_DETAILS_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_MEDIA_SESSION_ENTER_PICTURE_IN_PICTURE_ACTION_DETAILS_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_media_session_action_details.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_media_session_enter_picture_in_picture_reason.h"
#include "third_party/blink/renderer/modules/modules_export.h"

namespace blink {

class ExceptionState;

class MODULES_EXPORT MediaSessionEnterPictureInPictureActionDetails : public MediaSessionActionDetails {
  
  public:
static MediaSessionEnterPictureInPictureActionDetails* Create() {
  return MakeGarbageCollected<MediaSessionEnterPictureInPictureActionDetails>();
}
static MediaSessionEnterPictureInPictureActionDetails* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<MediaSessionEnterPictureInPictureActionDetails>(isolate);
}
static MediaSessionEnterPictureInPictureActionDetails* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  MediaSessionEnterPictureInPictureActionDetails();
explicit  MediaSessionEnterPictureInPictureActionDetails(v8::Isolate* isolate);

bool hasEnterPictureInPictureReason() const {
  return has_enter_picture_in_picture_reason_;
}
V8MediaSessionEnterPictureInPictureReason enterPictureInPictureReason() const {
  DCHECK(hasEnterPictureInPictureReason());
return member_enter_picture_in_picture_reason_;
}
V8MediaSessionEnterPictureInPictureReason getEnterPictureInPictureReasonOr(V8MediaSessionEnterPictureInPictureReason fallback_value) const {
  if (!hasEnterPictureInPictureReason()) {
  return fallback_value;
}
return member_enter_picture_in_picture_reason_;
}
void setEnterPictureInPictureReason(V8MediaSessionEnterPictureInPictureReason value) {
  member_enter_picture_in_picture_reason_ = value;
has_enter_picture_in_picture_reason_ = true;
}
void setEnterPictureInPictureReason(V8MediaSessionEnterPictureInPictureReason::Enum value) {
  member_enter_picture_in_picture_reason_ = V8MediaSessionEnterPictureInPictureReason(value);
has_enter_picture_in_picture_reason_ = true;
}




void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = MediaSessionActionDetails::kTotalPropertyCount;
static constexpr size_t kOwnPropertyCount = 1;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillTemplateProperties(Vector<std::string_view>& properties) const override;
void FillValuesImpl(ScriptState* script_state, base::span<v8::MaybeLocal<v8::Value>> values) const;


void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
const void* TemplateKey() const override;
v8::Local<v8::Object> FillValues(ScriptState* script_state, v8::Local<v8::DictionaryTemplate> dict_template) const override;
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_enter_picture_in_picture_reason_ = false;

V8MediaSessionEnterPictureInPictureReason member_enter_picture_in_picture_reason_{static_cast<V8MediaSessionEnterPictureInPictureReason::Enum>(0)};


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_MEDIA_SESSION_ENTER_PICTURE_IN_PICTURE_ACTION_DETAILS_H_
