// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_MEDIA_CAPABILITIES_KEY_SYSTEM_CONFIGURATION_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_MEDIA_CAPABILITIES_KEY_SYSTEM_CONFIGURATION_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_media_keys_requirement.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"
#include "third_party/blink/renderer/platform/heap/collection_support/heap_vector.h"
#include "third_party/blink/renderer/platform/heap/member.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

namespace blink {

class ExceptionState;
class KeySystemTrackConfiguration;

class MODULES_EXPORT MediaCapabilitiesKeySystemConfiguration : public bindings::InputDictionaryBase {
  
  public:
static MediaCapabilitiesKeySystemConfiguration* Create() {
  return MakeGarbageCollected<MediaCapabilitiesKeySystemConfiguration>();
}
static MediaCapabilitiesKeySystemConfiguration* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<MediaCapabilitiesKeySystemConfiguration>(isolate);
}
static MediaCapabilitiesKeySystemConfiguration* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  MediaCapabilitiesKeySystemConfiguration();
explicit  MediaCapabilitiesKeySystemConfiguration(v8::Isolate* isolate);

bool hasAudio() const {
  return has_audio_;
}
KeySystemTrackConfiguration* audio() const {
  DCHECK(hasAudio());
return member_audio_.Get();
}
KeySystemTrackConfiguration* getAudioOr(KeySystemTrackConfiguration* fallback_value) const {
  if (!hasAudio()) {
  return fallback_value;
}
return member_audio_.Get();
}
void setAudio(KeySystemTrackConfiguration* value) {
  member_audio_ = value;
has_audio_ = true;
DCHECK(member_audio_);
}

bool hasDistinctiveIdentifier() const {
  return true;
}
V8MediaKeysRequirement distinctiveIdentifier() const {
  return member_distinctive_identifier_;
}
void setDistinctiveIdentifier(V8MediaKeysRequirement value) {
  member_distinctive_identifier_ = value;
}
void setDistinctiveIdentifier(V8MediaKeysRequirement::Enum value) {
  member_distinctive_identifier_ = V8MediaKeysRequirement(value);
}

bool hasInitDataType() const {
  return true;
}
const String& initDataType() const {
  return member_init_data_type_;
}
void setInitDataType(const String& value);
void setInitDataType(String&& value);

bool hasKeySystem() const {
  return true;
}
const String& keySystem() const {
  return member_key_system_;
}
void setKeySystem(const String& value);
void setKeySystem(String&& value);

bool hasPersistentState() const {
  return true;
}
V8MediaKeysRequirement persistentState() const {
  return member_persistent_state_;
}
void setPersistentState(V8MediaKeysRequirement value) {
  member_persistent_state_ = value;
}
void setPersistentState(V8MediaKeysRequirement::Enum value) {
  member_persistent_state_ = V8MediaKeysRequirement(value);
}

bool hasSessionTypes() const {
  return has_session_types_;
}
const Vector<String>& sessionTypes() const {
  DCHECK(hasSessionTypes());
return member_session_types_;
}
Vector<String> getSessionTypesOr(const Vector<String>& fallback_value) const;
Vector<String> getSessionTypesOr(Vector<String>&& fallback_value) const;
void setSessionTypes(const Vector<String>& value);
void setSessionTypes(Vector<String>&& value);

bool hasVideo() const {
  return has_video_;
}
KeySystemTrackConfiguration* video() const {
  DCHECK(hasVideo());
return member_video_.Get();
}
KeySystemTrackConfiguration* getVideoOr(KeySystemTrackConfiguration* fallback_value) const {
  if (!hasVideo()) {
  return fallback_value;
}
return member_video_.Get();
}
void setVideo(KeySystemTrackConfiguration* value) {
  member_video_ = value;
has_video_ = true;
DCHECK(member_video_);
}




void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 7;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_audio_ = false;
bool has_session_types_ = false;
bool has_video_ = false;

Member<KeySystemTrackConfiguration> member_audio_;
V8MediaKeysRequirement member_distinctive_identifier_{V8MediaKeysRequirement::Enum::kOptional};
String member_init_data_type_{""};
String member_key_system_;
V8MediaKeysRequirement member_persistent_state_{V8MediaKeysRequirement::Enum::kOptional};
Vector<String> member_session_types_;
Member<KeySystemTrackConfiguration> member_video_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_MEDIA_CAPABILITIES_KEY_SYSTEM_CONFIGURATION_H_
