// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#include "third_party/blink/renderer/bindings/modules/v8/v8_layout_worklet_global_scope.h"

#include "third_party/blink/public/mojom/origin_trials/origin_trial_feature.mojom-shared.h"
#include "third_party/blink/renderer/bindings/core/v8/generated_code_helper.h"
#include "third_party/blink/renderer/bindings/core/v8/is_return_type_compatible.h"
#include "third_party/blink/renderer/bindings/core/v8/native_value_traits_impl.h"
#include "third_party/blink/renderer/bindings/core/v8/to_v8_traits.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_byte_length_queuing_strategy.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_count_queuing_strategy.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_css_color_value.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_css_hsl.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_css_hwb.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_css_image_value.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_css_keyword_value.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_css_math_clamp.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_css_math_invert.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_css_math_max.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_css_math_min.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_css_math_negate.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_css_math_product.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_css_math_sum.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_css_math_value.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_css_matrix_component.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_css_numeric_array.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_css_numeric_value.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_css_perspective.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_css_position_value.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_css_rgb.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_css_rotate.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_css_scale.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_css_skew.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_css_skew_x.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_css_skew_y.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_css_style_value.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_css_transform_component.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_css_transform_value.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_css_translate.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_css_unit_value.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_css_unparsed_value.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_css_variable_reference_value.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_intrinsic_sizes.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_layout_child.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_layout_constraints.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_layout_edges.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_layout_fragment.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_no_argument_constructor.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_quota_exceeded_error.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_readable_byte_stream_controller.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_readable_stream.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_readable_stream_byob_reader.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_readable_stream_byob_request.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_readable_stream_default_controller.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_readable_stream_default_reader.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_set_return_value_for_core.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_style_property_map_read_only.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_transform_stream.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_transform_stream_default_controller.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_worklet_global_scope.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_writable_stream.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_writable_stream_default_controller.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_writable_stream_default_writer.h"
#include "third_party/blink/renderer/core/layout/custom/layout_worklet_global_scope.h"
#include "third_party/blink/renderer/platform/bindings/exception_messages.h"
#include "third_party/blink/renderer/platform/bindings/idl_member_installer.h"
#include "third_party/blink/renderer/platform/bindings/runtime_call_stats.h"
#include "third_party/blink/renderer/platform/bindings/v8_binding.h"

namespace blink {



void V8LayoutWorkletGlobalScope::Impl::Init() {
  V8LayoutWorkletGlobalScope::install_interface_template_func_ = InstallInterfaceTemplate;
V8LayoutWorkletGlobalScope::install_unconditional_props_func_ = InstallUnconditionalProperties;
V8LayoutWorkletGlobalScope::install_context_independent_props_func_ = InstallContextIndependentProperties;
}

namespace  {

namespace v8_layout_worklet_global_scope {

void ByteLengthQueuingStrategyExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_LayoutWorkletGlobalScope_ByteLengthQueuingStrategy_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("LayoutWorkletGlobalScope.ByteLengthQueuingStrategy");

bindings::V8SetReturnValue(info, V8ByteLengthQueuingStrategy::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void CSSColorValueExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_LayoutWorkletGlobalScope_CSSColorValue_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("LayoutWorkletGlobalScope.CSSColorValue");

bindings::V8SetReturnValue(info, V8CSSColorValue::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void CSSHSLExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_LayoutWorkletGlobalScope_CSSHSL_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("LayoutWorkletGlobalScope.CSSHSL");

bindings::V8SetReturnValue(info, V8CSSHSL::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void CSSHWBExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_LayoutWorkletGlobalScope_CSSHWB_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("LayoutWorkletGlobalScope.CSSHWB");

bindings::V8SetReturnValue(info, V8CSSHWB::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void CSSImageValueExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_LayoutWorkletGlobalScope_CSSImageValue_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("LayoutWorkletGlobalScope.CSSImageValue");

bindings::V8SetReturnValue(info, V8CSSImageValue::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void CSSKeywordValueExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_LayoutWorkletGlobalScope_CSSKeywordValue_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("LayoutWorkletGlobalScope.CSSKeywordValue");

bindings::V8SetReturnValue(info, V8CSSKeywordValue::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void CSSMathClampExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_LayoutWorkletGlobalScope_CSSMathClamp_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("LayoutWorkletGlobalScope.CSSMathClamp");

bindings::V8SetReturnValue(info, V8CSSMathClamp::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void CSSMathInvertExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_LayoutWorkletGlobalScope_CSSMathInvert_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("LayoutWorkletGlobalScope.CSSMathInvert");

bindings::V8SetReturnValue(info, V8CSSMathInvert::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void CSSMathMaxExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_LayoutWorkletGlobalScope_CSSMathMax_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("LayoutWorkletGlobalScope.CSSMathMax");

bindings::V8SetReturnValue(info, V8CSSMathMax::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void CSSMathMinExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_LayoutWorkletGlobalScope_CSSMathMin_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("LayoutWorkletGlobalScope.CSSMathMin");

bindings::V8SetReturnValue(info, V8CSSMathMin::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void CSSMathNegateExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_LayoutWorkletGlobalScope_CSSMathNegate_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("LayoutWorkletGlobalScope.CSSMathNegate");

bindings::V8SetReturnValue(info, V8CSSMathNegate::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void CSSMathProductExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_LayoutWorkletGlobalScope_CSSMathProduct_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("LayoutWorkletGlobalScope.CSSMathProduct");

bindings::V8SetReturnValue(info, V8CSSMathProduct::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void CSSMathSumExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_LayoutWorkletGlobalScope_CSSMathSum_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("LayoutWorkletGlobalScope.CSSMathSum");

bindings::V8SetReturnValue(info, V8CSSMathSum::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void CSSMathValueExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_LayoutWorkletGlobalScope_CSSMathValue_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("LayoutWorkletGlobalScope.CSSMathValue");

bindings::V8SetReturnValue(info, V8CSSMathValue::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void CSSMatrixComponentExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_LayoutWorkletGlobalScope_CSSMatrixComponent_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("LayoutWorkletGlobalScope.CSSMatrixComponent");

bindings::V8SetReturnValue(info, V8CSSMatrixComponent::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void CSSNumericArrayExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_LayoutWorkletGlobalScope_CSSNumericArray_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("LayoutWorkletGlobalScope.CSSNumericArray");

bindings::V8SetReturnValue(info, V8CSSNumericArray::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void CSSNumericValueExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_LayoutWorkletGlobalScope_CSSNumericValue_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("LayoutWorkletGlobalScope.CSSNumericValue");

bindings::V8SetReturnValue(info, V8CSSNumericValue::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void CSSPerspectiveExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_LayoutWorkletGlobalScope_CSSPerspective_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("LayoutWorkletGlobalScope.CSSPerspective");

bindings::V8SetReturnValue(info, V8CSSPerspective::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void CSSPositionValueExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_LayoutWorkletGlobalScope_CSSPositionValue_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("LayoutWorkletGlobalScope.CSSPositionValue");

bindings::V8SetReturnValue(info, V8CSSPositionValue::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void CSSRGBExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_LayoutWorkletGlobalScope_CSSRGB_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("LayoutWorkletGlobalScope.CSSRGB");

bindings::V8SetReturnValue(info, V8CSSRGB::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void CSSRotateExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_LayoutWorkletGlobalScope_CSSRotate_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("LayoutWorkletGlobalScope.CSSRotate");

bindings::V8SetReturnValue(info, V8CSSRotate::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void CSSScaleExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_LayoutWorkletGlobalScope_CSSScale_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("LayoutWorkletGlobalScope.CSSScale");

bindings::V8SetReturnValue(info, V8CSSScale::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void CSSSkewExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_LayoutWorkletGlobalScope_CSSSkew_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("LayoutWorkletGlobalScope.CSSSkew");

bindings::V8SetReturnValue(info, V8CSSSkew::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void CSSSkewXExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_LayoutWorkletGlobalScope_CSSSkewX_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("LayoutWorkletGlobalScope.CSSSkewX");

bindings::V8SetReturnValue(info, V8CSSSkewX::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void CSSSkewYExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_LayoutWorkletGlobalScope_CSSSkewY_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("LayoutWorkletGlobalScope.CSSSkewY");

bindings::V8SetReturnValue(info, V8CSSSkewY::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void CSSStyleValueExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_LayoutWorkletGlobalScope_CSSStyleValue_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("LayoutWorkletGlobalScope.CSSStyleValue");

bindings::V8SetReturnValue(info, V8CSSStyleValue::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void CSSTransformComponentExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_LayoutWorkletGlobalScope_CSSTransformComponent_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("LayoutWorkletGlobalScope.CSSTransformComponent");

bindings::V8SetReturnValue(info, V8CSSTransformComponent::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void CSSTransformValueExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_LayoutWorkletGlobalScope_CSSTransformValue_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("LayoutWorkletGlobalScope.CSSTransformValue");

bindings::V8SetReturnValue(info, V8CSSTransformValue::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void CSSTranslateExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_LayoutWorkletGlobalScope_CSSTranslate_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("LayoutWorkletGlobalScope.CSSTranslate");

bindings::V8SetReturnValue(info, V8CSSTranslate::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void CSSUnitValueExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_LayoutWorkletGlobalScope_CSSUnitValue_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("LayoutWorkletGlobalScope.CSSUnitValue");

bindings::V8SetReturnValue(info, V8CSSUnitValue::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void CSSUnparsedValueExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_LayoutWorkletGlobalScope_CSSUnparsedValue_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("LayoutWorkletGlobalScope.CSSUnparsedValue");

bindings::V8SetReturnValue(info, V8CSSUnparsedValue::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void CSSVariableReferenceValueExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_LayoutWorkletGlobalScope_CSSVariableReferenceValue_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("LayoutWorkletGlobalScope.CSSVariableReferenceValue");

bindings::V8SetReturnValue(info, V8CSSVariableReferenceValue::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void CountQueuingStrategyExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_LayoutWorkletGlobalScope_CountQueuingStrategy_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("LayoutWorkletGlobalScope.CountQueuingStrategy");

bindings::V8SetReturnValue(info, V8CountQueuingStrategy::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void IntrinsicSizesExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_LayoutWorkletGlobalScope_IntrinsicSizes_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("LayoutWorkletGlobalScope.IntrinsicSizes");

bindings::V8SetReturnValue(info, V8IntrinsicSizes::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void LayoutChildExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_LayoutWorkletGlobalScope_LayoutChild_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("LayoutWorkletGlobalScope.LayoutChild");

bindings::V8SetReturnValue(info, V8LayoutChild::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void LayoutConstraintsExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_LayoutWorkletGlobalScope_LayoutConstraints_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("LayoutWorkletGlobalScope.LayoutConstraints");

bindings::V8SetReturnValue(info, V8LayoutConstraints::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void LayoutEdgesExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_LayoutWorkletGlobalScope_LayoutEdges_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("LayoutWorkletGlobalScope.LayoutEdges");

bindings::V8SetReturnValue(info, V8LayoutEdges::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void LayoutFragmentExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_LayoutWorkletGlobalScope_LayoutFragment_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("LayoutWorkletGlobalScope.LayoutFragment");

bindings::V8SetReturnValue(info, V8LayoutFragment::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void LayoutWorkletGlobalScopeExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_LayoutWorkletGlobalScope_LayoutWorkletGlobalScope_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("LayoutWorkletGlobalScope.LayoutWorkletGlobalScope");

bindings::V8SetReturnValue(info, V8LayoutWorkletGlobalScope::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void QuotaExceededErrorExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_LayoutWorkletGlobalScope_QuotaExceededError_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("LayoutWorkletGlobalScope.QuotaExceededError");

bindings::V8SetReturnValue(info, V8QuotaExceededError::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void ReadableByteStreamControllerExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_LayoutWorkletGlobalScope_ReadableByteStreamController_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("LayoutWorkletGlobalScope.ReadableByteStreamController");

bindings::V8SetReturnValue(info, V8ReadableByteStreamController::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void ReadableStreamExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_LayoutWorkletGlobalScope_ReadableStream_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("LayoutWorkletGlobalScope.ReadableStream");

bindings::V8SetReturnValue(info, V8ReadableStream::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void ReadableStreamBYOBReaderExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_LayoutWorkletGlobalScope_ReadableStreamBYOBReader_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("LayoutWorkletGlobalScope.ReadableStreamBYOBReader");

bindings::V8SetReturnValue(info, V8ReadableStreamBYOBReader::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void ReadableStreamBYOBRequestExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_LayoutWorkletGlobalScope_ReadableStreamBYOBRequest_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("LayoutWorkletGlobalScope.ReadableStreamBYOBRequest");

bindings::V8SetReturnValue(info, V8ReadableStreamBYOBRequest::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void ReadableStreamDefaultControllerExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_LayoutWorkletGlobalScope_ReadableStreamDefaultController_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("LayoutWorkletGlobalScope.ReadableStreamDefaultController");

bindings::V8SetReturnValue(info, V8ReadableStreamDefaultController::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void ReadableStreamDefaultReaderExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_LayoutWorkletGlobalScope_ReadableStreamDefaultReader_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("LayoutWorkletGlobalScope.ReadableStreamDefaultReader");

bindings::V8SetReturnValue(info, V8ReadableStreamDefaultReader::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void StylePropertyMapReadOnlyExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_LayoutWorkletGlobalScope_StylePropertyMapReadOnly_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("LayoutWorkletGlobalScope.StylePropertyMapReadOnly");

bindings::V8SetReturnValue(info, V8StylePropertyMapReadOnly::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void TransformStreamExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_LayoutWorkletGlobalScope_TransformStream_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("LayoutWorkletGlobalScope.TransformStream");

bindings::V8SetReturnValue(info, V8TransformStream::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void TransformStreamDefaultControllerExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_LayoutWorkletGlobalScope_TransformStreamDefaultController_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("LayoutWorkletGlobalScope.TransformStreamDefaultController");

bindings::V8SetReturnValue(info, V8TransformStreamDefaultController::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void WorkletGlobalScopeExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_LayoutWorkletGlobalScope_WorkletGlobalScope_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("LayoutWorkletGlobalScope.WorkletGlobalScope");

bindings::V8SetReturnValue(info, V8WorkletGlobalScope::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void WritableStreamExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_LayoutWorkletGlobalScope_WritableStream_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("LayoutWorkletGlobalScope.WritableStream");

bindings::V8SetReturnValue(info, V8WritableStream::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void WritableStreamDefaultControllerExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_LayoutWorkletGlobalScope_WritableStreamDefaultController_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("LayoutWorkletGlobalScope.WritableStreamDefaultController");

bindings::V8SetReturnValue(info, V8WritableStreamDefaultController::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void WritableStreamDefaultWriterExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_LayoutWorkletGlobalScope_WritableStreamDefaultWriter_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("LayoutWorkletGlobalScope.WritableStreamDefaultWriter");

bindings::V8SetReturnValue(info, V8WritableStreamDefaultWriter::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void RegisterLayoutOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_LayoutWorkletGlobalScope_registerLayout");
BLINK_BINDINGS_TRACE_EVENT("LayoutWorkletGlobalScope.registerLayout");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 2) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(2, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
LayoutWorkletGlobalScope* blink_receiver = V8LayoutWorkletGlobalScope::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_name = NativeValueTraits<IDLString>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_layout_ctor = NativeValueTraits<V8NoArgumentConstructor>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->registerLayout(arg1_name, arg2_layout_ctor, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}

}


}  // namespace v8_layout_worklet_global_scope

using namespace v8_layout_worklet_global_scope;

}  // namespace 

void V8LayoutWorkletGlobalScope::Impl::InstallInterfaceTemplate(v8::Isolate* isolate, const DOMWrapperWorld& world, v8::Local<v8::Template> interface_template) {
  const WrapperTypeInfo* const wrapper_type_info = V8LayoutWorkletGlobalScope::GetWrapperTypeInfo();
v8::Local<v8::FunctionTemplate> interface_function_template = interface_template.As<v8::FunctionTemplate>();
v8::Local<v8::ObjectTemplate> instance_template = interface_function_template->InstanceTemplate();
v8::Local<v8::ObjectTemplate> prototype_template = interface_function_template->PrototypeTemplate();
v8::Local<v8::FunctionTemplate> parent_interface_template = wrapper_type_info->parent_class->GetV8ClassTemplate(isolate, world).As<v8::FunctionTemplate>();
bindings::SetupIDLInterfaceTemplate(isolate, wrapper_type_info, instance_template, prototype_template, interface_function_template, parent_interface_template);






// [Global]
// 3.7.1. [[SetPrototypeOf]]
// https://webidl.spec.whatwg.org/#platform-object-setprototypeof
instance_template->SetImmutableProto();
prototype_template->SetImmutableProto();

InstallUnconditionalProperties(isolate, world, instance_template, prototype_template, interface_template);
InstallContextIndependentProperties(isolate, world, instance_template, prototype_template, interface_template);
}

void V8LayoutWorkletGlobalScope::Impl::InstallUnconditionalProperties(v8::Isolate* isolate, const DOMWrapperWorld& world, v8::Local<v8::ObjectTemplate> instance_template, v8::Local<v8::ObjectTemplate> prototype_template, v8::Local<v8::Template> interface_template) {
  using bindings::IDLMemberInstaller;




v8::Local<v8::Signature> signature = v8::Local<v8::Signature>::Cast(interface_template);
{
  static const IDLMemberInstaller::ExposedConstructConfig kExposedConstructTable[] = {
{"ByteLengthQueuingStrategy", ByteLengthQueuingStrategyExposedConstructCallback}, 
{"CSSImageValue", CSSImageValueExposedConstructCallback}, 
{"CSSKeywordValue", CSSKeywordValueExposedConstructCallback}, 
{"CSSMathClamp", CSSMathClampExposedConstructCallback}, 
{"CSSMathInvert", CSSMathInvertExposedConstructCallback}, 
{"CSSMathMax", CSSMathMaxExposedConstructCallback}, 
{"CSSMathMin", CSSMathMinExposedConstructCallback}, 
{"CSSMathNegate", CSSMathNegateExposedConstructCallback}, 
{"CSSMathProduct", CSSMathProductExposedConstructCallback}, 
{"CSSMathSum", CSSMathSumExposedConstructCallback}, 
{"CSSMathValue", CSSMathValueExposedConstructCallback}, 
{"CSSMatrixComponent", CSSMatrixComponentExposedConstructCallback}, 
{"CSSNumericArray", CSSNumericArrayExposedConstructCallback}, 
{"CSSNumericValue", CSSNumericValueExposedConstructCallback}, 
{"CSSPerspective", CSSPerspectiveExposedConstructCallback}, 
{"CSSPositionValue", CSSPositionValueExposedConstructCallback}, 
{"CSSRotate", CSSRotateExposedConstructCallback}, 
{"CSSScale", CSSScaleExposedConstructCallback}, 
{"CSSSkew", CSSSkewExposedConstructCallback}, 
{"CSSSkewX", CSSSkewXExposedConstructCallback}, 
{"CSSSkewY", CSSSkewYExposedConstructCallback}, 
{"CSSStyleValue", CSSStyleValueExposedConstructCallback}, 
{"CSSTransformComponent", CSSTransformComponentExposedConstructCallback}, 
{"CSSTransformValue", CSSTransformValueExposedConstructCallback}, 
{"CSSTranslate", CSSTranslateExposedConstructCallback}, 
{"CSSUnitValue", CSSUnitValueExposedConstructCallback}, 
{"CSSUnparsedValue", CSSUnparsedValueExposedConstructCallback}, 
{"CSSVariableReferenceValue", CSSVariableReferenceValueExposedConstructCallback}, 
{"CountQueuingStrategy", CountQueuingStrategyExposedConstructCallback}, 
{"ReadableByteStreamController", ReadableByteStreamControllerExposedConstructCallback}, 
{"ReadableStream", ReadableStreamExposedConstructCallback}, 
{"ReadableStreamBYOBReader", ReadableStreamBYOBReaderExposedConstructCallback}, 
{"ReadableStreamBYOBRequest", ReadableStreamBYOBRequestExposedConstructCallback}, 
{"ReadableStreamDefaultController", ReadableStreamDefaultControllerExposedConstructCallback}, 
{"ReadableStreamDefaultReader", ReadableStreamDefaultReaderExposedConstructCallback}, 
{"StylePropertyMapReadOnly", StylePropertyMapReadOnlyExposedConstructCallback}, 
{"TransformStream", TransformStreamExposedConstructCallback}, 
{"TransformStreamDefaultController", TransformStreamDefaultControllerExposedConstructCallback}, 
{"WorkletGlobalScope", WorkletGlobalScopeExposedConstructCallback}, 
{"WritableStream", WritableStreamExposedConstructCallback}, 
{"WritableStreamDefaultController", WritableStreamDefaultControllerExposedConstructCallback}, 
{"WritableStreamDefaultWriter", WritableStreamDefaultWriterExposedConstructCallback}, 
};
IDLMemberInstaller::InstallExposedConstructs(isolate, world, instance_template, prototype_template, interface_template, signature, kExposedConstructTable);
}


{
  static const IDLMemberInstaller::OperationConfig kOperationTable[] = {
{"registerLayout", RegisterLayoutOperationCallback, 2, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kInstance), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
};
IDLMemberInstaller::InstallOperations(isolate, world, instance_template, prototype_template, interface_template, signature, "LayoutWorkletGlobalScope", kOperationTable);
}



}

void V8LayoutWorkletGlobalScope::Impl::InstallContextIndependentProperties(v8::Isolate* isolate, const DOMWrapperWorld& world, v8::Local<v8::ObjectTemplate> instance_template, v8::Local<v8::ObjectTemplate> prototype_template, v8::Local<v8::Template> interface_template) {
  using bindings::IDLMemberInstaller;




v8::Local<v8::Signature> signature = v8::Local<v8::Signature>::Cast(interface_template);
if (RuntimeEnabledFeatures::CSSColorTypedOMEnabled()) {
  static const IDLMemberInstaller::ExposedConstructConfig kExposedConstructTable[] = {
{"CSSColorValue", CSSColorValueExposedConstructCallback}, 
{"CSSHSL", CSSHSLExposedConstructCallback}, 
{"CSSHWB", CSSHWBExposedConstructCallback}, 
{"CSSRGB", CSSRGBExposedConstructCallback}, 
};
IDLMemberInstaller::InstallExposedConstructs(isolate, world, instance_template, prototype_template, interface_template, signature, kExposedConstructTable);
}
if (RuntimeEnabledFeatures::CSSLayoutAPIEnabled()) {
  static const IDLMemberInstaller::ExposedConstructConfig kExposedConstructTable[] = {
{"IntrinsicSizes", IntrinsicSizesExposedConstructCallback}, 
{"LayoutChild", LayoutChildExposedConstructCallback}, 
{"LayoutConstraints", LayoutConstraintsExposedConstructCallback}, 
{"LayoutEdges", LayoutEdgesExposedConstructCallback}, 
{"LayoutFragment", LayoutFragmentExposedConstructCallback}, 
{"LayoutWorkletGlobalScope", LayoutWorkletGlobalScopeExposedConstructCallback}, 
};
IDLMemberInstaller::InstallExposedConstructs(isolate, world, instance_template, prototype_template, interface_template, signature, kExposedConstructTable);
}
if (RuntimeEnabledFeatures::QuotaExceededErrorUpdateEnabled()) {
  static const IDLMemberInstaller::ExposedConstructConfig kExposedConstructTable[] = {
{"QuotaExceededError", QuotaExceededErrorExposedConstructCallback}, 
};
IDLMemberInstaller::InstallExposedConstructs(isolate, world, instance_template, prototype_template, interface_template, signature, kExposedConstructTable);
}



}



}  // namespace blink
