// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_LANGUAGE_MODEL_CREATE_CORE_OPTIONS_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_LANGUAGE_MODEL_CREATE_CORE_OPTIONS_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"
#include "third_party/blink/renderer/platform/heap/collection_support/heap_vector.h"
#include "third_party/blink/renderer/platform/heap/member.h"

namespace blink {

class ExceptionState;
class LanguageModelExpected;

class MODULES_EXPORT LanguageModelCreateCoreOptions : public bindings::InputDictionaryBase {
  
  public:
static LanguageModelCreateCoreOptions* Create() {
  return MakeGarbageCollected<LanguageModelCreateCoreOptions>();
}
static LanguageModelCreateCoreOptions* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<LanguageModelCreateCoreOptions>(isolate);
}
static LanguageModelCreateCoreOptions* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  LanguageModelCreateCoreOptions();
explicit  LanguageModelCreateCoreOptions(v8::Isolate* isolate);

bool hasExpectedInputs() const {
  return has_expected_inputs_;
}
const HeapVector<Member<LanguageModelExpected>>& expectedInputs() const {
  DCHECK(hasExpectedInputs());
return member_expected_inputs_;
}
HeapVector<Member<LanguageModelExpected>> getExpectedInputsOr(const HeapVector<Member<LanguageModelExpected>>& fallback_value) const;
HeapVector<Member<LanguageModelExpected>> getExpectedInputsOr(HeapVector<Member<LanguageModelExpected>>&& fallback_value) const;
void setExpectedInputs(const HeapVector<Member<LanguageModelExpected>>& value);
void setExpectedInputs(HeapVector<Member<LanguageModelExpected>>&& value);

bool hasExpectedOutputs() const {
  return has_expected_outputs_;
}
const HeapVector<Member<LanguageModelExpected>>& expectedOutputs() const {
  DCHECK(hasExpectedOutputs());
return member_expected_outputs_;
}
HeapVector<Member<LanguageModelExpected>> getExpectedOutputsOr(const HeapVector<Member<LanguageModelExpected>>& fallback_value) const;
HeapVector<Member<LanguageModelExpected>> getExpectedOutputsOr(HeapVector<Member<LanguageModelExpected>>&& fallback_value) const;
void setExpectedOutputs(const HeapVector<Member<LanguageModelExpected>>& value);
void setExpectedOutputs(HeapVector<Member<LanguageModelExpected>>&& value);

bool hasTemperature() const {
  return has_temperature_;
}
double temperature() const {
  DCHECK(hasTemperature());
return member_temperature_;
}
double getTemperatureOr(double fallback_value) const {
  if (!hasTemperature()) {
  return fallback_value;
}
return member_temperature_;
}
void setTemperature(double value) {
  member_temperature_ = value;
has_temperature_ = true;
}

bool hasTopK() const {
  return has_top_k_;
}
double topK() const {
  DCHECK(hasTopK());
return member_top_k_;
}
double getTopKOr(double fallback_value) const {
  if (!hasTopK()) {
  return fallback_value;
}
return member_top_k_;
}
void setTopK(double value) {
  member_top_k_ = value;
has_top_k_ = true;
}




void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 4;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_expected_inputs_ = false;
bool has_expected_outputs_ = false;
bool has_temperature_ = false;
bool has_top_k_ = false;

HeapVector<Member<LanguageModelExpected>> member_expected_inputs_;
HeapVector<Member<LanguageModelExpected>> member_expected_outputs_;
double member_temperature_;
double member_top_k_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_LANGUAGE_MODEL_CREATE_CORE_OPTIONS_H_
