// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_ITEM_DETAILS_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_ITEM_DETAILS_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_item_type.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"
#include "third_party/blink/renderer/platform/heap/collection_support/heap_vector.h"
#include "third_party/blink/renderer/platform/heap/member.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

namespace blink {

class ExceptionState;
class PaymentCurrencyAmount;

class MODULES_EXPORT ItemDetails : public bindings::DictionaryBase {
  
  public:
static ItemDetails* Create() {
  return MakeGarbageCollected<ItemDetails>();
}
static ItemDetails* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<ItemDetails>(isolate);
}
static ItemDetails* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  ItemDetails();
explicit  ItemDetails(v8::Isolate* isolate);

bool hasDescription() const {
  return has_description_;
}
const String& description() const {
  DCHECK(hasDescription());
return member_description_;
}
String getDescriptionOr(const String& fallback_value) const;
String getDescriptionOr(String&& fallback_value) const;
void setDescription(const String& value);
void setDescription(String&& value);

bool hasFreeTrialPeriod() const {
  return has_free_trial_period_;
}
const String& freeTrialPeriod() const {
  DCHECK(hasFreeTrialPeriod());
return member_free_trial_period_;
}
String getFreeTrialPeriodOr(const String& fallback_value) const;
String getFreeTrialPeriodOr(String&& fallback_value) const;
void setFreeTrialPeriod(const String& value);
void setFreeTrialPeriod(String&& value);

bool hasIconURLs() const {
  return has_icon_urls_;
}
const Vector<String>& iconURLs() const {
  DCHECK(hasIconURLs());
return member_icon_urls_;
}
Vector<String> getIconURLsOr(const Vector<String>& fallback_value) const;
Vector<String> getIconURLsOr(Vector<String>&& fallback_value) const;
void setIconURLs(const Vector<String>& value);
void setIconURLs(Vector<String>&& value);

bool hasIntroductoryPrice() const {
  return has_introductory_price_;
}
PaymentCurrencyAmount* introductoryPrice() const {
  DCHECK(hasIntroductoryPrice());
return member_introductory_price_.Get();
}
PaymentCurrencyAmount* getIntroductoryPriceOr(PaymentCurrencyAmount* fallback_value) const {
  if (!hasIntroductoryPrice()) {
  return fallback_value;
}
return member_introductory_price_.Get();
}
void setIntroductoryPrice(PaymentCurrencyAmount* value) {
  member_introductory_price_ = value;
has_introductory_price_ = true;
DCHECK(member_introductory_price_);
}

bool hasIntroductoryPriceCycles() const {
  return has_introductory_price_cycles_;
}
uint64_t introductoryPriceCycles() const {
  DCHECK(hasIntroductoryPriceCycles());
return member_introductory_price_cycles_;
}
uint64_t getIntroductoryPriceCyclesOr(uint64_t fallback_value) const {
  if (!hasIntroductoryPriceCycles()) {
  return fallback_value;
}
return member_introductory_price_cycles_;
}
void setIntroductoryPriceCycles(uint64_t value) {
  member_introductory_price_cycles_ = value;
has_introductory_price_cycles_ = true;
}

bool hasIntroductoryPricePeriod() const {
  return has_introductory_price_period_;
}
const String& introductoryPricePeriod() const {
  DCHECK(hasIntroductoryPricePeriod());
return member_introductory_price_period_;
}
String getIntroductoryPricePeriodOr(const String& fallback_value) const;
String getIntroductoryPricePeriodOr(String&& fallback_value) const;
void setIntroductoryPricePeriod(const String& value);
void setIntroductoryPricePeriod(String&& value);

bool hasItemId() const {
  return true;
}
const String& itemId() const {
  return member_item_id_;
}
void setItemId(const String& value);
void setItemId(String&& value);

bool hasPrice() const {
  return true;
}
PaymentCurrencyAmount* price() const {
  return member_price_.Get();
}
void setPrice(PaymentCurrencyAmount* value) {
  member_price_ = value;
DCHECK(member_price_);
}

bool hasSubscriptionPeriod() const {
  return has_subscription_period_;
}
const String& subscriptionPeriod() const {
  DCHECK(hasSubscriptionPeriod());
return member_subscription_period_;
}
String getSubscriptionPeriodOr(const String& fallback_value) const;
String getSubscriptionPeriodOr(String&& fallback_value) const;
void setSubscriptionPeriod(const String& value);
void setSubscriptionPeriod(String&& value);

bool hasTitle() const {
  return true;
}
const String& title() const {
  return member_title_;
}
void setTitle(const String& value);
void setTitle(String&& value);

bool hasType() const {
  return has_type_;
}
V8ItemType type() const {
  DCHECK(hasType());
return member_type_;
}
V8ItemType getTypeOr(V8ItemType fallback_value) const {
  if (!hasType()) {
  return fallback_value;
}
return member_type_;
}
void setType(V8ItemType value) {
  member_type_ = value;
has_type_ = true;
}
void setType(V8ItemType::Enum value) {
  member_type_ = V8ItemType(value);
has_type_ = true;
}




void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 11;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillTemplateProperties(Vector<std::string_view>& properties) const override;
void FillValuesImpl(ScriptState* script_state, base::span<v8::MaybeLocal<v8::Value>> values) const;


void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
const void* TemplateKey() const override;
v8::Local<v8::Object> FillValues(ScriptState* script_state, v8::Local<v8::DictionaryTemplate> dict_template) const override;
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_description_ = false;
bool has_free_trial_period_ = false;
bool has_icon_urls_ = false;
bool has_introductory_price_ = false;
bool has_introductory_price_cycles_ = false;
bool has_introductory_price_period_ = false;
bool has_subscription_period_ = false;
bool has_type_ = false;

String member_description_;
String member_free_trial_period_;
Vector<String> member_icon_urls_;
Member<PaymentCurrencyAmount> member_introductory_price_;
uint64_t member_introductory_price_cycles_;
String member_introductory_price_period_;
String member_item_id_;
Member<PaymentCurrencyAmount> member_price_;
String member_subscription_period_;
String member_title_;
V8ItemType member_type_{static_cast<V8ItemType::Enum>(0)};


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_ITEM_DETAILS_H_
