// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_IDENTITY_USER_INFO_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_IDENTITY_USER_INFO_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

namespace blink {

class ExceptionState;

class MODULES_EXPORT IdentityUserInfo : public bindings::DictionaryBase {
  
  public:
static IdentityUserInfo* Create() {
  return MakeGarbageCollected<IdentityUserInfo>();
}
static IdentityUserInfo* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<IdentityUserInfo>(isolate);
}
static IdentityUserInfo* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  IdentityUserInfo();
explicit  IdentityUserInfo(v8::Isolate* isolate);

bool hasEmail() const {
  return has_email_;
}
const String& email() const {
  DCHECK(hasEmail());
return member_email_;
}
String getEmailOr(const String& fallback_value) const;
String getEmailOr(String&& fallback_value) const;
void setEmail(const String& value);
void setEmail(String&& value);

bool hasGivenName() const {
  return has_given_name_;
}
const String& givenName() const {
  DCHECK(hasGivenName());
return member_given_name_;
}
String getGivenNameOr(const String& fallback_value) const;
String getGivenNameOr(String&& fallback_value) const;
void setGivenName(const String& value);
void setGivenName(String&& value);

bool hasName() const {
  return has_name_;
}
const String& name() const {
  DCHECK(hasName());
return member_name_;
}
String getNameOr(const String& fallback_value) const;
String getNameOr(String&& fallback_value) const;
void setName(const String& value);
void setName(String&& value);

bool hasPicture() const {
  return has_picture_;
}
const String& picture() const {
  DCHECK(hasPicture());
return member_picture_;
}
String getPictureOr(const String& fallback_value) const;
String getPictureOr(String&& fallback_value) const;
void setPicture(const String& value);
void setPicture(String&& value);




void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 4;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillTemplateProperties(Vector<std::string_view>& properties) const override;
void FillValuesImpl(ScriptState* script_state, base::span<v8::MaybeLocal<v8::Value>> values) const;


void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
const void* TemplateKey() const override;
v8::Local<v8::Object> FillValues(ScriptState* script_state, v8::Local<v8::DictionaryTemplate> dict_template) const override;
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_email_ = false;
bool has_given_name_ = false;
bool has_name_ = false;
bool has_picture_ = false;

String member_email_;
String member_given_name_;
String member_name_;
String member_picture_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_IDENTITY_USER_INFO_H_
