// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#include "third_party/blink/renderer/bindings/modules/v8/v8_identity_provider_request_options.h"

#include "third_party/blink/renderer/bindings/core/v8/generated_code_helper.h"
#include "third_party/blink/renderer/bindings/core/v8/native_value_traits_impl.h"
#include "third_party/blink/renderer/bindings/core/v8/to_v8_traits.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_identity_provider_field.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_union_identityproviderfield_usvstring.h"
#include "third_party/blink/renderer/platform/bindings/exception_messages.h"
#include "third_party/blink/renderer/platform/bindings/exception_state.h"
#include "third_party/blink/renderer/platform/bindings/v8_per_isolate_data.h"
#include "third_party/blink/renderer/platform/runtime_enabled_features.h"

namespace blink {



namespace  {

const std::string_view kOwnPropertyNames[] = {
"domainHint",
"fields",
"format",
"loginHint",
"nonce",
"params",
};


}  // namespace 

IdentityProviderRequestOptions* IdentityProviderRequestOptions::Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state) {
  IdentityProviderRequestOptions* dictionary = MakeGarbageCollected<IdentityProviderRequestOptions>(isolate);
if (!v8_value->IsObject()) {
  const char* const class_like_name = "IdentityProviderRequestOptions";
exception_state.ThrowTypeError(ExceptionMessages::ValueNotOfType(class_like_name));
return nullptr;
}
dictionary->FillMembersFromV8Object(isolate, v8_value.As<v8::Object>(), exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return nullptr;
}
return dictionary;
}

 IdentityProviderRequestOptions::IdentityProviderRequestOptions() {
  
}

 IdentityProviderRequestOptions::IdentityProviderRequestOptions(v8::Isolate* isolate) : IdentityProviderConfig(isolate) {
  
}



String IdentityProviderRequestOptions::getDomainHintOr(const String& fallback_value) const {
  if (!hasDomainHint()) {
  return fallback_value;
}
return member_domain_hint_;
}

String IdentityProviderRequestOptions::getDomainHintOr(String&& fallback_value) const {
  if (!hasDomainHint()) {
  return std::move(fallback_value);
}
return member_domain_hint_;
}

void IdentityProviderRequestOptions::setDomainHint(const String& value) {
  member_domain_hint_ = value;
has_domain_hint_ = true;
}

void IdentityProviderRequestOptions::setDomainHint(String&& value) {
  member_domain_hint_ = std::move(value);
has_domain_hint_ = true;
}




HeapVector<Member<V8UnionIdentityProviderFieldOrUSVString>> IdentityProviderRequestOptions::getFieldsOr(const HeapVector<Member<V8UnionIdentityProviderFieldOrUSVString>>& fallback_value) const {
  if (!hasFields()) {
  return fallback_value;
}
return member_fields_;
}

HeapVector<Member<V8UnionIdentityProviderFieldOrUSVString>> IdentityProviderRequestOptions::getFieldsOr(HeapVector<Member<V8UnionIdentityProviderFieldOrUSVString>>&& fallback_value) const {
  if (!hasFields()) {
  return std::move(fallback_value);
}
return member_fields_;
}

void IdentityProviderRequestOptions::setFields(const HeapVector<Member<V8UnionIdentityProviderFieldOrUSVString>>& value) {
  member_fields_ = value;
has_fields_ = true;
}

void IdentityProviderRequestOptions::setFields(HeapVector<Member<V8UnionIdentityProviderFieldOrUSVString>>&& value) {
  member_fields_ = std::move(value);
has_fields_ = true;
}











String IdentityProviderRequestOptions::getLoginHintOr(const String& fallback_value) const {
  if (!hasLoginHint()) {
  return fallback_value;
}
return member_login_hint_;
}

String IdentityProviderRequestOptions::getLoginHintOr(String&& fallback_value) const {
  if (!hasLoginHint()) {
  return std::move(fallback_value);
}
return member_login_hint_;
}

void IdentityProviderRequestOptions::setLoginHint(const String& value) {
  member_login_hint_ = value;
has_login_hint_ = true;
}

void IdentityProviderRequestOptions::setLoginHint(String&& value) {
  member_login_hint_ = std::move(value);
has_login_hint_ = true;
}




String IdentityProviderRequestOptions::getNonceOr(const String& fallback_value) const {
  if (!hasNonce()) {
  return fallback_value;
}
return member_nonce_;
}

String IdentityProviderRequestOptions::getNonceOr(String&& fallback_value) const {
  if (!hasNonce()) {
  return std::move(fallback_value);
}
return member_nonce_;
}

void IdentityProviderRequestOptions::setNonce(const String& value) {
  member_nonce_ = value;
has_nonce_ = true;
}

void IdentityProviderRequestOptions::setNonce(String&& value) {
  member_nonce_ = std::move(value);
has_nonce_ = true;
}











void IdentityProviderRequestOptions::Trace(Visitor* visitor) const {
  visitor->Trace(member_fields_);
visitor->Trace(member_params_);
IdentityProviderConfig::Trace(visitor);
}

void IdentityProviderRequestOptions::FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state) {
  TryRethrowScope rethrow_scope(isolate, exception_state);
IdentityProviderConfig::FillMembersFromV8Object(isolate, v8_dictionary, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}

const char* const class_like_name = "IdentityProviderRequestOptions";
DictionaryConversionContext dictionary_from_v8_context(isolate, class_like_name);
dictionary_from_v8_context.SetCurrentPropertyName("domainHint");
constexpr bool is_optional = false;
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
const auto& v8_own_member_names = GetV8OwnMemberNames(isolate);
if (!bindings::GetDictionaryMemberFromV8Object<IDLString, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[0].Get(isolate), has_domain_hint_, member_domain_hint_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("fields");
if (!bindings::GetDictionaryMemberFromV8Object<IDLSequence<V8UnionIdentityProviderFieldOrUSVString>, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[1].Get(isolate), has_fields_, member_fields_, class_like_name, exception_state)) {
  return;
}
if (RuntimeEnabledFeatures::FedCmDelegationEnabled()) {
  dictionary_from_v8_context.SetCurrentPropertyName("format");
if (!bindings::GetDictionaryMemberFromV8Object<V8IdentityProviderRequestOptionsFormat, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[2].Get(isolate), has_format_, member_format_, class_like_name, exception_state)) {
  return;
}
}
dictionary_from_v8_context.SetCurrentPropertyName("loginHint");
if (!bindings::GetDictionaryMemberFromV8Object<IDLString, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[3].Get(isolate), has_login_hint_, member_login_hint_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("nonce");
if (!bindings::GetDictionaryMemberFromV8Object<IDLUSVString, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[4].Get(isolate), has_nonce_, member_nonce_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("params");
bool fallback_presence_var;
if (!bindings::GetDictionaryMemberFromV8Object<IDLAny, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[5].Get(isolate), fallback_presence_var, member_params_, class_like_name, exception_state)) {
  return;
}
}

const base::span<const v8::Eternal<v8::Name>> IdentityProviderRequestOptions::GetV8OwnMemberNames(v8::Isolate* isolate) {
  return V8PerIsolateData::From(isolate)->FindOrCreateEternalNameCache(kOwnPropertyNames, kOwnPropertyNames);
}


}  // namespace blink
