// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_IDENTITY_PROVIDER_ACCOUNT_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_IDENTITY_PROVIDER_ACCOUNT_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"
#include "third_party/blink/renderer/platform/heap/collection_support/heap_vector.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

namespace blink {

class ExceptionState;

class MODULES_EXPORT IdentityProviderAccount : public bindings::InputDictionaryBase {
  
  public:
static IdentityProviderAccount* Create() {
  return MakeGarbageCollected<IdentityProviderAccount>();
}
static IdentityProviderAccount* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<IdentityProviderAccount>(isolate);
}
static IdentityProviderAccount* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  IdentityProviderAccount();
explicit  IdentityProviderAccount(v8::Isolate* isolate);

bool hasApprovedClients() const {
  return has_approved_clients_;
}
const Vector<String>& approvedClients() const {
  DCHECK(hasApprovedClients());
return member_approved_clients_;
}
Vector<String> getApprovedClientsOr(const Vector<String>& fallback_value) const;
Vector<String> getApprovedClientsOr(Vector<String>&& fallback_value) const;
void setApprovedClients(const Vector<String>& value);
void setApprovedClients(Vector<String>&& value);

bool hasDomainHints() const {
  return has_domain_hints_;
}
const Vector<String>& domainHints() const {
  DCHECK(hasDomainHints());
return member_domain_hints_;
}
Vector<String> getDomainHintsOr(const Vector<String>& fallback_value) const;
Vector<String> getDomainHintsOr(Vector<String>&& fallback_value) const;
void setDomainHints(const Vector<String>& value);
void setDomainHints(Vector<String>&& value);

bool hasEmail() const {
  return true;
}
const String& email() const {
  return member_email_;
}
void setEmail(const String& value);
void setEmail(String&& value);

bool hasGivenName() const {
  return has_given_name_;
}
const String& givenName() const {
  DCHECK(hasGivenName());
return member_given_name_;
}
String getGivenNameOr(const String& fallback_value) const;
String getGivenNameOr(String&& fallback_value) const;
void setGivenName(const String& value);
void setGivenName(String&& value);

bool hasId() const {
  return true;
}
const String& id() const {
  return member_id_;
}
void setId(const String& value);
void setId(String&& value);

bool hasLoginHints() const {
  return has_login_hints_;
}
const Vector<String>& loginHints() const {
  DCHECK(hasLoginHints());
return member_login_hints_;
}
Vector<String> getLoginHintsOr(const Vector<String>& fallback_value) const;
Vector<String> getLoginHintsOr(Vector<String>&& fallback_value) const;
void setLoginHints(const Vector<String>& value);
void setLoginHints(Vector<String>&& value);

bool hasName() const {
  return true;
}
const String& name() const {
  return member_name_;
}
void setName(const String& value);
void setName(String&& value);

bool hasPicture() const {
  return has_picture_;
}
const String& picture() const {
  DCHECK(hasPicture());
return member_picture_;
}
String getPictureOr(const String& fallback_value) const;
String getPictureOr(String&& fallback_value) const;
void setPicture(const String& value);
void setPicture(String&& value);




void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 8;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_approved_clients_ = false;
bool has_domain_hints_ = false;
bool has_given_name_ = false;
bool has_login_hints_ = false;
bool has_picture_ = false;

Vector<String> member_approved_clients_;
Vector<String> member_domain_hints_;
String member_email_;
String member_given_name_;
String member_id_;
Vector<String> member_login_hints_;
String member_name_;
String member_picture_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_IDENTITY_PROVIDER_ACCOUNT_H_
