// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_IDENTITY_CREDENTIAL_REQUEST_OPTIONS_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_IDENTITY_CREDENTIAL_REQUEST_OPTIONS_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_identity_credential_request_options_context.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_identity_credential_request_options_mode.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"
#include "third_party/blink/renderer/platform/heap/collection_support/heap_vector.h"
#include "third_party/blink/renderer/platform/heap/member.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

namespace blink {

class ExceptionState;
class IdentityProviderRequestOptions;

class MODULES_EXPORT IdentityCredentialRequestOptions : public bindings::InputDictionaryBase {
  
  public:
static IdentityCredentialRequestOptions* Create() {
  return MakeGarbageCollected<IdentityCredentialRequestOptions>();
}
static IdentityCredentialRequestOptions* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<IdentityCredentialRequestOptions>(isolate);
}
static IdentityCredentialRequestOptions* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  IdentityCredentialRequestOptions();
explicit  IdentityCredentialRequestOptions(v8::Isolate* isolate);

bool hasContext() const {
  return true;
}
V8IdentityCredentialRequestOptionsContext context() const {
  return member_context_;
}
void setContext(V8IdentityCredentialRequestOptionsContext value) {
  member_context_ = value;
}
void setContext(V8IdentityCredentialRequestOptionsContext::Enum value) {
  member_context_ = V8IdentityCredentialRequestOptionsContext(value);
}

bool hasMediation() const {
  return has_mediation_;
}
const String& mediation() const {
  DCHECK(hasMediation());
return member_mediation_;
}
String getMediationOr(const String& fallback_value) const;
String getMediationOr(String&& fallback_value) const;
void setMediation(const String& value);
void setMediation(String&& value);

bool hasMode() const {
  return true;
}
V8IdentityCredentialRequestOptionsMode mode() const {
  return member_mode_;
}
void setMode(V8IdentityCredentialRequestOptionsMode value) {
  member_mode_ = value;
}
void setMode(V8IdentityCredentialRequestOptionsMode::Enum value) {
  member_mode_ = V8IdentityCredentialRequestOptionsMode(value);
}

bool hasProviders() const {
  return true;
}
const HeapVector<Member<IdentityProviderRequestOptions>>& providers() const {
  return member_providers_;
}
void setProviders(const HeapVector<Member<IdentityProviderRequestOptions>>& value);
void setProviders(HeapVector<Member<IdentityProviderRequestOptions>>&& value);




void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 4;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_mediation_ = false;

V8IdentityCredentialRequestOptionsContext member_context_{V8IdentityCredentialRequestOptionsContext::Enum::kSignin};
String member_mediation_;
V8IdentityCredentialRequestOptionsMode member_mode_{V8IdentityCredentialRequestOptionsMode::Enum::kPassive};
HeapVector<Member<IdentityProviderRequestOptions>> member_providers_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_IDENTITY_CREDENTIAL_REQUEST_OPTIONS_H_
