// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_IDB_OBJECT_STORE_PARAMETERS_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_IDB_OBJECT_STORE_PARAMETERS_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"
#include "third_party/blink/renderer/platform/heap/collection_support/heap_vector.h"
#include "third_party/blink/renderer/platform/heap/member.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

namespace blink {

class ExceptionState;
class V8UnionStringOrStringSequence;

class MODULES_EXPORT IDBObjectStoreParameters : public bindings::InputDictionaryBase {
  
  public:
static IDBObjectStoreParameters* Create() {
  return MakeGarbageCollected<IDBObjectStoreParameters>();
}
static IDBObjectStoreParameters* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<IDBObjectStoreParameters>(isolate);
}
static IDBObjectStoreParameters* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  IDBObjectStoreParameters();
explicit  IDBObjectStoreParameters(v8::Isolate* isolate);

bool hasAutoIncrement() const {
  return true;
}
bool autoIncrement() const {
  return member_auto_increment_;
}
void setAutoIncrement(bool value) {
  member_auto_increment_ = value;
}

bool hasKeyPath() const {
  return true;
}
V8UnionStringOrStringSequence* keyPath() const {
  return member_key_path_.Get();
}
void setKeyPath(V8UnionStringOrStringSequence* value) {
  member_key_path_ = value;
}




void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 2;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);



bool member_auto_increment_{false};
Member<V8UnionStringOrStringSequence> member_key_path_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_IDB_OBJECT_STORE_PARAMETERS_H_
