// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_IDB_INDEX_PARAMETERS_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_IDB_INDEX_PARAMETERS_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"

namespace blink {

class ExceptionState;

class MODULES_EXPORT IDBIndexParameters : public bindings::InputDictionaryBase {
  
  public:
static IDBIndexParameters* Create() {
  return MakeGarbageCollected<IDBIndexParameters>();
}
static IDBIndexParameters* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<IDBIndexParameters>(isolate);
}
static IDBIndexParameters* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  IDBIndexParameters();
explicit  IDBIndexParameters(v8::Isolate* isolate);

bool hasMultiEntry() const {
  return true;
}
bool multiEntry() const {
  return member_multi_entry_;
}
void setMultiEntry(bool value) {
  member_multi_entry_ = value;
}

bool hasUnique() const {
  return true;
}
bool unique() const {
  return member_unique_;
}
void setUnique(bool value) {
  member_unique_ = value;
}




void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 2;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);



bool member_multi_entry_{false};
bool member_unique_{false};


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_IDB_INDEX_PARAMETERS_H_
