// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_IDB_DATABASE_INFO_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_IDB_DATABASE_INFO_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

namespace blink {

class ExceptionState;

class MODULES_EXPORT IDBDatabaseInfo : public bindings::DictionaryBase {
  
  public:
static IDBDatabaseInfo* Create() {
  return MakeGarbageCollected<IDBDatabaseInfo>();
}
static IDBDatabaseInfo* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<IDBDatabaseInfo>(isolate);
}
static IDBDatabaseInfo* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  IDBDatabaseInfo();
explicit  IDBDatabaseInfo(v8::Isolate* isolate);

bool hasName() const {
  return has_name_;
}
const String& name() const {
  DCHECK(hasName());
return member_name_;
}
String getNameOr(const String& fallback_value) const;
String getNameOr(String&& fallback_value) const;
void setName(const String& value);
void setName(String&& value);

bool hasVersion() const {
  return has_version_;
}
uint64_t version() const {
  DCHECK(hasVersion());
return member_version_;
}
uint64_t getVersionOr(uint64_t fallback_value) const {
  if (!hasVersion()) {
  return fallback_value;
}
return member_version_;
}
void setVersion(uint64_t value) {
  member_version_ = value;
has_version_ = true;
}




void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 2;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillTemplateProperties(Vector<std::string_view>& properties) const override;
void FillValuesImpl(ScriptState* script_state, base::span<v8::MaybeLocal<v8::Value>> values) const;


void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
const void* TemplateKey() const override;
v8::Local<v8::Object> FillValues(ScriptState* script_state, v8::Local<v8::DictionaryTemplate> dict_template) const override;
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_name_ = false;
bool has_version_ = false;

String member_name_;
uint64_t member_version_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_IDB_DATABASE_INFO_H_
