// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_HID_REPORT_ITEM_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_HID_REPORT_ITEM_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_hid_unit_system.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"
#include "third_party/blink/renderer/platform/heap/collection_support/heap_vector.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

namespace blink {

class ExceptionState;

class MODULES_EXPORT HIDReportItem : public bindings::DictionaryBase {
  
  public:
static HIDReportItem* Create() {
  return MakeGarbageCollected<HIDReportItem>();
}
static HIDReportItem* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<HIDReportItem>(isolate);
}
static HIDReportItem* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  HIDReportItem();
explicit  HIDReportItem(v8::Isolate* isolate);

bool hasHasNull() const {
  return has_has_null_;
}
bool hasNull() const {
  DCHECK(hasHasNull());
return member_has_null_;
}
bool getHasNullOr(bool fallback_value) const {
  if (!hasHasNull()) {
  return fallback_value;
}
return member_has_null_;
}
void setHasNull(bool value) {
  member_has_null_ = value;
has_has_null_ = true;
}

bool hasHasPreferredState() const {
  return has_has_preferred_state_;
}
bool hasPreferredState() const {
  DCHECK(hasHasPreferredState());
return member_has_preferred_state_;
}
bool getHasPreferredStateOr(bool fallback_value) const {
  if (!hasHasPreferredState()) {
  return fallback_value;
}
return member_has_preferred_state_;
}
void setHasPreferredState(bool value) {
  member_has_preferred_state_ = value;
has_has_preferred_state_ = true;
}

bool hasIsAbsolute() const {
  return has_is_absolute_;
}
bool isAbsolute() const {
  DCHECK(hasIsAbsolute());
return member_is_absolute_;
}
bool getIsAbsoluteOr(bool fallback_value) const {
  if (!hasIsAbsolute()) {
  return fallback_value;
}
return member_is_absolute_;
}
void setIsAbsolute(bool value) {
  member_is_absolute_ = value;
has_is_absolute_ = true;
}

bool hasIsArray() const {
  return has_is_array_;
}
bool isArray() const {
  DCHECK(hasIsArray());
return member_is_array_;
}
bool getIsArrayOr(bool fallback_value) const {
  if (!hasIsArray()) {
  return fallback_value;
}
return member_is_array_;
}
void setIsArray(bool value) {
  member_is_array_ = value;
has_is_array_ = true;
}

bool hasIsBufferedBytes() const {
  return has_is_buffered_bytes_;
}
bool isBufferedBytes() const {
  DCHECK(hasIsBufferedBytes());
return member_is_buffered_bytes_;
}
bool getIsBufferedBytesOr(bool fallback_value) const {
  if (!hasIsBufferedBytes()) {
  return fallback_value;
}
return member_is_buffered_bytes_;
}
void setIsBufferedBytes(bool value) {
  member_is_buffered_bytes_ = value;
has_is_buffered_bytes_ = true;
}

bool hasIsConstant() const {
  return has_is_constant_;
}
bool isConstant() const {
  DCHECK(hasIsConstant());
return member_is_constant_;
}
bool getIsConstantOr(bool fallback_value) const {
  if (!hasIsConstant()) {
  return fallback_value;
}
return member_is_constant_;
}
void setIsConstant(bool value) {
  member_is_constant_ = value;
has_is_constant_ = true;
}

bool hasIsLinear() const {
  return has_is_linear_;
}
bool isLinear() const {
  DCHECK(hasIsLinear());
return member_is_linear_;
}
bool getIsLinearOr(bool fallback_value) const {
  if (!hasIsLinear()) {
  return fallback_value;
}
return member_is_linear_;
}
void setIsLinear(bool value) {
  member_is_linear_ = value;
has_is_linear_ = true;
}

bool hasIsRange() const {
  return has_is_range_;
}
bool isRange() const {
  DCHECK(hasIsRange());
return member_is_range_;
}
bool getIsRangeOr(bool fallback_value) const {
  if (!hasIsRange()) {
  return fallback_value;
}
return member_is_range_;
}
void setIsRange(bool value) {
  member_is_range_ = value;
has_is_range_ = true;
}

bool hasIsVolatile() const {
  return has_is_volatile_;
}
bool isVolatile() const {
  DCHECK(hasIsVolatile());
return member_is_volatile_;
}
bool getIsVolatileOr(bool fallback_value) const {
  if (!hasIsVolatile()) {
  return fallback_value;
}
return member_is_volatile_;
}
void setIsVolatile(bool value) {
  member_is_volatile_ = value;
has_is_volatile_ = true;
}

bool hasLogicalMaximum() const {
  return has_logical_maximum_;
}
int32_t logicalMaximum() const {
  DCHECK(hasLogicalMaximum());
return member_logical_maximum_;
}
int32_t getLogicalMaximumOr(int32_t fallback_value) const {
  if (!hasLogicalMaximum()) {
  return fallback_value;
}
return member_logical_maximum_;
}
void setLogicalMaximum(int32_t value) {
  member_logical_maximum_ = value;
has_logical_maximum_ = true;
}

bool hasLogicalMinimum() const {
  return has_logical_minimum_;
}
int32_t logicalMinimum() const {
  DCHECK(hasLogicalMinimum());
return member_logical_minimum_;
}
int32_t getLogicalMinimumOr(int32_t fallback_value) const {
  if (!hasLogicalMinimum()) {
  return fallback_value;
}
return member_logical_minimum_;
}
void setLogicalMinimum(int32_t value) {
  member_logical_minimum_ = value;
has_logical_minimum_ = true;
}

bool hasPhysicalMaximum() const {
  return has_physical_maximum_;
}
int32_t physicalMaximum() const {
  DCHECK(hasPhysicalMaximum());
return member_physical_maximum_;
}
int32_t getPhysicalMaximumOr(int32_t fallback_value) const {
  if (!hasPhysicalMaximum()) {
  return fallback_value;
}
return member_physical_maximum_;
}
void setPhysicalMaximum(int32_t value) {
  member_physical_maximum_ = value;
has_physical_maximum_ = true;
}

bool hasPhysicalMinimum() const {
  return has_physical_minimum_;
}
int32_t physicalMinimum() const {
  DCHECK(hasPhysicalMinimum());
return member_physical_minimum_;
}
int32_t getPhysicalMinimumOr(int32_t fallback_value) const {
  if (!hasPhysicalMinimum()) {
  return fallback_value;
}
return member_physical_minimum_;
}
void setPhysicalMinimum(int32_t value) {
  member_physical_minimum_ = value;
has_physical_minimum_ = true;
}

bool hasReportCount() const {
  return has_report_count_;
}
uint16_t reportCount() const {
  DCHECK(hasReportCount());
return member_report_count_;
}
uint16_t getReportCountOr(uint16_t fallback_value) const {
  if (!hasReportCount()) {
  return fallback_value;
}
return member_report_count_;
}
void setReportCount(uint16_t value) {
  member_report_count_ = value;
has_report_count_ = true;
}

bool hasReportSize() const {
  return has_report_size_;
}
uint16_t reportSize() const {
  DCHECK(hasReportSize());
return member_report_size_;
}
uint16_t getReportSizeOr(uint16_t fallback_value) const {
  if (!hasReportSize()) {
  return fallback_value;
}
return member_report_size_;
}
void setReportSize(uint16_t value) {
  member_report_size_ = value;
has_report_size_ = true;
}

bool hasStrings() const {
  return has_strings_;
}
const Vector<String>& strings() const {
  DCHECK(hasStrings());
return member_strings_;
}
Vector<String> getStringsOr(const Vector<String>& fallback_value) const;
Vector<String> getStringsOr(Vector<String>&& fallback_value) const;
void setStrings(const Vector<String>& value);
void setStrings(Vector<String>&& value);

bool hasUnitExponent() const {
  return has_unit_exponent_;
}
int8_t unitExponent() const {
  DCHECK(hasUnitExponent());
return member_unit_exponent_;
}
int8_t getUnitExponentOr(int8_t fallback_value) const {
  if (!hasUnitExponent()) {
  return fallback_value;
}
return member_unit_exponent_;
}
void setUnitExponent(int8_t value) {
  member_unit_exponent_ = value;
has_unit_exponent_ = true;
}

bool hasUnitFactorCurrentExponent() const {
  return has_unit_factor_current_exponent_;
}
int8_t unitFactorCurrentExponent() const {
  DCHECK(hasUnitFactorCurrentExponent());
return member_unit_factor_current_exponent_;
}
int8_t getUnitFactorCurrentExponentOr(int8_t fallback_value) const {
  if (!hasUnitFactorCurrentExponent()) {
  return fallback_value;
}
return member_unit_factor_current_exponent_;
}
void setUnitFactorCurrentExponent(int8_t value) {
  member_unit_factor_current_exponent_ = value;
has_unit_factor_current_exponent_ = true;
}

bool hasUnitFactorLengthExponent() const {
  return has_unit_factor_length_exponent_;
}
int8_t unitFactorLengthExponent() const {
  DCHECK(hasUnitFactorLengthExponent());
return member_unit_factor_length_exponent_;
}
int8_t getUnitFactorLengthExponentOr(int8_t fallback_value) const {
  if (!hasUnitFactorLengthExponent()) {
  return fallback_value;
}
return member_unit_factor_length_exponent_;
}
void setUnitFactorLengthExponent(int8_t value) {
  member_unit_factor_length_exponent_ = value;
has_unit_factor_length_exponent_ = true;
}

bool hasUnitFactorLuminousIntensityExponent() const {
  return has_unit_factor_luminous_intensity_exponent_;
}
int8_t unitFactorLuminousIntensityExponent() const {
  DCHECK(hasUnitFactorLuminousIntensityExponent());
return member_unit_factor_luminous_intensity_exponent_;
}
int8_t getUnitFactorLuminousIntensityExponentOr(int8_t fallback_value) const {
  if (!hasUnitFactorLuminousIntensityExponent()) {
  return fallback_value;
}
return member_unit_factor_luminous_intensity_exponent_;
}
void setUnitFactorLuminousIntensityExponent(int8_t value) {
  member_unit_factor_luminous_intensity_exponent_ = value;
has_unit_factor_luminous_intensity_exponent_ = true;
}

bool hasUnitFactorMassExponent() const {
  return has_unit_factor_mass_exponent_;
}
int8_t unitFactorMassExponent() const {
  DCHECK(hasUnitFactorMassExponent());
return member_unit_factor_mass_exponent_;
}
int8_t getUnitFactorMassExponentOr(int8_t fallback_value) const {
  if (!hasUnitFactorMassExponent()) {
  return fallback_value;
}
return member_unit_factor_mass_exponent_;
}
void setUnitFactorMassExponent(int8_t value) {
  member_unit_factor_mass_exponent_ = value;
has_unit_factor_mass_exponent_ = true;
}

bool hasUnitFactorTemperatureExponent() const {
  return has_unit_factor_temperature_exponent_;
}
int8_t unitFactorTemperatureExponent() const {
  DCHECK(hasUnitFactorTemperatureExponent());
return member_unit_factor_temperature_exponent_;
}
int8_t getUnitFactorTemperatureExponentOr(int8_t fallback_value) const {
  if (!hasUnitFactorTemperatureExponent()) {
  return fallback_value;
}
return member_unit_factor_temperature_exponent_;
}
void setUnitFactorTemperatureExponent(int8_t value) {
  member_unit_factor_temperature_exponent_ = value;
has_unit_factor_temperature_exponent_ = true;
}

bool hasUnitFactorTimeExponent() const {
  return has_unit_factor_time_exponent_;
}
int8_t unitFactorTimeExponent() const {
  DCHECK(hasUnitFactorTimeExponent());
return member_unit_factor_time_exponent_;
}
int8_t getUnitFactorTimeExponentOr(int8_t fallback_value) const {
  if (!hasUnitFactorTimeExponent()) {
  return fallback_value;
}
return member_unit_factor_time_exponent_;
}
void setUnitFactorTimeExponent(int8_t value) {
  member_unit_factor_time_exponent_ = value;
has_unit_factor_time_exponent_ = true;
}

bool hasUnitSystem() const {
  return has_unit_system_;
}
V8HIDUnitSystem unitSystem() const {
  DCHECK(hasUnitSystem());
return member_unit_system_;
}
V8HIDUnitSystem getUnitSystemOr(V8HIDUnitSystem fallback_value) const {
  if (!hasUnitSystem()) {
  return fallback_value;
}
return member_unit_system_;
}
void setUnitSystem(V8HIDUnitSystem value) {
  member_unit_system_ = value;
has_unit_system_ = true;
}
void setUnitSystem(V8HIDUnitSystem::Enum value) {
  member_unit_system_ = V8HIDUnitSystem(value);
has_unit_system_ = true;
}

bool hasUsageMaximum() const {
  return has_usage_maximum_;
}
uint32_t usageMaximum() const {
  DCHECK(hasUsageMaximum());
return member_usage_maximum_;
}
uint32_t getUsageMaximumOr(uint32_t fallback_value) const {
  if (!hasUsageMaximum()) {
  return fallback_value;
}
return member_usage_maximum_;
}
void setUsageMaximum(uint32_t value) {
  member_usage_maximum_ = value;
has_usage_maximum_ = true;
}

bool hasUsageMinimum() const {
  return has_usage_minimum_;
}
uint32_t usageMinimum() const {
  DCHECK(hasUsageMinimum());
return member_usage_minimum_;
}
uint32_t getUsageMinimumOr(uint32_t fallback_value) const {
  if (!hasUsageMinimum()) {
  return fallback_value;
}
return member_usage_minimum_;
}
void setUsageMinimum(uint32_t value) {
  member_usage_minimum_ = value;
has_usage_minimum_ = true;
}

bool hasUsages() const {
  return has_usages_;
}
const Vector<uint32_t>& usages() const {
  DCHECK(hasUsages());
return member_usages_;
}
Vector<uint32_t> getUsagesOr(const Vector<uint32_t>& fallback_value) const;
Vector<uint32_t> getUsagesOr(Vector<uint32_t>&& fallback_value) const;
void setUsages(const Vector<uint32_t>& value);
void setUsages(Vector<uint32_t>&& value);

bool hasWrap() const {
  return has_wrap_;
}
bool wrap() const {
  DCHECK(hasWrap());
return member_wrap_;
}
bool getWrapOr(bool fallback_value) const {
  if (!hasWrap()) {
  return fallback_value;
}
return member_wrap_;
}
void setWrap(bool value) {
  member_wrap_ = value;
has_wrap_ = true;
}




void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 28;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillTemplateProperties(Vector<std::string_view>& properties) const override;
void FillValuesImpl(ScriptState* script_state, base::span<v8::MaybeLocal<v8::Value>> values) const;


void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
const void* TemplateKey() const override;
v8::Local<v8::Object> FillValues(ScriptState* script_state, v8::Local<v8::DictionaryTemplate> dict_template) const override;
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_has_null_ = false;
bool has_has_preferred_state_ = false;
bool has_is_absolute_ = false;
bool has_is_array_ = false;
bool has_is_buffered_bytes_ = false;
bool has_is_constant_ = false;
bool has_is_linear_ = false;
bool has_is_range_ = false;
bool has_is_volatile_ = false;
bool has_logical_maximum_ = false;
bool has_logical_minimum_ = false;
bool has_physical_maximum_ = false;
bool has_physical_minimum_ = false;
bool has_report_count_ = false;
bool has_report_size_ = false;
bool has_strings_ = false;
bool has_unit_exponent_ = false;
bool has_unit_factor_current_exponent_ = false;
bool has_unit_factor_length_exponent_ = false;
bool has_unit_factor_luminous_intensity_exponent_ = false;
bool has_unit_factor_mass_exponent_ = false;
bool has_unit_factor_temperature_exponent_ = false;
bool has_unit_factor_time_exponent_ = false;
bool has_unit_system_ = false;
bool has_usage_maximum_ = false;
bool has_usage_minimum_ = false;
bool has_usages_ = false;
bool has_wrap_ = false;

bool member_has_null_;
bool member_has_preferred_state_;
bool member_is_absolute_;
bool member_is_array_;
bool member_is_buffered_bytes_;
bool member_is_constant_;
bool member_is_linear_;
bool member_is_range_;
bool member_is_volatile_;
int32_t member_logical_maximum_;
int32_t member_logical_minimum_;
int32_t member_physical_maximum_;
int32_t member_physical_minimum_;
uint16_t member_report_count_;
uint16_t member_report_size_;
Vector<String> member_strings_;
int8_t member_unit_exponent_;
int8_t member_unit_factor_current_exponent_;
int8_t member_unit_factor_length_exponent_;
int8_t member_unit_factor_luminous_intensity_exponent_;
int8_t member_unit_factor_mass_exponent_;
int8_t member_unit_factor_temperature_exponent_;
int8_t member_unit_factor_time_exponent_;
V8HIDUnitSystem member_unit_system_{static_cast<V8HIDUnitSystem::Enum>(0)};
uint32_t member_usage_maximum_;
uint32_t member_usage_minimum_;
Vector<uint32_t> member_usages_;
bool member_wrap_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_HID_REPORT_ITEM_H_
