// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#include "third_party/blink/renderer/bindings/modules/v8/v8_hid_report_item.h"

#include "third_party/blink/renderer/bindings/core/v8/generated_code_helper.h"
#include "third_party/blink/renderer/bindings/core/v8/native_value_traits_impl.h"
#include "third_party/blink/renderer/bindings/core/v8/to_v8_traits.h"
#include "third_party/blink/renderer/platform/bindings/exception_messages.h"
#include "third_party/blink/renderer/platform/bindings/exception_state.h"
#include "third_party/blink/renderer/platform/bindings/v8_per_isolate_data.h"

namespace blink {



namespace  {

const std::string_view kOwnPropertyNames[] = {
"hasNull",
"hasPreferredState",
"isAbsolute",
"isArray",
"isBufferedBytes",
"isConstant",
"isLinear",
"isRange",
"isVolatile",
"logicalMaximum",
"logicalMinimum",
"physicalMaximum",
"physicalMinimum",
"reportCount",
"reportSize",
"strings",
"unitExponent",
"unitFactorCurrentExponent",
"unitFactorLengthExponent",
"unitFactorLuminousIntensityExponent",
"unitFactorMassExponent",
"unitFactorTemperatureExponent",
"unitFactorTimeExponent",
"unitSystem",
"usageMaximum",
"usageMinimum",
"usages",
"wrap",
};


}  // namespace 

HIDReportItem* HIDReportItem::Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state) {
  HIDReportItem* dictionary = MakeGarbageCollected<HIDReportItem>(isolate);
if (v8_value->IsNullOrUndefined()) {
  return dictionary;
}
if (!v8_value->IsObject()) {
  const char* const class_like_name = "HIDReportItem";
exception_state.ThrowTypeError(ExceptionMessages::ValueNotOfType(class_like_name));
return nullptr;
}
dictionary->FillMembersFromV8Object(isolate, v8_value.As<v8::Object>(), exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return nullptr;
}
return dictionary;
}

 HIDReportItem::HIDReportItem() {
  
}

 HIDReportItem::HIDReportItem(v8::Isolate* isolate) {
  
}












































































































Vector<String> HIDReportItem::getStringsOr(const Vector<String>& fallback_value) const {
  if (!hasStrings()) {
  return fallback_value;
}
return member_strings_;
}

Vector<String> HIDReportItem::getStringsOr(Vector<String>&& fallback_value) const {
  if (!hasStrings()) {
  return std::move(fallback_value);
}
return member_strings_;
}

void HIDReportItem::setStrings(const Vector<String>& value) {
  member_strings_ = value;
has_strings_ = true;
}

void HIDReportItem::setStrings(Vector<String>&& value) {
  member_strings_ = std::move(value);
has_strings_ = true;
}










































































Vector<uint32_t> HIDReportItem::getUsagesOr(const Vector<uint32_t>& fallback_value) const {
  if (!hasUsages()) {
  return fallback_value;
}
return member_usages_;
}

Vector<uint32_t> HIDReportItem::getUsagesOr(Vector<uint32_t>&& fallback_value) const {
  if (!hasUsages()) {
  return std::move(fallback_value);
}
return member_usages_;
}

void HIDReportItem::setUsages(const Vector<uint32_t>& value) {
  member_usages_ = value;
has_usages_ = true;
}

void HIDReportItem::setUsages(Vector<uint32_t>&& value) {
  member_usages_ = std::move(value);
has_usages_ = true;
}











void HIDReportItem::Trace(Visitor* visitor) const {
  bindings::DictionaryBase::Trace(visitor);
}

void HIDReportItem::FillTemplateProperties(Vector<std::string_view>& properties) const {
  static_assert(std::size(kOwnPropertyNames) == kOwnPropertyCount);
properties.AppendRange(std::cbegin(kOwnPropertyNames), std::cend(kOwnPropertyNames));
DCHECK_EQ(properties.size(), kTotalPropertyCount);
}

void HIDReportItem::FillValuesImpl(ScriptState* script_state, base::span<v8::MaybeLocal<v8::Value>> values) const {
  CHECK_EQ(kOwnPropertyCount, values.size());
if (hasHasNull()) {
  values[0] = ToV8Traits<IDLBoolean>::ToV8(script_state, member_has_null_);
DCHECK(!values[0].IsEmpty());
}
if (hasHasPreferredState()) {
  values[1] = ToV8Traits<IDLBoolean>::ToV8(script_state, member_has_preferred_state_);
DCHECK(!values[1].IsEmpty());
}
if (hasIsAbsolute()) {
  values[2] = ToV8Traits<IDLBoolean>::ToV8(script_state, member_is_absolute_);
DCHECK(!values[2].IsEmpty());
}
if (hasIsArray()) {
  values[3] = ToV8Traits<IDLBoolean>::ToV8(script_state, member_is_array_);
DCHECK(!values[3].IsEmpty());
}
if (hasIsBufferedBytes()) {
  values[4] = ToV8Traits<IDLBoolean>::ToV8(script_state, member_is_buffered_bytes_);
DCHECK(!values[4].IsEmpty());
}
if (hasIsConstant()) {
  values[5] = ToV8Traits<IDLBoolean>::ToV8(script_state, member_is_constant_);
DCHECK(!values[5].IsEmpty());
}
if (hasIsLinear()) {
  values[6] = ToV8Traits<IDLBoolean>::ToV8(script_state, member_is_linear_);
DCHECK(!values[6].IsEmpty());
}
if (hasIsRange()) {
  values[7] = ToV8Traits<IDLBoolean>::ToV8(script_state, member_is_range_);
DCHECK(!values[7].IsEmpty());
}
if (hasIsVolatile()) {
  values[8] = ToV8Traits<IDLBoolean>::ToV8(script_state, member_is_volatile_);
DCHECK(!values[8].IsEmpty());
}
if (hasLogicalMaximum()) {
  values[9] = ToV8Traits<IDLLong>::ToV8(script_state, member_logical_maximum_);
DCHECK(!values[9].IsEmpty());
}
if (hasLogicalMinimum()) {
  values[10] = ToV8Traits<IDLLong>::ToV8(script_state, member_logical_minimum_);
DCHECK(!values[10].IsEmpty());
}
if (hasPhysicalMaximum()) {
  values[11] = ToV8Traits<IDLLong>::ToV8(script_state, member_physical_maximum_);
DCHECK(!values[11].IsEmpty());
}
if (hasPhysicalMinimum()) {
  values[12] = ToV8Traits<IDLLong>::ToV8(script_state, member_physical_minimum_);
DCHECK(!values[12].IsEmpty());
}
if (hasReportCount()) {
  values[13] = ToV8Traits<IDLUnsignedShort>::ToV8(script_state, member_report_count_);
DCHECK(!values[13].IsEmpty());
}
if (hasReportSize()) {
  values[14] = ToV8Traits<IDLUnsignedShort>::ToV8(script_state, member_report_size_);
DCHECK(!values[14].IsEmpty());
}
if (hasStrings()) {
  values[15] = ToV8Traits<IDLSequence<IDLString>>::ToV8(script_state, member_strings_);
DCHECK(!values[15].IsEmpty());
}
if (hasUnitExponent()) {
  values[16] = ToV8Traits<IDLByte>::ToV8(script_state, member_unit_exponent_);
DCHECK(!values[16].IsEmpty());
}
if (hasUnitFactorCurrentExponent()) {
  values[17] = ToV8Traits<IDLByte>::ToV8(script_state, member_unit_factor_current_exponent_);
DCHECK(!values[17].IsEmpty());
}
if (hasUnitFactorLengthExponent()) {
  values[18] = ToV8Traits<IDLByte>::ToV8(script_state, member_unit_factor_length_exponent_);
DCHECK(!values[18].IsEmpty());
}
if (hasUnitFactorLuminousIntensityExponent()) {
  values[19] = ToV8Traits<IDLByte>::ToV8(script_state, member_unit_factor_luminous_intensity_exponent_);
DCHECK(!values[19].IsEmpty());
}
if (hasUnitFactorMassExponent()) {
  values[20] = ToV8Traits<IDLByte>::ToV8(script_state, member_unit_factor_mass_exponent_);
DCHECK(!values[20].IsEmpty());
}
if (hasUnitFactorTemperatureExponent()) {
  values[21] = ToV8Traits<IDLByte>::ToV8(script_state, member_unit_factor_temperature_exponent_);
DCHECK(!values[21].IsEmpty());
}
if (hasUnitFactorTimeExponent()) {
  values[22] = ToV8Traits<IDLByte>::ToV8(script_state, member_unit_factor_time_exponent_);
DCHECK(!values[22].IsEmpty());
}
if (hasUnitSystem()) {
  values[23] = ToV8Traits<V8HIDUnitSystem>::ToV8(script_state, member_unit_system_);
DCHECK(!values[23].IsEmpty());
}
if (hasUsageMaximum()) {
  values[24] = ToV8Traits<IDLUnsignedLong>::ToV8(script_state, member_usage_maximum_);
DCHECK(!values[24].IsEmpty());
}
if (hasUsageMinimum()) {
  values[25] = ToV8Traits<IDLUnsignedLong>::ToV8(script_state, member_usage_minimum_);
DCHECK(!values[25].IsEmpty());
}
if (hasUsages()) {
  values[26] = ToV8Traits<IDLSequence<IDLUnsignedLong>>::ToV8(script_state, member_usages_);
DCHECK(!values[26].IsEmpty());
}
if (hasWrap()) {
  values[27] = ToV8Traits<IDLBoolean>::ToV8(script_state, member_wrap_);
DCHECK(!values[27].IsEmpty());
}
}

const void* HIDReportItem::TemplateKey() const {
  static const void *s_key = &s_key;
return s_key;
}

v8::Local<v8::Object> HIDReportItem::FillValues(ScriptState* script_state, v8::Local<v8::DictionaryTemplate> dict_template) const {
  v8::MaybeLocal<v8::Value> values[kTotalPropertyCount];
FillValuesImpl(script_state, values);
return dict_template->NewInstance(script_state->GetContext(), values);
}

void HIDReportItem::FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state) {
  TryRethrowScope rethrow_scope(isolate, exception_state);
const char* const class_like_name = "HIDReportItem";
DictionaryConversionContext dictionary_from_v8_context(isolate, class_like_name);
dictionary_from_v8_context.SetCurrentPropertyName("hasNull");
constexpr bool is_optional = false;
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
const auto& v8_own_member_names = GetV8OwnMemberNames(isolate);
if (!bindings::GetDictionaryMemberFromV8Object<IDLBoolean, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[0].Get(isolate), has_has_null_, member_has_null_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("hasPreferredState");
if (!bindings::GetDictionaryMemberFromV8Object<IDLBoolean, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[1].Get(isolate), has_has_preferred_state_, member_has_preferred_state_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("isAbsolute");
if (!bindings::GetDictionaryMemberFromV8Object<IDLBoolean, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[2].Get(isolate), has_is_absolute_, member_is_absolute_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("isArray");
if (!bindings::GetDictionaryMemberFromV8Object<IDLBoolean, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[3].Get(isolate), has_is_array_, member_is_array_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("isBufferedBytes");
if (!bindings::GetDictionaryMemberFromV8Object<IDLBoolean, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[4].Get(isolate), has_is_buffered_bytes_, member_is_buffered_bytes_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("isConstant");
if (!bindings::GetDictionaryMemberFromV8Object<IDLBoolean, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[5].Get(isolate), has_is_constant_, member_is_constant_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("isLinear");
if (!bindings::GetDictionaryMemberFromV8Object<IDLBoolean, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[6].Get(isolate), has_is_linear_, member_is_linear_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("isRange");
if (!bindings::GetDictionaryMemberFromV8Object<IDLBoolean, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[7].Get(isolate), has_is_range_, member_is_range_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("isVolatile");
if (!bindings::GetDictionaryMemberFromV8Object<IDLBoolean, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[8].Get(isolate), has_is_volatile_, member_is_volatile_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("logicalMaximum");
if (!bindings::GetDictionaryMemberFromV8Object<IDLLong, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[9].Get(isolate), has_logical_maximum_, member_logical_maximum_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("logicalMinimum");
if (!bindings::GetDictionaryMemberFromV8Object<IDLLong, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[10].Get(isolate), has_logical_minimum_, member_logical_minimum_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("physicalMaximum");
if (!bindings::GetDictionaryMemberFromV8Object<IDLLong, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[11].Get(isolate), has_physical_maximum_, member_physical_maximum_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("physicalMinimum");
if (!bindings::GetDictionaryMemberFromV8Object<IDLLong, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[12].Get(isolate), has_physical_minimum_, member_physical_minimum_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("reportCount");
if (!bindings::GetDictionaryMemberFromV8Object<IDLUnsignedShort, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[13].Get(isolate), has_report_count_, member_report_count_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("reportSize");
if (!bindings::GetDictionaryMemberFromV8Object<IDLUnsignedShort, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[14].Get(isolate), has_report_size_, member_report_size_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("strings");
if (!bindings::GetDictionaryMemberFromV8Object<IDLSequence<IDLString>, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[15].Get(isolate), has_strings_, member_strings_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("unitExponent");
if (!bindings::GetDictionaryMemberFromV8Object<IDLByte, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[16].Get(isolate), has_unit_exponent_, member_unit_exponent_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("unitFactorCurrentExponent");
if (!bindings::GetDictionaryMemberFromV8Object<IDLByte, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[17].Get(isolate), has_unit_factor_current_exponent_, member_unit_factor_current_exponent_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("unitFactorLengthExponent");
if (!bindings::GetDictionaryMemberFromV8Object<IDLByte, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[18].Get(isolate), has_unit_factor_length_exponent_, member_unit_factor_length_exponent_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("unitFactorLuminousIntensityExponent");
if (!bindings::GetDictionaryMemberFromV8Object<IDLByte, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[19].Get(isolate), has_unit_factor_luminous_intensity_exponent_, member_unit_factor_luminous_intensity_exponent_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("unitFactorMassExponent");
if (!bindings::GetDictionaryMemberFromV8Object<IDLByte, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[20].Get(isolate), has_unit_factor_mass_exponent_, member_unit_factor_mass_exponent_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("unitFactorTemperatureExponent");
if (!bindings::GetDictionaryMemberFromV8Object<IDLByte, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[21].Get(isolate), has_unit_factor_temperature_exponent_, member_unit_factor_temperature_exponent_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("unitFactorTimeExponent");
if (!bindings::GetDictionaryMemberFromV8Object<IDLByte, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[22].Get(isolate), has_unit_factor_time_exponent_, member_unit_factor_time_exponent_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("unitSystem");
if (!bindings::GetDictionaryMemberFromV8Object<V8HIDUnitSystem, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[23].Get(isolate), has_unit_system_, member_unit_system_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("usageMaximum");
if (!bindings::GetDictionaryMemberFromV8Object<IDLUnsignedLong, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[24].Get(isolate), has_usage_maximum_, member_usage_maximum_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("usageMinimum");
if (!bindings::GetDictionaryMemberFromV8Object<IDLUnsignedLong, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[25].Get(isolate), has_usage_minimum_, member_usage_minimum_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("usages");
if (!bindings::GetDictionaryMemberFromV8Object<IDLSequence<IDLUnsignedLong>, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[26].Get(isolate), has_usages_, member_usages_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("wrap");
if (!bindings::GetDictionaryMemberFromV8Object<IDLBoolean, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[27].Get(isolate), has_wrap_, member_wrap_, class_like_name, exception_state)) {
  return;
}
}

const base::span<const v8::Eternal<v8::Name>> HIDReportItem::GetV8OwnMemberNames(v8::Isolate* isolate) {
  return V8PerIsolateData::From(isolate)->FindOrCreateEternalNameCache(kOwnPropertyNames, kOwnPropertyNames);
}


}  // namespace blink
