// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_HID_DEVICE_REQUEST_OPTIONS_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_HID_DEVICE_REQUEST_OPTIONS_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"
#include "third_party/blink/renderer/platform/heap/collection_support/heap_vector.h"
#include "third_party/blink/renderer/platform/heap/member.h"

namespace blink {

class ExceptionState;
class HIDDeviceFilter;

class MODULES_EXPORT HIDDeviceRequestOptions : public bindings::InputDictionaryBase {
  
  public:
static HIDDeviceRequestOptions* Create() {
  return MakeGarbageCollected<HIDDeviceRequestOptions>();
}
static HIDDeviceRequestOptions* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<HIDDeviceRequestOptions>(isolate);
}
static HIDDeviceRequestOptions* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  HIDDeviceRequestOptions();
explicit  HIDDeviceRequestOptions(v8::Isolate* isolate);

bool hasExclusionFilters() const {
  return has_exclusion_filters_;
}
const HeapVector<Member<HIDDeviceFilter>>& exclusionFilters() const {
  DCHECK(hasExclusionFilters());
return member_exclusion_filters_;
}
HeapVector<Member<HIDDeviceFilter>> getExclusionFiltersOr(const HeapVector<Member<HIDDeviceFilter>>& fallback_value) const;
HeapVector<Member<HIDDeviceFilter>> getExclusionFiltersOr(HeapVector<Member<HIDDeviceFilter>>&& fallback_value) const;
void setExclusionFilters(const HeapVector<Member<HIDDeviceFilter>>& value);
void setExclusionFilters(HeapVector<Member<HIDDeviceFilter>>&& value);

bool hasFilters() const {
  return true;
}
const HeapVector<Member<HIDDeviceFilter>>& filters() const {
  return member_filters_;
}
void setFilters(const HeapVector<Member<HIDDeviceFilter>>& value);
void setFilters(HeapVector<Member<HIDDeviceFilter>>&& value);




void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 2;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_exclusion_filters_ = false;

HeapVector<Member<HIDDeviceFilter>> member_exclusion_filters_;
HeapVector<Member<HIDDeviceFilter>> member_filters_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_HID_DEVICE_REQUEST_OPTIONS_H_
