// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_HANDWRITING_HINTS_QUERY_RESULT_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_HANDWRITING_HINTS_QUERY_RESULT_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_handwriting_input_type.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_handwriting_recognition_type.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"
#include "third_party/blink/renderer/platform/heap/collection_support/heap_vector.h"

namespace blink {

class ExceptionState;

class MODULES_EXPORT HandwritingHintsQueryResult : public bindings::DictionaryBase {
  
  public:
static HandwritingHintsQueryResult* Create() {
  return MakeGarbageCollected<HandwritingHintsQueryResult>();
}
static HandwritingHintsQueryResult* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<HandwritingHintsQueryResult>(isolate);
}
static HandwritingHintsQueryResult* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  HandwritingHintsQueryResult();
explicit  HandwritingHintsQueryResult(v8::Isolate* isolate);

bool hasAlternatives() const {
  return has_alternatives_;
}
bool alternatives() const {
  DCHECK(hasAlternatives());
return member_alternatives_;
}
bool getAlternativesOr(bool fallback_value) const {
  if (!hasAlternatives()) {
  return fallback_value;
}
return member_alternatives_;
}
void setAlternatives(bool value) {
  member_alternatives_ = value;
has_alternatives_ = true;
}

bool hasInputType() const {
  return has_input_type_;
}
const Vector<V8HandwritingInputType>& inputType() const {
  DCHECK(hasInputType());
return member_input_type_;
}
Vector<V8HandwritingInputType> getInputTypeOr(const Vector<V8HandwritingInputType>& fallback_value) const;
Vector<V8HandwritingInputType> getInputTypeOr(Vector<V8HandwritingInputType>&& fallback_value) const;
void setInputType(const Vector<V8HandwritingInputType>& value);
void setInputType(Vector<V8HandwritingInputType>&& value);

bool hasRecognitionType() const {
  return has_recognition_type_;
}
const Vector<V8HandwritingRecognitionType>& recognitionType() const {
  DCHECK(hasRecognitionType());
return member_recognition_type_;
}
Vector<V8HandwritingRecognitionType> getRecognitionTypeOr(const Vector<V8HandwritingRecognitionType>& fallback_value) const;
Vector<V8HandwritingRecognitionType> getRecognitionTypeOr(Vector<V8HandwritingRecognitionType>&& fallback_value) const;
void setRecognitionType(const Vector<V8HandwritingRecognitionType>& value);
void setRecognitionType(Vector<V8HandwritingRecognitionType>&& value);

bool hasTextContext() const {
  return has_text_context_;
}
bool textContext() const {
  DCHECK(hasTextContext());
return member_text_context_;
}
bool getTextContextOr(bool fallback_value) const {
  if (!hasTextContext()) {
  return fallback_value;
}
return member_text_context_;
}
void setTextContext(bool value) {
  member_text_context_ = value;
has_text_context_ = true;
}




void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 4;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillTemplateProperties(Vector<std::string_view>& properties) const override;
void FillValuesImpl(ScriptState* script_state, base::span<v8::MaybeLocal<v8::Value>> values) const;


void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
const void* TemplateKey() const override;
v8::Local<v8::Object> FillValues(ScriptState* script_state, v8::Local<v8::DictionaryTemplate> dict_template) const override;
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_alternatives_ = false;
bool has_input_type_ = false;
bool has_recognition_type_ = false;
bool has_text_context_ = false;

bool member_alternatives_;
Vector<V8HandwritingInputType> member_input_type_;
Vector<V8HandwritingRecognitionType> member_recognition_type_;
bool member_text_context_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_HANDWRITING_HINTS_QUERY_RESULT_H_
